/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalogvalidator;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.lf5.LogLevel;

public class UniqOrderedMessageLogger {
    List<LogMessage> mOrderedUniqLogMessages = new ArrayList<LogMessage>();
    List<String> mUniqMessages = new ArrayList<String>();
    boolean mErrorsAreLogged = false;

    public void logMessage(LogMessage logMsg) {
        this.logMessage(logMsg.getMessage(), logMsg.getLogLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMessage(String msg, LogLevel lvl) {
        if (lvl == LogLevel.ERROR) {
            this.mErrorsAreLogged = true;
        }
        if (this.mUniqMessages.indexOf(msg) < 0) {
            this.mUniqMessages.add(msg);
            LogMessage newMsgToLog = new LogMessage(msg, lvl);
            List<LogMessage> list = this.mOrderedUniqLogMessages;
            synchronized (list) {
                this.mOrderedUniqLogMessages.add(newMsgToLog);
            }
        }
    }

    public boolean areErrorsLogged() {
        return this.mErrorsAreLogged;
    }

    public void writeOrderedMessages(BufferedWriter wtr) throws IOException {
        for (LogMessage nextMsg : this.mOrderedUniqLogMessages) {
            wtr.write(nextMsg.getLogLevel().getLabel() + "\t" + nextMsg.getMessage() + "\n");
        }
        wtr.flush();
    }

    protected class LogMessage {
        private String mMessage = null;
        private LogLevel mLogLevel = null;

        public LogMessage(String msg, LogLevel logLevel) {
            this.setMessage(msg, logLevel);
        }

        public String getMessage() {
            return this.mMessage;
        }

        public LogLevel getLogLevel() {
            return this.mLogLevel;
        }

        public void setMessage(String msg, LogLevel logLevel) {
            if (msg == null || msg.length() <= 0) {
                return;
            }
            this.mMessage = msg;
            this.mLogLevel = logLevel != null ? logLevel : LogLevel.WARNING;
        }
    }
}

