/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalogvalidator;

import edu.mayo.bior.catalog.HumanBuildAssembly;
import edu.mayo.bior.catalogvalidator.FileUtils;
import edu.mayo.bior.catalogvalidator.UniqOrderedMessageLogger;
import edu.mayo.bior.catalogvalidator.VerifyCatalogBase;
import edu.mayo.bior.catalogvalidator.VerifyCatalogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.lf5.LogLevel;

public class CatalogDataSource
extends Properties {
    public static String SHORT_NM_PROP_NM = "ShortUniqueName";
    public static String DESC_PROP_NM = "Description";
    public static String SOURCE_NM_PROP_NM = "Source";
    public static String DATASET_NM_PROP_NM = "Dataset";
    public static String VERSION_NM_PROP_NM = "Version";
    public static String BUILD_PROP_NM = "Build";
    public static String FORMAT_PROP_NM = "format";
    private List<String> reqPropNames = Arrays.asList(SHORT_NM_PROP_NM, DESC_PROP_NM, SOURCE_NM_PROP_NM, DATASET_NM_PROP_NM, VERSION_NM_PROP_NM, BUILD_PROP_NM, FORMAT_PROP_NM);
    private UniqOrderedMessageLogger mLogger = null;
    private HumanBuildAssembly mHumanBuildValue = null;
    private boolean mIsHuman = false;
    private boolean mIsVariant = false;
    private static final long serialVersionUID = 243L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CatalogDataSource(File datasourceFile, UniqOrderedMessageLogger logger) {
        this.mLogger = logger;
        BufferedReader rdr = null;
        try {
            if (datasourceFile == null) {
                return;
            }
            rdr = FileUtils.getBufferedReader(datasourceFile.getAbsolutePath());
            this.load(rdr);
        }
        catch (Exception e) {
            String err = "Exception reading data source properties file: " + e.getMessage();
            if (this.mLogger != null) {
                this.mLogger.logMessage(err, LogLevel.ERROR);
            }
            System.err.println(err);
        }
        finally {
            try {
                if (rdr != null) {
                    rdr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void verify(File catalogFile, String catalogListFileName, VerifyCatalogBase.VAL_TYPE valType) throws Exception {
        TreeMap<String, String> trackRequiredProps = new TreeMap<String, String>();
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.getProperty(key);
            if (this.reqPropNames.contains(key)) {
                trackRequiredProps.put(key, value);
                continue;
            }
            if (!key.equalsIgnoreCase(FORMAT_PROP_NM)) continue;
            trackRequiredProps.put(key, value);
        }
        if (trackRequiredProps.size() != this.reqPropNames.size()) {
            ArrayList<String> copyOfRequired = new ArrayList<String>();
            copyOfRequired.addAll(this.reqPropNames);
            copyOfRequired.removeAll(trackRequiredProps.keySet());
            this.mLogger.logMessage("All required datasource properties not found. Required properties not found: " + ((Object)copyOfRequired).toString(), LogLevel.ERROR);
        }
        String catalogVersion = null;
        for (Map.Entry eachEntry : trackRequiredProps.entrySet()) {
            String key = VerifyCatalogUtils.trim((String)eachEntry.getKey());
            String val = VerifyCatalogUtils.trim((String)eachEntry.getValue());
            if (key == null) {
                this.mLogger.logMessage("ERROR: Data source property has empty/invalid property name for value [" + val + "]", LogLevel.ERROR);
                continue;
            }
            if (key.equals(VERSION_NM_PROP_NM)) {
                if (VerifyCatalogUtils.isEmpty(val)) {
                    this.mLogger.logMessage("Data source property [" + key + "] must have a value always.", LogLevel.ERROR);
                    continue;
                }
                catalogVersion = val;
                this.mLogger.logMessage("Data source property [" + key + "]: value is: " + catalogVersion, LogLevel.INFO);
            }
            if (key.equals(BUILD_PROP_NM)) {
                if (VerifyCatalogUtils.isEmpty(val)) {
                    if (valType.name().equals((Object)VerifyCatalogBase.VAL_TYPE.STRICT)) {
                        this.mLogger.logMessage("Data source property [" + key + "] must have a value when strict checking enabled.", LogLevel.ERROR);
                        continue;
                    }
                } else {
                    if (val.toLowerCase().startsWith(HumanBuildAssembly.GRCh37.name().toLowerCase())) {
                        this.mHumanBuildValue = HumanBuildAssembly.GRCh37;
                        this.mIsHuman = true;
                    } else if (val.toLowerCase().startsWith(HumanBuildAssembly.GRCh38.name().toLowerCase())) {
                        this.mHumanBuildValue = HumanBuildAssembly.GRCh38;
                        this.mIsHuman = true;
                    }
                    this.mLogger.logMessage("Data source property [" + key + "]: input value is: " + val, LogLevel.INFO);
                }
            }
            if (key.equals(DATASET_NM_PROP_NM) && val.toLowerCase().contains("variant")) {
                this.mLogger.logMessage("Data source property [" + key + "]: input value is [" + val + "]. Setting catalog to a variant catalog.", LogLevel.INFO);
                this.mIsVariant = true;
            }
            if (key.equals(DESC_PROP_NM) && valType.name().equals((Object)VerifyCatalogBase.VAL_TYPE.STRICT) && VerifyCatalogUtils.isEmpty(val)) {
                this.mLogger.logMessage("Data source property [" + key + "] must have a value when strict checking enabled.", LogLevel.ERROR);
                continue;
            }
            if (key.equalsIgnoreCase(FORMAT_PROP_NM) && !((String)eachEntry.getValue()).equals("1.1.0")) {
                this.mLogger.logMessage(FORMAT_PROP_NM + " value for datasource property " + FORMAT_PROP_NM + " is not supported currently: " + val, LogLevel.ERROR);
            }
            if (!key.equals(SHORT_NM_PROP_NM)) continue;
            this.checkShortUniqueName(catalogFile, val, catalogListFileName);
        }
        if (this.getHumanBuildValue() == null) {
            this.mLogger.logMessage("Catalog Human Genome Build was not determined from Datasource Properties file. Will not validate chromosome or variant related elements of catalog: " + catalogFile.getAbsolutePath(), LogLevel.WARN);
        } else {
            this.mLogger.logMessage("Catalog is based on Human Genome Build [" + this.getHumanBuildValue().name() + "]. Will check chromosomes, positions, and reference alleles accordingly.", LogLevel.INFO);
        }
    }

    public HumanBuildAssembly getHumanBuildValue() {
        return this.mHumanBuildValue;
    }

    public boolean isHumanCatalog() {
        return this.mIsHuman;
    }

    public boolean isVariantCatalog() {
        return this.mIsVariant;
    }

    private void checkShortUniqueName(File ourCatalogFile, String ourShortUniqueNm, String catalogList) throws Exception {
        if (!new File(catalogList).exists()) {
            this.mLogger.logMessage("Cannot check catalog short name value [" + ourShortUniqueNm + "]. Catalog list file specified does not exist: " + catalogList, LogLevel.WARNING);
            return;
        }
        try {
            BufferedReader catListRdr = FileUtils.getBufferedReader(catalogList);
            File currentCatListFile = null;
            String ln = null;
            while ((ln = catListRdr.readLine()) != null) {
                if (ln.startsWith("#")) continue;
                String[] elems = ln.split("\t");
                if (elems.length != 5) {
                    this.mLogger.logMessage("Unexpected file format for catalog list file. Please verify correct file passed: " + catalogList, LogLevel.ERROR);
                    continue;
                }
                String catFileNm = elems[1];
                String catShortNm = elems[3];
                if (VerifyCatalogUtils.isEmpty(catFileNm)) {
                    this.mLogger.logMessage("Catalog file specified  [" + catFileNm + "] in catalog list is empty. Catalog list file entry: " + ln, LogLevel.WARNING);
                    continue;
                }
                currentCatListFile = new File(catFileNm);
                if (currentCatListFile == null || !currentCatListFile.exists()) {
                    this.mLogger.logMessage("Catalog file specified  [" + catFileNm + "] in catalog list doesn't exist. Catalog list file: " + catalogList, LogLevel.WARNING);
                    continue;
                }
                if (VerifyCatalogUtils.isEmpty(catShortNm)) {
                    this.mLogger.logMessage("WARNING: No Short name for catalog entry. Cannot check short-name [" + ourShortUniqueNm + "] against catalog list entry: " + ln, LogLevel.WARNING);
                    continue;
                }
                if (ourCatalogFile.getCanonicalPath().equals(currentCatListFile.getCanonicalPath())) continue;
                this.mLogger.logMessage("WARNING: Catalog files have same short unique name: " + ourShortUniqueNm + " \n" + " Our catalog file: " + ourCatalogFile.getCanonicalPath() + "\n" + " Catalog List entry with same short unique name value: " + currentCatListFile.getCanonicalPath() + "\n" + " Short Unique Name value: " + catShortNm + "\n" + " Catalog List file: " + catalogList, LogLevel.WARNING);
            }
        }
        catch (Exception exc) {
            this.mLogger.logMessage("Exception raised while checking data source property short unique name. exc: " + exc.getMessage(), LogLevel.WARNING);
            exc.printStackTrace();
        }
    }
}

