/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalogremoveduplicates;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.history.History;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;

public class CatalogRemoveDuplicatesPipe
extends AbstractPipe<History, History> {
    List<String> mJsonPathsToCompareForDuplicates = new ArrayList<String>();
    boolean mIsMatchOnAnyArrayElements = false;
    List<String> mRegionsToSkip = new ArrayList<String>();
    private List<History> mLinesWithSameCoordsBuffer = new ArrayList<History>();
    private History mLastLine = null;
    private long mLineNum = 0L;

    public CatalogRemoveDuplicatesPipe(List<String> jsonPathsToCompare, boolean isCompareAnyInSubset, List<String> regionsToSkip) {
        this.mJsonPathsToCompareForDuplicates = jsonPathsToCompare;
        this.mIsMatchOnAnyArrayElements = isCompareAnyInSubset;
        this.mRegionsToSkip = regionsToSkip;
    }

    protected History processNextStart() throws NoSuchElementException {
        try {
            if (!this.starts.hasNext() && this.mLinesWithSameCoordsBuffer.size() == 0 && this.mLastLine == null) {
                throw new NoSuchElementException();
            }
            if (this.mLinesWithSameCoordsBuffer.size() > 0) {
                return this.mLinesWithSameCoordsBuffer.remove(0);
            }
            if (this.mLastLine != null) {
                this.mLinesWithSameCoordsBuffer.add(this.mLastLine);
                this.mLastLine = null;
            }
            while (this.starts.hasNext()) {
                ++this.mLineNum;
                this.mLastLine = (History)this.starts.next();
                if (this.isRegionToSkip(this.mLastLine) || this.mLinesWithSameCoordsBuffer.size() > 0 && !this.isSameRegionAsBuffer(this.mLastLine)) break;
                if (!this.isAMatchAlreadyInBuffer(this.mLastLine)) {
                    this.addLineToBuffer(this.mLastLine);
                }
                this.mLastLine = null;
            }
            if (this.mLinesWithSameCoordsBuffer.size() > 0) {
                return this.mLinesWithSameCoordsBuffer.remove(0);
            }
            return this.processNextStart();
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            throw new NoSuchElementException(e.getMessage());
        }
    }

    private boolean isSameRegionAsBuffer(History line) {
        if (this.mLinesWithSameCoordsBuffer.size() == 0) {
            return false;
        }
        return this.isLinesAtSameCoords(line, this.mLinesWithSameCoordsBuffer.get(0));
    }

    private boolean isRegionToSkip(History line) {
        String chrom = (String)line.get(0);
        long start = Long.parseLong((String)line.get(1));
        long end = Long.parseLong((String)line.get(2));
        for (String region : this.mRegionsToSkip) {
            String[] parts = region.split(":|-");
            String regionChrom = parts[0];
            long regionStart = 0L;
            long regionEnd = Long.MAX_VALUE;
            if (parts.length > 1) {
                regionStart = Long.parseLong(parts[1]);
            }
            if (parts.length > 2) {
                regionEnd = Long.parseLong(parts[2]);
            }
            boolean isBeforeRegion = end < regionStart;
            boolean isAfterRegion = start > regionEnd;
            boolean isWithinRegion = chrom.equalsIgnoreCase(regionChrom) && !isBeforeRegion && !isAfterRegion;
            if (!isWithinRegion) continue;
            return true;
        }
        return false;
    }

    private boolean isLinesAtSameCoords(History line1, History line2) {
        boolean isSameChrom = ((String)line1.get(0)).equalsIgnoreCase((String)line2.get(0));
        boolean isSameMinBp = ((String)line1.get(1)).equals(line2.get(1));
        boolean isSameMaxBp = ((String)line1.get(2)).equals(line2.get(2));
        return isSameChrom && isSameMinBp && isSameMaxBp;
    }

    private void addLineToBuffer(History line) {
        if (line == null || line.size() == 1 && ((String)line.get(0)).trim().length() == 0) {
            System.err.println("Warning: empty line encountered at line " + this.mLineNum);
        } else if (line.size() < 4) {
            System.err.println("ERROR:  Catalog line does not contain the required 4 columns: CHROM  MIN  MAX  JSON.  Line #" + this.mLineNum);
        } else {
            this.mLinesWithSameCoordsBuffer.add(line);
        }
    }

    private boolean isAMatchAlreadyInBuffer(History lineToChk) throws Exception {
        for (int i = 0; i < this.mLinesWithSameCoordsBuffer.size(); ++i) {
            History lineInBuffer = this.mLinesWithSameCoordsBuffer.get(i);
            if (!this.isLinesAtSameCoords(lineToChk, lineInBuffer) || !this.isMatchOnJsonKeys(lineToChk, lineInBuffer)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchOnJsonKeys(History line1, History line2) throws JsonProcessingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        int JSON_COL_INDEX = 3;
        JsonNode tree1 = mapper.readTree((String)line1.get(3));
        JsonNode tree2 = mapper.readTree((String)line2.get(3));
        for (String jsonPath : this.mJsonPathsToCompareForDuplicates) {
            JsonNode val2;
            JsonNode val1 = tree1.get(jsonPath);
            if (this.isJsonNodesEqual(val1, val2 = tree2.get(jsonPath))) continue;
            return false;
        }
        return true;
    }

    private boolean isJsonNodesEqual(JsonNode val1, JsonNode val2) {
        if (val1 == null) {
            return val2 == null;
        }
        if (this.mIsMatchOnAnyArrayElements && val1.isArray() && val2.isArray()) {
            ArrayNode array1 = (ArrayNode)val1;
            ArrayNode array2 = (ArrayNode)val2;
            for (int i = 0; i < array1.size(); ++i) {
                for (int j = 0; j < array2.size(); ++j) {
                    if (!array1.get(i).equals((Object)array2.get(j))) continue;
                    return true;
                }
            }
            return false;
        }
        return val1.equals((Object)val2);
    }
}

