/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class StepLogger {
    private static Logger sLogger = Logger.getLogger(StepLogger.class);
    private File mLogFile;
    private File mSummaryFile;
    private PrintWriter mLogWriter;
    private PrintWriter mSummaryWriter;
    protected static final String DATE_FORMAT_STR = "yyyy-MM-dd HH:mm:ss  ";
    private SimpleDateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss  ");
    public static final String PROGRESS_SUBDIR = ".build/progress";

    public StepLogger(String stepFilePrefix) throws IOException {
        this(stepFilePrefix, new File(".").getCanonicalFile());
    }

    public StepLogger(String stepFilePrefix, File catalogOutputDirectory) throws IOException {
        File logDir = new File(catalogOutputDirectory, PROGRESS_SUBDIR);
        logDir.mkdirs();
        this.mLogFile = new File(logDir, stepFilePrefix + ".log");
        this.mSummaryFile = new File(logDir, stepFilePrefix + ".summary");
        this.mLogWriter = new PrintWriter(this.mLogFile);
        this.mSummaryWriter = new PrintWriter(this.mSummaryFile);
    }

    public void log(String msg) {
        this.mLogWriter.println(this.mDateFormat.format(new Date()) + msg);
        this.mLogWriter.flush();
        sLogger.info((Object)msg);
    }

    public void summary(String msg) {
        System.err.println(msg);
        this.mSummaryWriter.println(msg);
        this.mSummaryWriter.flush();
    }

    public void logAndSummary(String msg) {
        this.log(msg);
        this.summary(msg);
    }

    public String getSummary() throws IOException {
        if (this.mSummaryFile.exists()) {
            return FileUtils.readFileToString((File)this.mSummaryFile);
        }
        return "";
    }

    public File getLogFile() {
        return this.mLogFile;
    }

    public File getSummaryFile() {
        return this.mSummaryFile;
    }

    public void closeLogWriters() {
        if (this.mLogWriter != null) {
            this.mLogWriter.flush();
            this.mLogWriter.close();
        }
        if (this.mSummaryWriter != null) {
            this.mSummaryWriter.flush();
            this.mSummaryWriter.close();
        }
    }
}

