/*
 * Decompiled with CFR 0.152.
 */
package flanagan.optics;

import flanagan.analysis.ErrorProp;
import flanagan.optics.PlanarWaveguide;
import flanagan.optics.RefractiveIndex;

public class GratingCoupler
extends PlanarWaveguide {
    private double[] thicknessesTE = null;
    private double[] anglesDegTE = null;
    private double[] anglesRadTE = null;
    private double[] errorsDegTE = null;
    private double[] errorsRadTE = null;
    private double[] modeNumbersTE = null;
    private double[] effectiveRefractiveIndicesTE = null;
    private double[] effectiveErrorsTE = null;
    private int numberOfTEmeasurementsGrating = 0;
    private boolean setMeasurementsTEgrating = false;
    private boolean setTEerrors = false;
    private boolean calcEffectiveDone = false;
    private double[] thicknessesTM = null;
    private double[] anglesDegTM = null;
    private double[] anglesRadTM = null;
    private double[] errorsDegTM = null;
    private double[] errorsRadTM = null;
    private double[] modeNumbersTM = null;
    private double[] effectiveRefractiveIndicesTM = null;
    private double[] effectiveErrorsTM = null;
    private int numberOfTMmeasurementsGrating = 0;
    private boolean setMeasurementsTMgrating = false;
    private boolean setTMerrors = false;
    private int numberOfMeasurementsGrating = 0;
    private boolean setMeasurementsGrating = false;
    private double gratingPitch = 0.0;
    private boolean setGratingPitch = false;
    private int[] gratingOrderTE = null;
    private boolean setGratingOrderTE = false;
    private int[] gratingOrderTM = null;
    private boolean setGratingOrderTM = false;
    private double superstrateRI = 0.0;
    private boolean setSuperstrateRI = false;

    public void setGratingPitch(double pitch) {
        this.gratingPitch = pitch;
        this.setGratingPitch = true;
        if (this.setMeasurementsGrating && this.setWavelength) {
            this.calcEffectiveRefractiveIndices();
        }
    }

    public void setSetTEmodeGratingOrder(int[] order) {
        this.gratingOrderTE = order;
        int m = order.length;
        if (this.setMeasurementsTEgrating && m != this.numberOfTEmeasurementsGrating) {
            throw new IllegalArgumentException("Number of grating orders entered, " + m + ", is not equal to the number of measurements previously entered, " + this.numberOfTEmeasurementsGrating);
        }
        if (this.setMeasurementsGrating && this.setGratingPitch && this.setWavelength) {
            this.calcEffectiveRefractiveIndices();
        }
    }

    public void setSetTMmodeGratingOrder(int[] order) {
        this.gratingOrderTM = order;
        int m = order.length;
        if (this.setMeasurementsTMgrating && m != this.numberOfTMmeasurementsGrating) {
            throw new IllegalArgumentException("Number of grating orders entered, " + m + ", is not equal to the number of measurements previously entered, " + this.numberOfTEmeasurementsGrating);
        }
        if (this.setMeasurementsGrating && this.setGratingPitch && this.setWavelength) {
            this.calcEffectiveRefractiveIndices();
        }
    }

    @Override
    public void setSuperstrateRefractiveIndex(double index) {
        if (this.calcEffectiveDone) {
            this.clearData();
        }
        this.superstrateRI = index;
        this.superstrateRefractiveIndex = index;
        this.setSuperstrateRI = true;
        if (this.setMeasurementsGrating && this.setGratingPitch && this.setWavelength) {
            this.calcEffectiveRefractiveIndices();
        }
    }

    public double getAnalyteSolutionRefractiveIndex() {
        return super.getSuperstrateRefractiveIndex();
    }

    public double getStandardDeviationAnalyteSolutionRefractiveIndex() {
        return super.getStandardDeviationSuperstrateRefractiveIndex();
    }

    @Override
    public void enterTEmodeData(double thickness, double angle, double modeNumber) {
        if (this.setMeasurementsTEgrating) {
            int i;
            if (this.setTEerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTEmeasurementsGrating + 1;
            double[] hold = new double[nNew];
            for (i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                hold[i] = this.thicknessesTE[i];
            }
            hold[this.numberOfTEmeasurementsGrating] = thickness;
            this.thicknessesTE = hold;
            for (i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                hold[i] = this.anglesDegTE[i];
            }
            hold[this.numberOfTEmeasurementsGrating] = angle;
            this.anglesDegTE = hold;
            this.anglesRadTE = hold;
            this.errorsDegTE = hold;
            this.errorsRadTE = hold;
            for (i = 0; i < nNew; ++i) {
                this.anglesRadTE[i] = Math.toRadians(this.anglesDegTE[i]);
                this.errorsDegTE[i] = 0.0;
                this.errorsRadTE[i] = 0.0;
            }
            for (i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                hold[i] = this.modeNumbersTE[i];
            }
            hold[this.numberOfTEmeasurementsGrating] = modeNumber;
            this.numberOfTEmeasurementsGrating = nNew;
        } else {
            this.thicknessesTE = new double[1];
            this.thicknessesTE[0] = thickness;
            this.anglesDegTE = new double[1];
            this.anglesDegTE[0] = angle;
            this.anglesRadTE = new double[1];
            this.anglesRadTE[0] = Math.toRadians(angle);
            this.errorsDegTE = new double[1];
            this.errorsDegTE[0] = 0.0;
            this.errorsRadTE = new double[1];
            this.errorsRadTE[0] = 0.0;
            this.modeNumbersTE = new double[1];
            this.modeNumbersTE[0] = modeNumber;
            this.numberOfTEmeasurementsGrating = 1;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTEgrating = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double thickness, double angle, double modeNumber) {
        if (this.setMeasurementsTMgrating) {
            int i;
            if (this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTMmeasurementsGrating + 1;
            double[] hold = new double[nNew];
            for (i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                hold[i] = this.thicknessesTM[i];
            }
            hold[this.numberOfTMmeasurementsGrating] = thickness;
            this.thicknessesTM = hold;
            for (i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                hold[i] = this.anglesDegTM[i];
            }
            hold[this.numberOfTMmeasurementsGrating] = angle;
            this.anglesDegTM = hold;
            this.anglesRadTM = hold;
            this.errorsDegTM = hold;
            this.errorsRadTM = hold;
            for (i = 0; i < nNew; ++i) {
                this.anglesRadTM[i] = Math.toRadians(this.anglesDegTM[i]);
                this.errorsDegTM[i] = 0.0;
                this.errorsRadTM[i] = 0.0;
            }
            for (i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                hold[i] = this.modeNumbersTM[i];
            }
            hold[this.numberOfTMmeasurementsGrating] = modeNumber;
            this.numberOfTMmeasurementsGrating = nNew;
        } else {
            this.thicknessesTM = new double[1];
            this.thicknessesTM[0] = thickness;
            this.anglesDegTM = new double[1];
            this.anglesDegTM[0] = angle;
            this.anglesRadTM = new double[1];
            this.anglesRadTM[0] = Math.toRadians(angle);
            this.errorsDegTM = new double[1];
            this.errorsDegTM[0] = 0.0;
            this.errorsRadTM = new double[1];
            this.errorsRadTM[0] = 0.0;
            this.modeNumbersTM = new double[1];
            this.modeNumbersTM[0] = modeNumber;
            this.numberOfTMmeasurementsGrating = 1;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTMgrating = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTEmodeData(double[] thicknesses, double[] angles, double[] modeNumbers) {
        int n = angles.length;
        int o = thicknesses.length;
        if (n != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of coupling angles, " + n);
        }
        int m = modeNumbers.length;
        if (m != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of mode numbers, " + m);
        }
        if (this.setMeasurementsTEgrating) {
            int i;
            if (this.setTEerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTEmeasurementsGrating + o;
            double[] hold = new double[nNew];
            for (i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                hold[i] = this.thicknessesTE[i];
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTEmeasurementsGrating + i] = thicknesses[i];
            }
            this.thicknessesTE = hold;
            for (i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                hold[i] = this.anglesDegTE[i];
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTEmeasurementsGrating + i] = angles[i];
            }
            this.anglesDegTE = hold;
            this.anglesRadTE = hold;
            this.errorsDegTE = hold;
            this.errorsRadTE = hold;
            for (i = 0; i < nNew; ++i) {
                this.anglesRadTE[i] = Math.toRadians(this.anglesDegTE[i]);
                this.errorsDegTE[i] = 0.0;
                this.errorsRadTE[i] = 0.0;
            }
            for (i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                hold[i] = this.modeNumbersTE[i];
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTEmeasurementsGrating + i] = modeNumbers[i];
            }
            this.numberOfTEmeasurementsGrating = nNew;
        } else {
            this.numberOfTEmeasurementsGrating = o;
            this.thicknessesTE = thicknesses;
            this.anglesDegTE = angles;
            this.anglesRadTE = new double[o];
            this.errorsDegTE = new double[o];
            this.errorsRadTE = new double[o];
            for (int i = 0; i < o; ++i) {
                this.anglesRadTE[i] = Math.toRadians(angles[i]);
                this.errorsDegTE[i] = 0.0;
                this.errorsRadTE[i] = 0.0;
            }
            this.modeNumbersTE = modeNumbers;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTEgrating = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double[] thicknesses, double[] angles, double[] modeNumbers) {
        int n = angles.length;
        int o = thicknesses.length;
        if (n != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of coupling angles, " + n);
        }
        int m = modeNumbers.length;
        if (m != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of mode numbers, " + m);
        }
        if (this.setMeasurementsTMgrating) {
            int i;
            if (this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTMmeasurementsGrating + o;
            double[] hold = new double[nNew];
            for (i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                hold[i] = this.thicknessesTM[i];
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTMmeasurementsGrating + i] = thicknesses[i];
            }
            this.thicknessesTM = hold;
            for (i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                hold[i] = this.anglesDegTM[i];
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTMmeasurementsGrating + i] = angles[i];
            }
            this.anglesDegTM = hold;
            this.anglesRadTM = hold;
            this.errorsDegTM = hold;
            this.errorsRadTM = hold;
            for (i = 0; i < nNew; ++i) {
                this.anglesRadTM[i] = Math.toRadians(this.anglesDegTM[i]);
                this.errorsDegTM[i] = 0.0;
                this.errorsRadTM[i] = 0.0;
            }
            for (i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                hold[i] = this.modeNumbersTM[i];
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTMmeasurementsGrating + i] = modeNumbers[i];
            }
            this.numberOfTMmeasurementsGrating = nNew;
        } else {
            this.numberOfTMmeasurementsGrating = o;
            this.thicknessesTM = thicknesses;
            this.anglesDegTM = angles;
            this.anglesRadTM = new double[o];
            this.errorsDegTM = new double[o];
            this.errorsRadTM = new double[o];
            for (int i = 0; i < o; ++i) {
                this.anglesRadTM[i] = Math.toRadians(angles[i]);
                this.errorsDegTM[i] = 0.0;
                this.errorsRadTM[i] = 0.0;
            }
            this.modeNumbersTM = modeNumbers;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTMgrating = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTEmodeData(double thickness, double angle, double error, double modeNumber) {
        if (this.setMeasurementsTEgrating) {
            int i;
            if (!this.setTEerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTEmeasurementsGrating + 1;
            double[] hold = new double[nNew];
            for (i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                hold[i] = this.thicknessesTE[i];
            }
            hold[this.numberOfTEmeasurementsGrating] = thickness;
            this.thicknessesTE = hold;
            for (i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                hold[i] = this.anglesDegTE[i];
            }
            hold[this.numberOfTEmeasurementsGrating] = angle;
            this.anglesDegTE = hold;
            for (i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                hold[i] = this.errorsDegTE[i];
            }
            hold[this.numberOfTEmeasurementsGrating] = error;
            this.errorsDegTE = hold;
            this.anglesRadTE = hold;
            this.errorsRadTE = hold;
            for (i = 0; i < nNew; ++i) {
                this.anglesRadTE[i] = Math.toRadians(this.anglesDegTE[i]);
                this.errorsRadTE[i] = Math.toRadians(this.errorsDegTE[i]);
            }
            for (i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                hold[i] = this.modeNumbersTE[i];
            }
            hold[this.numberOfTEmeasurementsGrating] = modeNumber;
            this.numberOfTEmeasurementsGrating = nNew;
        } else {
            this.thicknessesTE = new double[1];
            this.thicknessesTE[0] = thickness;
            this.anglesDegTE = new double[1];
            this.anglesDegTE[0] = angle;
            this.anglesRadTE = new double[1];
            this.anglesRadTE[0] = Math.toRadians(angle);
            this.errorsDegTE = new double[1];
            this.errorsDegTE[0] = error;
            this.errorsRadTE = new double[1];
            this.errorsRadTE[0] = Math.toRadians(error);
            this.modeNumbersTE = new double[1];
            this.modeNumbersTE[0] = modeNumber;
            this.numberOfTEmeasurementsGrating = 1;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTEgrating = true;
        this.setTEerrors = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double thickness, double angle, double error, double modeNumber) {
        if (this.setMeasurementsTMgrating) {
            int i;
            if (!this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTMmeasurementsGrating + 1;
            double[] hold = new double[nNew];
            for (i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                hold[i] = this.thicknessesTM[i];
            }
            hold[this.numberOfTMmeasurementsGrating] = thickness;
            this.thicknessesTM = hold;
            for (i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                hold[i] = this.anglesDegTM[i];
            }
            hold[this.numberOfTMmeasurementsGrating] = angle;
            this.anglesDegTM = hold;
            for (i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                hold[i] = this.errorsDegTM[i];
            }
            hold[this.numberOfTMmeasurementsGrating] = error;
            this.errorsDegTM = hold;
            this.anglesRadTM = hold;
            this.errorsRadTM = hold;
            for (i = 0; i < nNew; ++i) {
                this.anglesRadTM[i] = Math.toRadians(this.anglesDegTM[i]);
                this.errorsRadTM[i] = Math.toRadians(this.errorsDegTM[i]);
            }
            for (i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                hold[i] = this.modeNumbersTM[i];
            }
            hold[this.numberOfTMmeasurementsGrating] = modeNumber;
            this.numberOfTMmeasurementsGrating = nNew;
        } else {
            this.thicknessesTM = new double[1];
            this.thicknessesTM[0] = thickness;
            this.anglesDegTM = new double[1];
            this.anglesDegTM[0] = angle;
            this.anglesRadTM = new double[1];
            this.anglesDegTM[0] = Math.toRadians(angle);
            this.errorsDegTM = new double[1];
            this.errorsDegTM[0] = error;
            this.errorsRadTM = new double[1];
            this.errorsDegTM[0] = Math.toRadians(error);
            this.modeNumbersTM = new double[1];
            this.modeNumbersTM[0] = modeNumber;
            this.numberOfTMmeasurementsGrating = 1;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTMgrating = true;
        this.setTMerrors = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTEmodeData(double[] thicknesses, double[] angles, double[] errors, double[] modeNumbers) {
        int n = angles.length;
        int o = thicknesses.length;
        if (n != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of coupling angles, " + n);
        }
        int m = modeNumbers.length;
        if (m != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of mode numbers, " + m);
        }
        if (this.setMeasurementsTEgrating) {
            int i;
            if (!this.setTEerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTEmeasurementsGrating + o;
            double[] hold = new double[nNew];
            for (i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                hold[i] = this.thicknessesTE[i];
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTEmeasurementsGrating + i] = thicknesses[i];
            }
            this.thicknessesTE = hold;
            for (i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                hold[i] = this.anglesDegTE[i];
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTEmeasurementsGrating + i] = angles[i];
            }
            this.anglesDegTE = hold;
            for (i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                hold[i] = this.errorsDegTE[i];
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTEmeasurementsGrating + i] = errors[i];
            }
            this.errorsDegTE = hold;
            this.anglesRadTE = hold;
            this.errorsRadTE = hold;
            for (i = 0; i < nNew; ++i) {
                this.anglesRadTE[i] = Math.toRadians(this.anglesDegTE[i]);
                this.errorsRadTE[i] = Math.toRadians(this.errorsDegTE[i]);
            }
            for (i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                hold[i] = this.modeNumbersTE[i];
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTEmeasurementsGrating + i] = modeNumbers[i];
            }
            this.numberOfTEmeasurementsGrating = nNew;
        } else {
            this.numberOfTEmeasurementsGrating = o;
            this.thicknessesTE = thicknesses;
            this.anglesDegTE = angles;
            this.anglesRadTE = new double[o];
            this.errorsDegTE = errors;
            this.errorsRadTE = new double[o];
            for (int i = 0; i < o; ++i) {
                this.anglesRadTE[i] = Math.toRadians(angles[i]);
                this.errorsRadTE[i] = Math.toRadians(errors[i]);
            }
            this.modeNumbersTE = modeNumbers;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTEgrating = true;
        this.setTEerrors = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double[] thicknesses, double[] angles, double[] errors, double[] modeNumbers) {
        int n = angles.length;
        int o = thicknesses.length;
        if (n != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of coupling angles, " + n);
        }
        int m = modeNumbers.length;
        if (m != o) {
            throw new IllegalArgumentException("number of thicknesses, " + o + ", does not equal the number of mode numbers, " + m);
        }
        if (this.setMeasurementsTMgrating) {
            int i;
            if (!this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int nNew = this.numberOfTMmeasurementsGrating + o;
            double[] hold = new double[nNew];
            for (i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                hold[i] = this.thicknessesTM[i];
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTMmeasurementsGrating + i] = thicknesses[i];
            }
            this.thicknessesTM = hold;
            for (i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                hold[i] = this.anglesDegTM[i];
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTMmeasurementsGrating + i] = angles[i];
            }
            this.anglesDegTM = hold;
            for (i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                hold[i] = this.errorsDegTM[i];
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTMmeasurementsGrating + i] = errors[i];
            }
            this.errorsDegTM = hold;
            this.anglesRadTM = hold;
            this.errorsRadTM = hold;
            for (i = 0; i < nNew; ++i) {
                this.anglesRadTM[i] = Math.toRadians(this.anglesDegTM[i]);
                this.errorsRadTM[i] = Math.toRadians(this.errorsDegTM[i]);
            }
            for (i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                hold[i] = this.modeNumbersTM[i];
            }
            for (i = 0; i < o; ++i) {
                hold[this.numberOfTMmeasurementsGrating + i] = modeNumbers[i];
            }
            this.numberOfTMmeasurementsGrating = nNew;
        } else {
            this.numberOfTMmeasurementsGrating = o;
            this.thicknessesTM = thicknesses;
            this.anglesDegTM = angles;
            this.errorsDegTM = errors;
            this.anglesRadTM = new double[o];
            this.errorsRadTM = new double[o];
            for (int i = 0; i < o; ++i) {
                this.anglesRadTM[i] = Math.toRadians(angles[i]);
                this.errorsRadTM[i] = Math.toRadians(errors[i]);
            }
            this.modeNumbersTM = modeNumbers;
        }
        this.numberOfMeasurementsGrating = this.numberOfTEmeasurementsGrating + this.numberOfTMmeasurementsGrating;
        this.setMeasurementsTMgrating = true;
        this.setTMerrors = true;
        this.setMeasurementsGrating = true;
        if (this.setGratingPitch && this.setWavelength) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void clearData() {
        this.numberOfTEmeasurementsGrating = 0;
        this.setMeasurementsTEgrating = false;
        this.numberOfTMmeasurementsGrating = 0;
        this.setMeasurementsTMgrating = false;
        this.numberOfMeasurements = 0;
        this.setMeasurements = false;
        this.setWeights = false;
        this.numberOfTEmeasurements = 0;
        this.setMeasurementsTE = false;
        this.numberOfTMmeasurements = 0;
        this.setMeasurementsTM = false;
    }

    public void calcEffectiveRefractiveIndices() {
        if (this.setMeasurementsTEgrating) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
        if (this.setMeasurementsTMgrating) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    public void calcTEmodeEffectiveRefractiveIndices() {
        this.effectiveRefractiveIndicesTE = new double[this.numberOfTEmeasurementsGrating];
        this.effectiveErrorsTE = new double[this.numberOfTEmeasurementsGrating];
        if (!this.setSuperstrateRI) {
            this.superstrateRI = RefractiveIndex.air(this.wavelength);
            this.superstrateRefractiveIndex = RefractiveIndex.air(this.wavelength);
        }
        if (this.setTEerrors) {
            ErrorProp superRI = new ErrorProp(this.superstrateRefractiveIndex, 0.0);
            ErrorProp pitch = new ErrorProp(this.gratingPitch, 0.0);
            ErrorProp lambda = new ErrorProp(this.wavelength, 0.0);
            for (int i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                ErrorProp theta = new ErrorProp(this.anglesRadTM[i], this.errorsRadTM[i]);
                ErrorProp order = new ErrorProp(this.gratingOrderTE[i], 0.0);
                ErrorProp calc = ErrorProp.sin(theta);
                calc = calc.times(superRI);
                calc = calc.plus(lambda.times(order).over(pitch));
                this.effectiveRefractiveIndicesTE[i] = calc.getValue();
                this.effectiveErrorsTE[i] = calc.getError();
            }
            super.enterTEmodeData(this.thicknessesTE, this.effectiveRefractiveIndicesTE, this.effectiveErrorsTE, this.modeNumbersTE);
        } else {
            for (int i = 0; i < this.numberOfTEmeasurementsGrating; ++i) {
                this.effectiveRefractiveIndicesTE[i] = this.superstrateRI * Math.sin(this.anglesRadTE[i]) + this.wavelength * (double)this.gratingOrderTE[i] / this.gratingPitch;
            }
            super.enterTEmodeData(this.thicknessesTE, this.effectiveRefractiveIndicesTE, this.modeNumbersTE);
        }
        this.calcEffectiveDone = true;
    }

    public void calcTMmodeEffectiveRefractiveIndices() {
        this.effectiveRefractiveIndicesTM = new double[this.numberOfTMmeasurementsGrating];
        this.effectiveErrorsTM = new double[this.numberOfTMmeasurementsGrating];
        if (!this.setSuperstrateRI) {
            this.superstrateRI = RefractiveIndex.air(this.wavelength);
            this.superstrateRefractiveIndex = RefractiveIndex.air(this.wavelength);
        }
        if (this.setTMerrors) {
            ErrorProp superRI = new ErrorProp(this.superstrateRefractiveIndex, 0.0);
            ErrorProp pitch = new ErrorProp(this.gratingPitch, 0.0);
            ErrorProp lambda = new ErrorProp(this.wavelength, 0.0);
            for (int i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                ErrorProp theta = new ErrorProp(this.anglesRadTM[i], this.errorsRadTM[i]);
                ErrorProp order = new ErrorProp(this.gratingOrderTM[i], 0.0);
                ErrorProp calc = ErrorProp.sin(theta);
                calc = calc.times(superRI);
                calc = calc.plus(lambda.times(order).over(pitch));
                this.effectiveRefractiveIndicesTM[i] = calc.getValue();
                this.effectiveErrorsTM[i] = calc.getError();
            }
            super.enterTMmodeData(this.thicknessesTM, this.effectiveRefractiveIndicesTM, this.effectiveErrorsTM, this.modeNumbersTM);
        } else {
            for (int i = 0; i < this.numberOfTMmeasurementsGrating; ++i) {
                this.effectiveRefractiveIndicesTM[i] = this.superstrateRI * Math.sin(this.anglesRadTM[i]) + this.wavelength * (double)this.gratingOrderTM[i] / this.gratingPitch;
            }
            super.enterTMmodeData(this.thicknessesTM, this.effectiveRefractiveIndicesTM, this.modeNumbersTM);
        }
        this.calcEffectiveDone = true;
    }
}

