/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;

public class LowPassPassive
extends BlackBox {
    private double resistance = 0.0;
    private double capacitance = 0.0;
    private double timeConstant = 0.0;
    private boolean setR = false;
    private boolean setC = false;

    public LowPassPassive() {
        super("PassiveLowPass");
        this.sPoles = Complex.oneDarray(1);
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0, 1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
        this.timeConstant = 1.0;
    }

    public void setResistance(double res) {
        this.resistance = res;
        this.timeConstant = res * this.capacitance;
        this.calcPolesZerosS();
        this.sDenom = ComplexPoly.rootsToPoly(this.sPoles);
        super.addDeadTimeExtras();
        this.setR = true;
    }

    public void setCapacitance(double cap) {
        this.capacitance = cap;
        this.timeConstant = cap * this.resistance;
        this.calcPolesZerosS();
        this.sDenom = ComplexPoly.rootsToPoly(this.sPoles);
        super.addDeadTimeExtras();
        this.setC = true;
    }

    public void setTimeConstant(double tau) {
        this.timeConstant = tau;
        this.calcPolesZerosS();
        this.sDenom = ComplexPoly.rootsToPoly(this.sPoles);
        super.addDeadTimeExtras();
    }

    public double getResistance() {
        if (this.setR) {
            return this.resistance;
        }
        System.out.println("Class; LowPassPassive, method: getResistance");
        System.out.println("No resistance has been entered; zero returned");
        return 0.0;
    }

    public double getCapacitance() {
        if (this.setC) {
            return this.capacitance;
        }
        System.out.println("Class; LowPassPassive, method: getCapacitance");
        System.out.println("No capacitance has been entered; zero returned");
        return 0.0;
    }

    public double getTimeConstant() {
        return this.timeConstant;
    }

    @Override
    protected void calcPolesZerosS() {
        this.sPoles[0].setReal(-this.timeConstant);
        this.sNumerScaleFactor = this.sNumer.coeffCopy(0);
        this.sDenomScaleFactor = BlackBox.scaleFactor(this.sDenom, this.sPoles);
    }

    @Override
    public LowPassPassive copy() {
        if (this == null) {
            return null;
        }
        LowPassPassive bb = new LowPassPassive();
        this.copyBBvariables(bb);
        bb.resistance = this.resistance;
        bb.capacitance = this.capacitance;
        bb.timeConstant = this.timeConstant;
        bb.setR = this.setR;
        bb.setC = this.setC;
        return bb;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

