/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.createCatalogProps;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.pipeline.createCatalogProps.ColumnTypeCounter;
import edu.mayo.pipes.UNIX.CatGZPipe;
import edu.mayo.pipes.UNIX.CatPipe;
import edu.mayo.pipes.history.ColumnMetaData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColumnMetaFromCatalogCrawling {
    private JsonParser mJsonParser = new JsonParser();

    public static void main(String[] args) {
        try {
            String a = "1.0";
            String[] strs = a.split(";");
            List<ColumnMetaData> colMeta = new ColumnMetaFromCatalogCrawling().getColumnMetadata("src/test/resources/example_dbSNP_catalog.tsv.bgz");
            System.out.println("Done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<ColumnMetaData> getColumnMetadata(String catalogFilePath) throws IOException {
        HashMap<String, ColumnTypeCounter> colMap = new HashMap<String, ColumnTypeCounter>();
        boolean isGzip = catalogFilePath.endsWith(".bgz") || catalogFilePath.endsWith(".gz");
        Pipeline pipe = new Pipeline(new Pipe[]{isGzip ? new CatGZPipe("gzip") : new CatPipe()});
        pipe.setStarts(Arrays.asList(new File(catalogFilePath).getCanonicalPath()));
        System.out.println("----------------------------------------");
        System.out.println("Reading lines from catalog:  .=10k  o=100k  |=1M  X=10M");
        int numLines = 0;
        while (pipe.hasNext()) {
            String row = (String)pipe.next();
            if (row == null || row.length() == 0 || row.startsWith("#")) continue;
            String[] cols = row.split("\t");
            JsonObject jsonObj = this.mJsonParser.parse(cols[3]).getAsJsonObject();
            this.addJsonKeysToMap(jsonObj.getAsJsonObject(), null, colMap);
            if (++numLines % 10000000 == 0) {
                System.out.println("X");
                continue;
            }
            if (numLines % 1000000 == 0) {
                System.out.println("|");
                continue;
            }
            if (numLines % 100000 == 0) {
                System.out.print("o");
                continue;
            }
            if (numLines % 10000 != 0) continue;
            System.out.print(".");
        }
        System.out.println("\n# catalog lines crawled: " + numLines);
        ArrayList<ColumnMetaData> colMetaList = new ArrayList<ColumnMetaData>();
        for (String key : colMap.keySet()) {
            ColumnTypeCounter colType = (ColumnTypeCounter)colMap.get(key);
            ColumnMetaData colMeta = colType.getColumnMetaData();
            colMetaList.add(colMeta);
        }
        return colMetaList;
    }

    private void addJsonKeysToMap(JsonObject jsonObj, String parentJsonPath, HashMap<String, ColumnTypeCounter> colMap) {
        for (Map.Entry entry : jsonObj.entrySet()) {
            String key = (parentJsonPath == null || parentJsonPath.length() == 0 ? "" : parentJsonPath + ".") + (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value instanceof JsonObject) {
                this.addJsonKeysToMap(value.getAsJsonObject(), key, colMap);
                continue;
            }
            this.addKeyValue(key, value.toString(), colMap);
        }
    }

    private void addKeyValue(String key, String value, HashMap<String, ColumnTypeCounter> colMap) {
        ColumnTypeCounter colTypeCount = colMap.get(key);
        if (colTypeCount == null) {
            colTypeCount = new ColumnTypeCounter(key, "");
            colMap.put(key, colTypeCount);
        }
        colTypeCount.addValue(value);
    }
}

