/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.catalogvalidator.VerifierExecutionException;
import edu.mayo.bior.catalogvalidator.VerifierInputException;
import edu.mayo.bior.catalogvalidator.VerifyCatalogBase;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.cli.InvalidOptionArgValueException;
import java.io.File;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class VerifyCatalogCommand
implements CommandPlugin {
    private static final char OPTION_CATALOG_FILE = 'd';
    private static final Logger sLogger = Logger.getLogger(VerifyCatalogCommand.class);
    private String mOperation;

    public void init(Properties props) throws Exception {
        this.mOperation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        String catalogFilePath = line.getOptionValue('d');
        if (!new File(catalogFilePath).exists()) {
            throw new InvalidOptionArgValueException(opts.getOption("d"), catalogFilePath, "The catalog file path '" + catalogFilePath + "' does not exist. Please specify a valid catalog file path.");
        }
        VerifyCatalogBase catalogValidator = new VerifyCatalogBase();
        try {
            catalogValidator.verify(catalogFilePath, VerifyCatalogBase.VAL_TYPE.STRICT, sLogger);
        }
        catch (VerifierInputException inputE) {
            System.err.println("Input exception raised while verifying catalog: " + catalogFilePath + " Exception: " + inputE.getMessage());
            inputE.printStackTrace();
            System.exit(1);
        }
        catch (VerifierExecutionException execE) {
            System.err.println("Execution exception raised while verifying catalog: " + catalogFilePath + " Exception: " + execE.getMessage());
            execE.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

