/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class PrettyPrintCommand
implements CommandPlugin {
    public static char OPTION_ROW = (char)114;
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();

    public void init(Properties props) throws Exception {
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        int rowNum = 1;
        if (line.hasOption(OPTION_ROW)) {
            rowNum = Integer.parseInt(line.getOptionValue(OPTION_ROW));
        }
        PrettyPrintPipe pipe = new PrettyPrintPipe(rowNum);
        this.mPipeline.execute((Pipe<History, History>)pipe);
    }

    class PrettyPrintPipe
    extends AbstractPipe<History, History> {
        private Integer selectedRow;
        private Gson mGson = new GsonBuilder().setPrettyPrinting().create();
        private JsonParser mJsonParser = new JsonParser();

        public PrettyPrintPipe(int selectedRow) {
            this.selectedRow = selectedRow;
        }

        protected History processNextStart() throws NoSuchElementException {
            int rowNum = 0;
            while (this.starts.hasNext()) {
                History history = (History)this.starts.next();
                if (this.selectedRow != ++rowNum) continue;
                try {
                    this.printDataRow(history);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    throw new NoSuchElementException();
                }
            }
            System.out.println("Please use a value between 1 and " + rowNum);
            throw new NoSuchElementException();
        }

        private void printDataRow(History history) throws Exception {
            String PRETTY_HEADER_COL_NUM = "#";
            String PRETTY_HEADER_COL_NUM_LINE = "-";
            String PRETTY_HEADER_COL_NAME = "COLUMN NAME";
            String PRETTY_HEADER_COL_NAME_LINE = "-----------";
            String PRETTY_HEADER_COL_VALUE = "COLUMN VALUE";
            String PRETTY_HEADER_COL_VALUE_LINE = "------------";
            List metaCols = history.getMetaData().getColumns();
            int maxColNumWidth = String.valueOf(history.size()).length();
            int maxColNameWidth = 0;
            for (ColumnMetaData metaCol : metaCols) {
                String colName = metaCol.getColumnName();
                if (colName.length() <= maxColNameWidth) continue;
                maxColNameWidth = colName.length();
            }
            if ("COLUMN NAME".length() > maxColNameWidth) {
                maxColNameWidth = "COLUMN NAME".length();
            }
            String format = "%1$-" + maxColNumWidth + "s  %2$-" + maxColNameWidth + "s  %3$s";
            System.out.println(String.format(format, "#", "COLUMN NAME", "COLUMN VALUE"));
            System.out.println(String.format(format, "-", "-----------", "------------"));
            for (int i = 0; i < history.size(); ++i) {
                ColumnMetaData cmd = (ColumnMetaData)metaCols.get(i);
                int num = i + 1;
                String colName = cmd.getColumnName();
                String dataCol = (String)history.get(i);
                if (dataCol.startsWith("{") && dataCol.endsWith("}")) {
                    String json = dataCol;
                    JsonElement je = this.mJsonParser.parse(json);
                    String prettyJsonString = this.mGson.toJson(je);
                    StringReader sRdr = new StringReader(prettyJsonString);
                    BufferedReader bRdr = new BufferedReader(sRdr);
                    String line = bRdr.readLine();
                    System.out.println(String.format(format, num, colName, line));
                    line = bRdr.readLine();
                    while (line != null) {
                        System.out.println(String.format(format, "", "", line));
                        line = bRdr.readLine();
                    }
                    continue;
                }
                System.out.println(String.format(format, num, colName, dataCol));
            }
        }
    }
}

