/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import edu.mayo.bior.buildcatalog.BuildCatalogStepExecuteException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInputException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInterface;
import edu.mayo.bior.buildcatalog.BuildInfo;
import edu.mayo.bior.buildcatalog.BuildInfoKey;
import edu.mayo.bior.buildcatalog.BuildStepKey;
import edu.mayo.bior.buildcatalog.StepLogger;
import edu.mayo.exec.Command;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;

public class MakeJsonStep
implements BuildCatalogStepInterface {
    private BuildInfo mBuildInfo;
    private StepLogger mStepLogger;
    private int mCmdExitCode;
    private String mCmdStdout;
    private String mCmdStderr;
    private static final String STEP_DISPLAY_NAME = BuildStepKey.MAKE_JSON.getDisplayName();

    public MakeJsonStep(BuildInfo buildInfo, StepLogger stepLogger) {
        this.mBuildInfo = buildInfo;
        this.mStepLogger = stepLogger;
    }

    private void checkInput() throws BuildCatalogStepInputException {
        File scriptFile = this.mBuildInfo.getMakeJsonScriptPathFile();
        if (!scriptFile.exists()) {
            throw new BuildCatalogStepInputException(String.format("Error: could not find %s script '%s'.", STEP_DISPLAY_NAME, this.mBuildInfo.getMakeJsonScriptPath()));
        }
        if (!scriptFile.canExecute()) {
            throw new BuildCatalogStepInputException(String.format("Error: %s script '%s' is not executable.", STEP_DISPLAY_NAME, this.mBuildInfo.getMakeJsonScriptPath()));
        }
    }

    @Override
    public void execute() throws BuildCatalogStepInputException, BuildCatalogStepExecuteException {
        this.checkInput();
        String[] cmdArgs = this.createMakeJsonCommand(this.mBuildInfo);
        HashMap<String, String> envVars = new HashMap<String, String>();
        envVars.putAll(System.getenv());
        envVars.put(BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH.name(), this.mBuildInfo.getMakeJsonOutputFilePath());
        envVars.put(BuildInfoKey.DATA_SOURCE.name(), this.mBuildInfo.getDataSourceName());
        envVars.put(BuildInfoKey.DATA_SOURCE_VERSION.name(), this.mBuildInfo.getDataSourceVersion());
        envVars.put(BuildInfoKey.DATA_SOURCE_BUILD.name(), this.mBuildInfo.getDataSourceBuild());
        Command cmd = new Command(cmdArgs, envVars, true);
        try {
            this.mStepLogger.logAndSummary(String.format("Executing script '%s' with args: '%s'", this.mBuildInfo.getMakeJsonScriptPath(), this.mBuildInfo.getMakeJsonArgs()));
            cmd.execute();
        }
        catch (IOException e) {
            throw new BuildCatalogStepExecuteException(String.format("Problem executing the script during the %s step", STEP_DISPLAY_NAME), e);
        }
        catch (InterruptedException e) {
            throw new BuildCatalogStepExecuteException(String.format("Problem executing the script during the %s step", STEP_DISPLAY_NAME), e);
        }
        this.mCmdExitCode = cmd.getExitCode();
        this.mCmdStdout = cmd.getStdout();
        this.mCmdStderr = cmd.getStderr();
        this.mStepLogger.log(String.format("%s step:%n", STEP_DISPLAY_NAME));
        this.mStepLogger.log(String.format("Exit code: %d%n", this.mCmdExitCode));
        this.mStepLogger.log(String.format("STDERR:%n%s%n", this.mCmdStderr));
        this.mStepLogger.log(String.format("STDOUT:%n%s%n", this.mCmdStdout));
        this.checkOutput();
    }

    private void checkOutput() throws BuildCatalogStepExecuteException {
        File outputFile;
        if (this.mCmdExitCode != 0) {
            throw new BuildCatalogStepExecuteException(String.format("Error: output of '%s' command was non-zero: %d", this.mBuildInfo.getMakeJsonScriptPath(), this.mCmdExitCode));
        }
        if (this.mCmdStderr.length() > 0) {
            System.err.println(this.mCmdStderr);
        }
        if (!(outputFile = new File(this.mBuildInfo.getMakeJsonOutputFilePath())).exists()) {
            throw new BuildCatalogStepExecuteException(String.format("Error: output file path does not exist: '%s'", outputFile.getPath()));
        }
        if (outputFile.length() == 0L) {
            throw new BuildCatalogStepExecuteException(String.format("Error: output file was empty: '%s'", outputFile.getPath()));
        }
        this.verifyLastColIsJson(outputFile);
    }

    private void verifyLastColIsJson(File outputFile) throws BuildCatalogStepExecuteException {
        BufferedReader fin = null;
        try {
            String line;
            fin = new BufferedReader(new FileReader(outputFile));
            int lineNum = 1;
            while ((line = fin.readLine()) != null && lineNum <= 100) {
                boolean isJson;
                if (line.startsWith("#")) continue;
                String[] cols = line.split("\t");
                String lastCol = cols[cols.length - 1];
                boolean bl = isJson = lastCol.startsWith("{") && lastCol.endsWith("}");
                if (!isJson) {
                    throw new BuildCatalogStepExecuteException(String.format("Error: each line in the %s output must end with a JSON object", STEP_DISPLAY_NAME));
                }
                ++lineNum;
            }
        }
        catch (IOException e) {
            try {
                String errMsg = String.format("Issue checking if the output file '%s' has JSON in the last column", outputFile.getPath());
                throw new BuildCatalogStepExecuteException(errMsg, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)fin);
    }

    private String[] createMakeJsonCommand(BuildInfo buildInfo) {
        return new String[]{"/bin/sh", "-c", buildInfo.getMakeJsonScriptPath() + "  " + buildInfo.getMakeJsonArgs()};
    }

    int getScriptExitCode() {
        return this.mCmdExitCode;
    }

    String getScriptStderr() {
        return this.mCmdStderr;
    }

    String getScriptStdout() {
        return this.mCmdStdout;
    }
}

