/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import com.google.common.base.Joiner;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInputException;
import edu.mayo.bior.buildcatalog.BuildInfoKey;
import edu.mayo.bior.buildcatalog.StepLogger;
import edu.mayo.bior.util.validation.CatalogFileValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BuildInfo {
    private static Logger sLogger = Logger.getLogger(StepLogger.class);
    private Map<BuildInfoKey, String> mKeyMap = new HashMap<BuildInfoKey, String>();
    private File mMakeJsonScriptPathFile;
    private static final String DEFAULT_MAKE_JSON_OUTPUT_FILENAME = "make_json_output_tjson.tsv";
    private static final String SEP = File.separator;
    private static final String BUILD_CATALOG_DIR = "bior_build_catalog_tmp";
    private File mWorkingTempDir;
    private File mTargetDirFile;
    private static final List<String> TEMP_DIR_PRIORITY_LIST = new ArrayList<String>();
    private int inputJSONColumnNum = -1;
    private String chromosomeSortOrderFileName;
    private boolean sortCatalogOnCreate = true;

    public BuildInfo(Map<BuildInfoKey, String> inputMap) throws BuildCatalogStepInputException {
        this.copyMapToMap(inputMap);
        this.verifyData(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildInfo(String buildInfoPath) throws IOException, BuildCatalogStepInputException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(buildInfoPath);
            Properties tempProperties = new Properties();
            tempProperties.load(fin);
            this.putPropertiesInMap(tempProperties);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fin);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fin);
        this.verifyData(buildInfoPath);
    }

    private void putPropertiesInMap(Properties properties) {
        for (BuildInfoKey key : BuildInfoKey.values()) {
            String val = properties.getProperty(key.name());
            if (val == null) continue;
            this.mKeyMap.put(key, val);
        }
    }

    private void copyMapToMap(Map<BuildInfoKey, String> inputMap) {
        for (BuildInfoKey key : BuildInfoKey.values()) {
            String val = inputMap.get((Object)key);
            if (val == null) continue;
            this.mKeyMap.put(key, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String buildInfoPath) throws IOException {
        Properties props = this.getPropertiesFromFields();
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(buildInfoPath));
            props.store(fout, "## Build Info file for BioR build catalog command");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fout);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fout);
    }

    private void verifyData(String buildInfoPath) throws BuildCatalogStepInputException {
        this.verifyRequiredKeys(buildInfoPath);
        this.verifyRequiredNonEmptyValues(buildInfoPath);
        this.validateSettingsAndGenerateDefaults();
    }

    private void verifyRequiredKeys(String buildInfoPath) throws BuildCatalogStepInputException {
        ArrayList<BuildInfoKey> keysNotFound = new ArrayList<BuildInfoKey>();
        for (BuildInfoKey reqKey : BuildInfoKey.getRequiredKeys()) {
            String val = this.mKeyMap.get((Object)reqKey);
            if (val != null) continue;
            keysNotFound.add(reqKey);
        }
        this.throwInputExceptionIfNotEmpty(buildInfoPath, "is missing", keysNotFound);
    }

    private void verifyRequiredNonEmptyValues(String buildInfoPath) throws BuildCatalogStepInputException {
        ArrayList<BuildInfoKey> keysWithoutValues = new ArrayList<BuildInfoKey>();
        for (BuildInfoKey reqKey : BuildInfoKey.getNonEmptyValueRequiredKeys()) {
            String val = this.mKeyMap.get((Object)reqKey);
            if (!StringUtils.isBlank((String)val)) continue;
            keysWithoutValues.add(reqKey);
        }
        this.throwInputExceptionIfNotEmpty(buildInfoPath, "has an empty value for", keysWithoutValues);
    }

    private void throwInputExceptionIfNotEmpty(String buildInfoPath, String msgPart, List<BuildInfoKey> keysWithProblem) throws BuildCatalogStepInputException {
        if (!keysWithProblem.isEmpty()) {
            String keyDescription = BuildInfo.composeItemNumDescription("key", keysWithProblem.size());
            String error = "Error: ";
            error = !StringUtils.isBlank((String)buildInfoPath) ? error + "file '" + buildInfoPath + "'" : error + "data supplied to create BuildInfo object";
            throw new BuildCatalogStepInputException(String.format("%s %s %s: %s", error, msgPart, keyDescription, Joiner.on((String)", ").join(keysWithProblem)));
        }
    }

    private void validateSettingsAndGenerateDefaults() throws BuildCatalogStepInputException {
        this.validateJsonScriptPath();
        this.validateTempDirOrGenerate();
        this.validateJsonOutputPathOrGenerate();
        this.validateTargetDirOrGenerate();
        this.validatePreviousCatalogPath();
    }

    private void validatePreviousCatalogPath() throws BuildCatalogStepInputException {
        String previousCatalogPath = this.getPreviousCatalogPath();
        if (!StringUtils.isBlank((String)previousCatalogPath)) {
            File previousCatalogFile = new File(previousCatalogPath);
            if (!previousCatalogFile.exists()) {
                throw new BuildCatalogStepInputException(String.format("Could not find '%s' from %s", new Object[]{previousCatalogPath, BuildInfoKey.PREVIOUS_CATALOG_PATH}));
            }
            if (!CatalogFileValidator.hasExpectedSuffix(previousCatalogPath)) {
                throw new BuildCatalogStepInputException(String.format("'%s' from %s does not have expected catalog suffix '%s'", new Object[]{previousCatalogPath, BuildInfoKey.PREVIOUS_CATALOG_PATH, ".tsv.bgz"}));
            }
        }
    }

    private void validateTargetDirOrGenerate() throws BuildCatalogStepInputException {
        File targetDirFile;
        String targetDir = this.getTargetDirectory();
        if (StringUtils.isBlank((String)targetDir)) {
            targetDir = ".";
            this.mKeyMap.put(BuildInfoKey.TARGET_DIR, targetDir);
        }
        if (!(targetDirFile = new File(targetDir)).exists()) {
            throw new BuildCatalogStepInputException(String.format("Could not find dir '%s' from %s", new Object[]{targetDir, BuildInfoKey.TARGET_DIR}));
        }
        if (!targetDirFile.isDirectory()) {
            throw new BuildCatalogStepInputException(String.format("'%s' from %s is not a directory", new Object[]{targetDir, BuildInfoKey.TARGET_DIR}));
        }
        if (!targetDirFile.canWrite()) {
            throw new BuildCatalogStepInputException(String.format("'%s' from %s is not writeable", new Object[]{targetDir, BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH}));
        }
        if (!targetDirFile.canRead()) {
            throw new BuildCatalogStepInputException(String.format("'%s' from %s is not readable", new Object[]{targetDir, BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH}));
        }
        if (!targetDirFile.canExecute()) {
            throw new BuildCatalogStepInputException(String.format("'%s' from %s is not executable", new Object[]{targetDir, BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH}));
        }
        this.mTargetDirFile = targetDirFile;
    }

    private void validateJsonOutputPathOrGenerate() throws BuildCatalogStepInputException {
        String outputPath = this.getMakeJsonOutputFilePath();
        if (!StringUtils.isBlank((String)outputPath)) {
            File outputFile = new File(outputPath);
            if (outputFile.exists() && outputFile.isDirectory()) {
                throw new BuildCatalogStepInputException(String.format("'%s' from %s is a directory, not a file", new Object[]{outputPath, BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH}));
            }
            File parentDir = outputFile.getParentFile();
            if (parentDir != null && parentDir.exists() && !parentDir.canWrite()) {
                throw new BuildCatalogStepInputException(String.format("Parent dir for '%s' from %s is not writeable", new Object[]{outputPath, BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH}));
            }
            if (parentDir != null && parentDir.exists() && !parentDir.canRead()) {
                throw new BuildCatalogStepInputException(String.format("Parent dir for '%s' from %s is not readable", new Object[]{outputPath, BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH}));
            }
            if (parentDir != null && parentDir.exists() && !parentDir.canExecute()) {
                throw new BuildCatalogStepInputException(String.format("Parent dir for '%s' from %s is not executable", new Object[]{outputPath, BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH}));
            }
        } else {
            File outputFile = new File(this.getWorkingTempDirectory(), DEFAULT_MAKE_JSON_OUTPUT_FILENAME);
            this.mKeyMap.put(BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH, outputFile.getPath());
        }
    }

    private void validateTempDirOrGenerate() throws BuildCatalogStepInputException {
        File workingTempDir;
        File baseTempDirFile;
        String tempDir = this.getBaseTempDirectory();
        if (StringUtils.isBlank((String)tempDir)) {
            baseTempDirFile = new File(BuildInfo.findBaseTempDir());
            this.mKeyMap.put(BuildInfoKey.TEMP_DIR, baseTempDirFile.getPath());
        } else {
            baseTempDirFile = new File(tempDir);
        }
        if (!baseTempDirFile.exists() && !baseTempDirFile.mkdirs()) {
            throw new BuildCatalogStepInputException(String.format("Could not create temp dir '%s'. It is likely due to permissions.", this.getBaseTempDirectory()));
        }
        if (!baseTempDirFile.isDirectory()) {
            throw new BuildCatalogStepInputException(String.format("'%s' from %s is not a directory", new Object[]{this.getBaseTempDirectory(), BuildInfoKey.TEMP_DIR}));
        }
        try {
            workingTempDir = File.createTempFile("tmp", "bior_build_catalog", baseTempDirFile);
            if (!workingTempDir.delete()) {
                sLogger.error((Object)"Trying to delete a temp file made from File.createTempFile but couldn't delete the file using File.delete");
                sLogger.error((Object)"A more generic message is put in the exception");
                throw new BuildCatalogStepInputException("Had trouble creating a temporary working directory in " + this.getBaseTempDirectory());
            }
            if (!workingTempDir.mkdir()) {
                sLogger.error((Object)"Trying to create a temp working directory but couldn't make the directory with File.mkdir");
                sLogger.error((Object)"A more generic message is put in the exception");
                throw new BuildCatalogStepInputException("Had trouble creating a temporary working directory in " + this.getBaseTempDirectory());
            }
        }
        catch (IOException e) {
            throw new BuildCatalogStepInputException("Had trouble creating a temporary working directory in " + this.getBaseTempDirectory());
        }
        this.mWorkingTempDir = workingTempDir;
    }

    private void validateJsonScriptPath() throws BuildCatalogStepInputException {
        String scriptPath = this.getMakeJsonScriptPath();
        File scriptPathFile = new File(scriptPath);
        if (!scriptPathFile.exists()) {
            throw new BuildCatalogStepInputException(String.format("Error: could not find script '%s' from %s", new Object[]{scriptPath, BuildInfoKey.MAKE_JSON_SCRIPT_PATH}));
        }
        if (!scriptPathFile.canExecute()) {
            throw new BuildCatalogStepInputException(String.format("Error: script '%s' from %s is not executable: ", new Object[]{scriptPath, BuildInfoKey.MAKE_JSON_SCRIPT_PATH}));
        }
        this.mMakeJsonScriptPathFile = scriptPathFile;
    }

    private static String composeItemNumDescription(String baseDescription, int numItems) {
        if (numItems == 1) {
            return baseDescription;
        }
        return baseDescription + "s";
    }

    private static String findBaseTempDir() throws BuildCatalogStepInputException {
        for (String tempPath : TEMP_DIR_PRIORITY_LIST) {
            String tempSubPath = BuildInfo.checkPath(tempPath);
            if (tempSubPath == null) continue;
            return tempSubPath;
        }
        throw new BuildCatalogStepInputException("Couldn't find anywhere to make a temporary directory");
    }

    private static String checkPath(String path) {
        File baseTempDir = new File(path);
        if (baseTempDir.exists()) {
            String testPath;
            File testDir;
            String userName = System.getProperty("user.name");
            String userNameDir = userName + SEP;
            if (StringUtils.isBlank((String)userName)) {
                userNameDir = "";
            }
            if ((testDir = new File(testPath = baseTempDir + SEP + userNameDir + BUILD_CATALOG_DIR)).exists()) {
                return testPath;
            }
            if (testDir.mkdirs()) {
                return testPath;
            }
        }
        return null;
    }

    File getMakeJsonScriptPathFile() {
        return this.mMakeJsonScriptPathFile;
    }

    String getMakeJsonScriptPath() {
        return this.mKeyMap.get((Object)BuildInfoKey.MAKE_JSON_SCRIPT_PATH);
    }

    String getMakeJsonArgs() {
        return this.mKeyMap.get((Object)BuildInfoKey.MAKE_JSON_ARGS);
    }

    String getMakeJsonOutputFilePath() {
        return this.mKeyMap.get((Object)BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH);
    }

    public String getTargetDirectory() {
        return this.mKeyMap.get((Object)BuildInfoKey.TARGET_DIR);
    }

    File getTargetDirectoryFile() {
        return this.mTargetDirFile;
    }

    String getBaseTempDirectory() {
        return this.mKeyMap.get((Object)BuildInfoKey.TEMP_DIR);
    }

    File getWorkingTempDirectory() {
        return this.mWorkingTempDir;
    }

    String getDataSourceName() {
        return this.mKeyMap.get((Object)BuildInfoKey.DATA_SOURCE);
    }

    String getDataSourceVersion() {
        return this.mKeyMap.get((Object)BuildInfoKey.DATA_SOURCE_VERSION);
    }

    String getDataSourceBuild() {
        return this.mKeyMap.get((Object)BuildInfoKey.DATA_SOURCE_BUILD);
    }

    public String getCatalogPrefix() {
        return this.mKeyMap.get((Object)BuildInfoKey.CATALOG_PREFIX);
    }

    List<String> getIndexes() {
        return BuildInfo.splitByCommaAndTrim(this.mKeyMap.get((Object)BuildInfoKey.INDEXES));
    }

    private static List<String> splitByCommaAndTrim(String s) {
        String[] vals;
        ArrayList<String> valList = new ArrayList<String>();
        if (s == null || s.length() <= 0) {
            return valList;
        }
        for (String val : vals = s.split(",")) {
            String eachIndex = val.trim();
            if (eachIndex.length() <= 0) continue;
            valList.add(eachIndex);
        }
        return valList;
    }

    String getPreviousCatalogPath() {
        return this.mKeyMap.get((Object)BuildInfoKey.PREVIOUS_CATALOG_PATH);
    }

    int getinputJSONColumnNum() {
        return this.inputJSONColumnNum;
    }

    void setInputJSONColumnNum(int inputJSONColumnNum) {
        this.inputJSONColumnNum = inputJSONColumnNum;
    }

    String getChromosomeSortOrderFileName() {
        return this.chromosomeSortOrderFileName;
    }

    void setChromosomeSortOrderFileName(String chromosomeSortOrderFileName) {
        this.chromosomeSortOrderFileName = chromosomeSortOrderFileName;
    }

    boolean getSortCatalogOnCreate() {
        return this.sortCatalogOnCreate;
    }

    void setSortCatalogOnCreate(String sortOnCreate) {
        if (sortOnCreate.toUpperCase().equals("TRUE")) {
            this.sortCatalogOnCreate = true;
        } else if (sortOnCreate.toUpperCase().equals("FALSE")) {
            this.sortCatalogOnCreate = false;
        }
    }

    private Properties getPropertiesFromFields() throws IOException {
        Properties props = new Properties();
        for (BuildInfoKey key : BuildInfoKey.values()) {
            String val = this.mKeyMap.get((Object)key);
            if (val == null) continue;
            props.setProperty(key.name(), val);
        }
        return props;
    }

    static {
        TEMP_DIR_PRIORITY_LIST.add("/local2/tmp");
        TEMP_DIR_PRIORITY_LIST.add("/local1/tmp");
        TEMP_DIR_PRIORITY_LIST.add(System.getProperty("java.io.tmpdir"));
        TEMP_DIR_PRIORITY_LIST.add("/tmp");
    }
}

