/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryRand;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesSnp
extends TestCase {
    boolean debug = false;
    Random rand;
    Config config;
    Genome genome;
    Chromosome chromosome;
    Gene gene;
    Transcript transcript;
    SnpEffectPredictor snpEffectPredictor;
    String chromoSequence = "";
    char[] chromoBases;

    public TestCasesSnp() {
        this.init();
    }

    void init() {
        this.initRand();
        this.initSnpEffPredictor();
    }

    void initRand() {
        this.rand = new Random(20100629L);
    }

    void initSnpEffPredictor() {
        this.config = new Config("testCase", "snpEff.config");
        int maxGeneLen = 1000;
        int maxTranscripts = 1;
        int maxExons = 5;
        SnpEffPredictorFactoryRand sepf = new SnpEffPredictorFactoryRand(this.config, 1, this.rand, maxGeneLen, maxTranscripts, maxExons);
        this.snpEffectPredictor = sepf.create();
        this.config.setSnpEffectPredictor(this.snpEffectPredictor);
        this.chromoSequence = sepf.getChromoSequence();
        this.chromoBases = this.chromoSequence.toCharArray();
        this.config.getSnpEffectPredictor().setUpDownStreamLength(0);
        this.config.getSnpEffectPredictor().buildForest();
        this.chromosome = sepf.getChromo();
        this.genome = this.config.getGenome();
        this.gene = this.genome.getGenes().iterator().next();
        this.transcript = (Transcript)this.gene.iterator().next();
    }

    public void test_01() {
        int N = 1000;
        CodonTable codonTable = this.genome.codonTable();
        for (int i = 0; i < N; ++i) {
            this.initSnpEffPredictor();
            if (this.debug) {
                System.out.println("SNP Test iteration: " + i + "\n" + this.transcript);
            } else {
                System.out.println("SNP Test iteration: " + i + "\t" + (this.transcript.getStrand() >= 0 ? "+" : "-") + "\t" + this.transcript.cds());
            }
            int cdsBaseNum = 0;
            for (Exon exon : this.transcript.sortedStrand()) {
                int beg;
                int step = exon.isStrandPlus() ? 1 : -1;
                int pos = beg = exon.isStrandPlus() ? exon.getStart() : exon.getEnd();
                while (pos >= exon.getStart() && pos <= exon.getEnd()) {
                    char refBase = this.chromoBases[pos];
                    refBase = Character.toUpperCase(refBase);
                    int cdsCodonNum = cdsBaseNum / 3;
                    int cdsCodonPos = cdsBaseNum % 3;
                    int minCodonPos = cdsCodonNum * 3;
                    int maxCodonPos = minCodonPos + 3;
                    if (maxCodonPos < this.transcript.cds().length()) {
                        SeqChange seqChange;
                        List<ChangeEffect> effects;
                        int seqChangeStrand;
                        String codon = this.transcript.cds().substring(minCodonPos, maxCodonPos);
                        codon = codon.toUpperCase();
                        String aa = codonTable.aa(codon);
                        char snp = refBase;
                        while (snp == refBase) {
                            snp = Character.toUpperCase(GprSeq.randBase(this.rand));
                        }
                        String newCodon = codon.substring(0, cdsCodonPos) + snp + codon.substring(cdsCodonPos + 1);
                        String newAa = codonTable.aa(newCodon);
                        String effectExpected = "";
                        effectExpected = newAa.equals(aa) ? (cdsCodonNum == 0 && codonTable.isStart(codon) ? (codonTable.isStart(newCodon) ? "SYNONYMOUS_START(" + aa + ")" : "START_LOST(" + aa + ")") : (aa.equals("*") ? "SYNONYMOUS_STOP(" + aa + ")" : "SYNONYMOUS_CODING(" + aa + ")")) : (cdsCodonNum == 0 && codonTable.isStart(codon) ? (codonTable.isStart(newCodon) ? "NON_SYNONYMOUS_START(" + aa + "/" + newAa + ")" : "START_LOST(" + aa + "/" + newAa + ")") : (codonTable.isStop(codon) ? "STOP_LOST(" + aa + "/" + newAa + ")" : (codonTable.isStop(newCodon) ? "STOP_GAINED(" + aa + "/" + newAa + ")" : "NON_SYNONYMOUS_CODING(" + aa + "/" + newAa + ")")));
                        int n = seqChangeStrand = this.rand.nextBoolean() ? 1 : -1;
                        if (exon.isStrandMinus()) {
                            refBase = GprSeq.wc(refBase);
                        }
                        if (seqChangeStrand == -exon.getStrand()) {
                            snp = GprSeq.wc(snp);
                            refBase = GprSeq.wc(refBase);
                        }
                        Assert.assertEquals((boolean)true, ((effects = this.snpEffectPredictor.seqChangeEffect(seqChange = new SeqChange(this.chromosome, pos, refBase + "", snp + "", seqChangeStrand, "", 1.0, 1))).size() <= 1 ? 1 : 0) != 0);
                        if (effects.size() == 1) {
                            ChangeEffect effect = effects.get(0);
                            String effStr = effect.effect(true, true, true);
                            if (this.debug) {
                                System.out.println("\tPos: " + pos + "\tCDS base num: " + cdsBaseNum + " [" + cdsCodonNum + ":" + cdsCodonPos + "]" + "\t" + seqChange + (seqChange.getStrand() >= 0 ? "+" : "-") + "\tCodon: " + codon + " -> " + newCodon + "\tAA: " + aa + " -> " + newAa + "\tEffect: " + effStr);
                            }
                            Assert.assertEquals((String)effectExpected, (String)effStr);
                            if (!effect.getWarning().isEmpty()) {
                                Gpr.debug("WARN:" + effect.getWarning() + "\t" + seqChange + "\t" + seqChangeStrand);
                            }
                            Assert.assertEquals((boolean)true, (boolean)effect.getWarning().isEmpty());
                        }
                    }
                    pos += step;
                    ++cdsBaseNum;
                }
            }
        }
    }
}

