/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.binseq.coder.DnaCoder;
import ca.mcgill.mcb.pcingola.nmer.Nmer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Random;
import junit.framework.TestCase;

public class TestCasesNmers
extends TestCase {
    public static boolean verbose = false;

    String randSeq(int len, Random rand) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int r = rand.nextInt() & 3;
            sb.append(DnaCoder.get().toBase(r));
        }
        return sb.toString();
    }

    public void test_03_Nmers() {
        long seed = 20100615L;
        Random rand = new Random(seed);
        int numTests = 100;
        for (int len = 1; len <= 32; ++len) {
            for (int t = 0; t < numTests; ++t) {
                Nmer nmer;
                String seq = this.randSeq(len, rand);
                if (verbose) {
                    System.out.println("Nmer test:" + t + "\tlen:" + len + "\t" + seq);
                }
                if (seq.equals((nmer = new Nmer(seq)).toString())) continue;
                throw new RuntimeException("Sequences do not match:\n\tSeq    :\t" + seq + "\n\tBinSeq :\t" + nmer);
            }
        }
    }

    public void test_20_Nmers_read_write() {
        String testFile = "/tmp/nmer_test.bin";
        int nmerSize = 32;
        int numNmers = 100000;
        try {
            FileOutputStream os = new FileOutputStream(new File(testFile));
            Random rand = new Random(20100825L);
            ArrayList<Nmer> list = new ArrayList<Nmer>();
            for (int i = 0; i < numNmers; ++i) {
                Nmer nmer = new Nmer(nmerSize);
                nmer.setNmer(rand.nextLong());
                list.add(nmer);
                nmer.write(os);
            }
            os.close();
            Nmer nmer = new Nmer(nmerSize);
            FileInputStream is = new FileInputStream(new File(testFile));
            int i = 0;
            while (nmer.read(is) >= 0) {
                Nmer nmerOri = (Nmer)list.get(i);
                if (nmerOri.getNmer() != nmer.getNmer()) {
                    throw new RuntimeException("Nmers differ:\n\t" + nmerOri + "\t" + Long.toHexString(nmerOri.getNmer()) + "\n\t" + nmer + "\t" + Long.toHexString(nmer.getNmer()));
                }
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

