/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByEnd;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByStart;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerSerializer;
import ca.mcgill.mcb.pcingola.interval.Markers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class IntervalAndSubIntervals<T extends Marker>
extends Marker
implements Iterable<T> {
    private static final long serialVersionUID = 1636197649250882952L;
    HashMap<String, T> subIntervals;
    ArrayList<T> sorted;
    ArrayList<T> sortedStrand;

    public IntervalAndSubIntervals() {
        this.reset();
    }

    public IntervalAndSubIntervals(Marker parent, int start, int end, int strand, String id) {
        super(parent, start, end, strand, id);
        this.reset();
    }

    public void add(T t) {
        if (this.subIntervals.put(((Interval)t).getId(), t) != null) {
            throw new RuntimeException(t.getClass().getSimpleName() + " '" + ((Interval)t).getId() + "' is already in " + this.getClass().getSimpleName() + " '" + this.id + "'");
        }
        this.invalidateSorted();
    }

    public void addAll(Iterable<T> ts) {
        for (Marker t : ts) {
            this.add(t);
        }
        this.invalidateSorted();
    }

    public void addAll(Markers markers) {
        for (Marker m : markers) {
            this.add(m);
        }
        this.invalidateSorted();
    }

    public boolean containsId(String id) {
        return this.subIntervals.containsKey(id);
    }

    public T get(String id) {
        return (T)((Marker)this.subIntervals.get(id));
    }

    protected void invalidateSorted() {
        this.sortedStrand = null;
        this.sorted = null;
    }

    @Override
    public Iterator<T> iterator() {
        return this.subIntervals.values().iterator();
    }

    public int numChilds() {
        return this.subIntervals != null ? this.subIntervals.size() : 0;
    }

    public void remove(T t) {
        this.subIntervals.remove(((Interval)t).getId());
        this.invalidateSorted();
    }

    public void reset() {
        this.subIntervals = new HashMap();
        this.invalidateSorted();
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        Markers markers = markerSerializer.getNextFieldMarkers();
        for (Marker m : markers) {
            this.add(m);
        }
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + markerSerializer.save(this.subIntervals.values());
    }

    @Override
    public void setStrand(int strand) {
        this.strand = (byte)strand;
        for (Marker t : this) {
            t.setStrand(strand);
        }
        this.invalidateSorted();
    }

    public synchronized List<T> sorted() {
        if (this.sorted != null) {
            return this.sorted;
        }
        this.sorted = new ArrayList();
        this.sorted.addAll(this.subIntervals.values());
        Collections.sort(this.sorted);
        return this.sorted;
    }

    public synchronized List<T> sortedStrand() {
        if (this.sortedStrand != null) {
            return this.sortedStrand;
        }
        this.sortedStrand = new ArrayList();
        this.sortedStrand.addAll(this.subIntervals.values());
        if (this.strand >= 0) {
            Collections.sort(this.sortedStrand, new IntervalComparatorByStart());
        } else {
            Collections.sort(this.sortedStrand, new IntervalComparatorByEnd(true));
        }
        return this.sortedStrand;
    }

    public Collection<T> subintervals() {
        return this.subIntervals.values();
    }
}

