/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.IntervalAndSubIntervals;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerSerializer;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteBranch;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr;
import ca.mcgill.mcb.pcingola.interval.Utr3prime;
import ca.mcgill.mcb.pcingola.interval.Utr5prime;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.stats.ObservedOverExpectedCpG;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Gene
extends IntervalAndSubIntervals<Transcript>
implements Serializable {
    private static final long serialVersionUID = 8419206759034068147L;
    String geneName;
    String bioType;

    protected Gene() {
        this.geneName = "";
        this.bioType = "";
        this.type = ChangeEffect.EffectType.GENE;
    }

    public Gene(Marker parent, int start, int end, int strand, String id, String geneName, String bioType) {
        super(parent, start, end, strand, id);
        this.geneName = geneName;
        this.bioType = bioType;
        this.type = ChangeEffect.EffectType.GENE;
    }

    public boolean adjust() {
        byte newStrand;
        boolean changed = false;
        int strandSumGene = 0;
        int newStart = this.start;
        int newEnd = this.start;
        if (newStart == 0 && newEnd == 0) {
            newStart = Integer.MAX_VALUE;
            newEnd = Integer.MIN_VALUE;
        }
        for (Transcript tr : this) {
            newStart = Math.min(newStart, tr.getStart());
            newEnd = Math.max(newEnd, tr.getEnd());
            for (Exon exon : tr.sortedStrand()) {
                newStart = Math.min(newStart, exon.getStart());
                newEnd = Math.max(newEnd, exon.getEnd());
                strandSumGene += exon.getStrand();
            }
            for (Utr utr : tr.getUtrs()) {
                newStart = Math.min(newStart, utr.getStart());
                newEnd = Math.max(newEnd, utr.getEnd());
            }
        }
        byte by = newStrand = strandSumGene >= 0 ? (byte)1 : -1;
        if (this.strand != newStrand) {
            this.strand = newStrand;
            changed = true;
        }
        if (this.start != newStart) {
            this.start = newStart;
            changed = true;
        }
        if (this.end != newEnd) {
            this.end = newEnd;
            changed = true;
        }
        return changed;
    }

    public double cpgExonBias() {
        ObservedOverExpectedCpG oe = new ObservedOverExpectedCpG();
        return oe.oe(this);
    }

    public GeneType geneType() {
        if (this.bioType.length() > 0) {
            if (this.bioType.equalsIgnoreCase("protein_coding") || this.bioType.equalsIgnoreCase("mRNA")) {
                return GeneType.CODING;
            }
            return GeneType.NON_CODING;
        }
        return GeneType.UNKNOWN;
    }

    public String getBioType() {
        return this.bioType;
    }

    public String getGeneName() {
        return this.geneName;
    }

    @Override
    public int getStrand() {
        return this.strand;
    }

    public boolean isProteinCoding() {
        for (Transcript tr : this) {
            if (!tr.isProteinCoding()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    public int keepTranscripts(Set<String> trIds) {
        ArrayList<Transcript> toDelete = new ArrayList<Transcript>();
        for (Transcript t : this) {
            if (trIds.contains(t.getId())) continue;
            toDelete.add(t);
        }
        for (Transcript t : toDelete) {
            this.remove(t);
        }
        return toDelete.size();
    }

    public void removeNonCanonical() {
        ArrayList<Transcript> toDelete = new ArrayList<Transcript>();
        Transcript canonical = null;
        if (this.isProteinCoding()) {
            for (Transcript t : this) {
                if (t.isProteinCoding() && (canonical == null || canonical.cds().length() < t.cds().length())) {
                    canonical = t;
                }
                toDelete.add(t);
            }
        } else {
            for (Transcript t : this) {
                if (canonical == null || canonical.cds().length() < t.cds().length()) {
                    canonical = t;
                }
                toDelete.add(t);
            }
        }
        if (canonical != null) {
            toDelete.remove(canonical);
            for (Transcript t : toDelete) {
                this.remove(t);
            }
        }
    }

    @Override
    public List<ChangeEffect> seqChangeEffect(SeqChange seqChange, ChangeEffect changeEffect) {
        if (!this.intersects(seqChange)) {
            return ChangeEffect.emptyResults();
        }
        changeEffect.set(this, ChangeEffect.EffectType.GENE, "");
        boolean hitTranscript = false;
        ArrayList<ChangeEffect> changeEffectList = new ArrayList<ChangeEffect>();
        for (Transcript tr : this) {
            ChangeEffect chEff;
            List<ChangeEffect> chEffList = tr.seqChangeEffect(seqChange, chEff = changeEffect.clone());
            if (chEffList.isEmpty()) continue;
            changeEffectList.addAll(chEffList);
            hitTranscript = true;
        }
        if (!hitTranscript) {
            changeEffect.set(this, ChangeEffect.EffectType.INTRAGENIC, "");
            return changeEffect.newList();
        }
        return changeEffectList;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.geneName = markerSerializer.getNextField();
        this.bioType = markerSerializer.getNextField();
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.geneName + "\t" + this.bioType;
    }

    public void setBioType(String bioType) {
        this.bioType = bioType;
    }

    public int sizeof(String type) {
        ChangeEffect.EffectType eff = ChangeEffect.EffectType.valueOf(type.toUpperCase());
        Markers all = new Markers();
        int len = 0;
        switch (eff) {
            case GENE: {
                return this.size();
            }
            case EXON: {
                for (Transcript tr : this) {
                    for (Exon exon : tr) {
                        all.add(exon);
                    }
                }
                break;
            }
            case CDS: {
                for (Transcript tr : this) {
                    for (Cds cds : tr.getCds()) {
                        all.add(cds);
                    }
                }
                break;
            }
            case TRANSCRIPT: {
                for (Transcript tr : this) {
                    all.add(tr);
                }
                break;
            }
            case INTRON: {
                return Math.max(0, this.sizeof("TRANSCRIPT") - this.sizeof("EXON"));
            }
            case UTR_3_PRIME: {
                for (Transcript tr : this) {
                    for (Utr3prime utr3prime : tr.get3primeUtrs()) {
                        all.add(utr3prime);
                    }
                }
                break;
            }
            case UTR_5_PRIME: {
                for (Transcript tr : this) {
                    for (Utr5prime utr5prime : tr.get5primeUtrs()) {
                        all.add(utr5prime);
                    }
                }
                break;
            }
            case UPSTREAM: {
                for (Transcript tr : this) {
                    all.add(tr.getUpstream());
                }
                break;
            }
            case DOWNSTREAM: {
                for (Transcript tr : this) {
                    all.add(tr.getDownstream());
                }
                break;
            }
            case SPLICE_SITE_ACCEPTOR: {
                for (Transcript tr : this) {
                    for (Exon exon : tr) {
                        if (exon.getSpliceSiteAcceptor() == null) continue;
                        all.add(exon.getSpliceSiteAcceptor());
                    }
                }
                break;
            }
            case SPLICE_SITE_BRANCH: {
                for (Transcript tr : this) {
                    for (SpliceSiteBranch spliceSiteBranch : tr.getSpliceBranchSites()) {
                        all.add(spliceSiteBranch);
                    }
                }
                break;
            }
            case SPLICE_SITE_DONOR: {
                for (Transcript tr : this) {
                    for (Exon exon : tr) {
                        if (exon.getSpliceSiteDonor() == null) continue;
                        all.add(exon.getSpliceSiteDonor());
                    }
                }
                break;
            }
            case INTRAGENIC: {
                Markers gene = new Markers();
                gene.add(this);
                Markers trans = new Markers();
                for (Transcript transcript : this) {
                    trans.add(transcript);
                }
                all = gene.minus(trans);
                break;
            }
            case NONE: {
                return 0;
            }
            default: {
                throw new RuntimeException("Unimplemented sizeof('" + type + "')");
            }
        }
        Markers merged = all.merge();
        for (Marker m : merged) {
            len += m.size();
        }
        return len;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getChromosomeName() + ":" + this.start + "-" + this.end);
        sb.append(", strand:" + this.strand);
        if (this.id != null && this.id.length() > 0) {
            sb.append(", id:" + this.id);
        }
        if (this.geneName != null && this.geneName.length() > 0) {
            sb.append(", name:" + this.geneName);
        }
        if (this.bioType != null && this.bioType.length() > 0) {
            sb.append(", bioType:" + this.bioType);
        }
        sb.append("\n");
        if (this.numChilds() > 0) {
            sb.append("Transcipts:\n");
            for (Transcript tint : this.sorted()) {
                sb.append("\t" + tint + "\n");
            }
        }
        return sb.toString();
    }

    public static enum GeneType {
        CODING,
        NON_CODING,
        UNKNOWN;

    }
}

