/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.annodb;

import java.util.HashSet;
import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.AnnotationTools;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.annodb.AnnotationDB;
import org.biojava.bio.annodb.LazySearchedAnnotationDB;
import org.biojava.bio.annodb.SimpleAnnotationDB;

public class LazyFilteredAnnotationDB
implements AnnotationDB {
    private final AnnotationDB source;
    private final AnnotationType schema;
    private AnnotationDB result;

    public LazyFilteredAnnotationDB(String name, AnnotationDB source, AnnotationType schema) {
        this.source = source;
        this.schema = schema;
    }

    public String getName() {
        return "";
    }

    public AnnotationType getSchema() {
        if (this.result == null) {
            return this.schema;
        }
        return this.result.getSchema();
    }

    public Iterator iterator() {
        if (this.result == null) {
            this.populate();
        }
        return this.result.iterator();
    }

    public int size() {
        if (this.result == null) {
            this.populate();
        }
        return this.result.size();
    }

    public AnnotationDB filter(AnnotationType at) {
        if (this.result == null) {
            return new LazyFilteredAnnotationDB("", this.source, AnnotationTools.intersection(this.schema, at));
        }
        return new LazyFilteredAnnotationDB("", this.result, at);
    }

    public AnnotationDB search(AnnotationType at) {
        if (this.result == null) {
            return new LazySearchedAnnotationDB("", this, at);
        }
        return new LazySearchedAnnotationDB("", this.result, at);
    }

    private void populate() {
        if (this.result != null) {
            return;
        }
        HashSet<Annotation> hits = new HashSet<Annotation>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Annotation ann = (Annotation)i.next();
            if (!this.schema.instanceOf(ann)) continue;
            hits.add(ann);
        }
        this.result = hits.isEmpty() ? AnnotationDB.EMPTY : new SimpleAnnotationDB("", hits, this.schema);
    }
}

