/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.analysis.Stat;
import flanagan.math.BetaFunct;
import flanagan.math.ChiSquareFunct;
import flanagan.math.Ffunct;
import flanagan.math.Fmath;
import flanagan.math.GammaFunct;
import flanagan.math.LogNormalThreeParFunct;
import flanagan.math.LogNormalTwoParFunct;
import flanagan.math.StudentTfunct;
import flanagan.roots.RealRoot;
import java.io.Serializable;
import java.util.Random;

public class PsRandom
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long seed;
    private long initialSeed;
    private int methodOptionDecimal = 1;
    private int methodOptionInteger = 1;
    private Random rr = null;
    private int methodOptionBinary = 1;
    private long ia = 16807L;
    private long im = Integer.MAX_VALUE;
    private double am = 1.0 / (double)this.im;
    private long iq = 127773L;
    private long ir = 2836L;
    private int ntab = 32;
    private long ndiv = 1L + (this.im - 1L) / (long)this.ntab;
    private double eps = 1.2E-7;
    private double rnmx = 1.0 - this.eps;
    private long iy = 0L;
    private long[] iv = new long[this.ntab];
    private int iset = 0;
    private double gset = 0.0;
    private long powTwo1 = 1L;
    private long powTwo2 = 2L;
    private long powTwo5 = 16L;
    private long powTwo18 = 131072L;
    private long mask = this.powTwo1 + this.powTwo2 + this.powTwo5;

    public PsRandom() {
        this.initialSeed = this.seed = System.currentTimeMillis();
        this.rr = new Random(this.seed);
    }

    public PsRandom(long seed) {
        this.seed = seed;
        this.initialSeed = seed;
        this.rr = new Random(this.seed);
    }

    public void setSeed(long seed) {
        this.seed = seed;
        if (this.methodOptionDecimal == 1) {
            this.rr = new Random(this.seed);
        }
    }

    public long getInitialSeed() {
        return this.initialSeed;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setMethodDecimal(int methodOpt) {
        if (methodOpt < 1 || methodOpt > 2) {
            throw new IllegalArgumentException("Argument to PsRandom.setMethodDecimal must 1 or 2\nValue transferred was" + methodOpt);
        }
        this.methodOptionDecimal = methodOpt;
        if (methodOpt == 1) {
            this.rr = new Random(this.seed);
        }
    }

    public int getMethodDecimal() {
        return this.methodOptionDecimal;
    }

    public void setMethodInteger(int methodOpt) {
        if (methodOpt < 1 || methodOpt > 3) {
            throw new IllegalArgumentException("Argument to PsRandom.setMethodInteger must 1, 2 or 3\nValue transferred was" + methodOpt);
        }
        this.methodOptionInteger = methodOpt;
    }

    public int getMethodInteger() {
        return this.methodOptionInteger;
    }

    public void setMethodBinary(int methodOpt) {
        if (methodOpt < 1 || methodOpt > 2) {
            throw new IllegalArgumentException("Argument to PsRandom.setMethodBinary must 1 or 2\nValue transferred was" + methodOpt);
        }
        this.methodOptionBinary = methodOpt;
        if (methodOpt == 1) {
            this.rr = new Random(this.seed);
        }
    }

    public int getMethodBinary() {
        return this.methodOptionBinary;
    }

    public double nextDouble() {
        if (this.methodOptionDecimal == 1) {
            return this.rr.nextDouble();
        }
        return this.parkMiller();
    }

    public double nextDouble(double top) {
        return top * this.nextDouble();
    }

    public double nextDouble(double bottom, double top) {
        return (top - bottom) * this.nextDouble() + bottom;
    }

    public double[] doubleArray(int arrayLength) {
        double[] array = new double[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            array[i] = this.nextDouble();
        }
        return array;
    }

    public double[] doubleArray(int arrayLength, double top) {
        double[] array = new double[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            array[i] = top * this.nextDouble();
        }
        return array;
    }

    public double[] doubleArray(int arrayLength, double bottom, double top) {
        double[] array = new double[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            array[i] = (top - bottom) * this.nextDouble() + bottom;
        }
        return array;
    }

    public double parkMiller() {
        double d;
        int jj = 0;
        long kk = 0L;
        double temp = 0.0;
        this.iy = 0L;
        if (this.seed <= 0L || this.iy != 0L) {
            this.seed = -this.seed < 1L ? 1L : -this.seed;
            for (int j = this.ntab + 7; j >= 0; --j) {
                kk = this.seed / this.iq;
                this.seed = this.ia * (this.seed - kk * this.iq) - this.ir * kk;
                if (this.seed < 0L) {
                    this.seed += this.im;
                }
                if (j >= this.ntab) continue;
                this.iv[j] = this.seed;
            }
            this.iy = this.iv[0];
        }
        kk = this.seed / this.iq;
        this.seed = this.ia * (this.seed - kk * this.iq) - this.ir * kk;
        if (this.seed < 0L) {
            this.seed += this.im;
        }
        jj = (int)(this.iy / this.ndiv);
        this.iy = this.iv[jj];
        this.iv[jj] = this.seed;
        temp = this.am * (double)this.iy;
        if (d > this.rnmx) {
            return this.rnmx;
        }
        return temp;
    }

    public int nextBit() {
        if (this.methodOptionBinary == 1) {
            return this.nextBitM1();
        }
        return this.nextBitM2();
    }

    public int[] bitArray(int arrayLength) {
        int[] bitarray = new int[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            bitarray[i] = this.nextBit();
        }
        return bitarray;
    }

    public int nextBitM1() {
        long newBit = (this.seed & this.powTwo18) >> 17 ^ (this.seed & this.powTwo5) >> 4 ^ (this.seed & this.powTwo2) >> 1 ^ this.seed & this.powTwo1;
        this.seed = this.seed << 1 | newBit;
        return (int)newBit;
    }

    public int nextBitM2() {
        int randomBit = 0;
        if ((this.seed & this.powTwo18) <= 0L) {
            this.seed = (this.seed ^ this.mask) << 1 | this.powTwo1;
            randomBit = 1;
        } else {
            this.seed <<= 1;
            randomBit = 0;
        }
        return randomBit;
    }

    public double nextGaussian(double mean, double sd) {
        double ran = 0.0;
        ran = this.methodOptionDecimal == 1 ? this.rr.nextGaussian() : this.boxMullerParkMiller();
        ran = ran * sd + mean;
        return ran;
    }

    public double nextGaussian() {
        double ran = 0.0;
        ran = this.methodOptionDecimal == 1 ? this.rr.nextGaussian() : this.boxMullerParkMiller();
        return ran;
    }

    public double nextNormal(double mean, double sd) {
        return this.nextGaussian(mean, sd);
    }

    public double nextNormal() {
        return this.nextGaussian();
    }

    public double[] gaussianArray(double mean, double sd, int n) {
        int i;
        double[] ran = new double[n];
        for (i = 0; i < n; ++i) {
            ran[i] = this.nextGaussian();
        }
        ran = Stat.standardize(ran);
        for (i = 0; i < n; ++i) {
            ran[i] = ran[i] * sd + mean;
        }
        return ran;
    }

    public double[] normalArray(double mean, double sd, int n) {
        return this.gaussianArray(mean, sd, n);
    }

    public double[][] correlatedGaussianArrays(double mean1, double mean2, double sd1, double sd2, double rho, int n) {
        if (Math.abs(rho) > 1.0) {
            throw new IllegalArgumentException("The correlation coefficient, " + rho + ", must lie between -1 and 1");
        }
        double[][] ran = new double[2][n];
        double[] ran1 = this.gaussianArray(0.0, 1.0, n);
        double[] ran2 = this.gaussianArray(0.0, 1.0, n);
        double ranh = 0.0;
        double rhot = Math.sqrt(1.0 - rho * rho);
        for (int i = 0; i < n; ++i) {
            ran[0][i] = ran1[i] * sd1 + mean1;
            ran[1][i] = (rho * ran1[i] + rhot * ran2[i]) * sd2 + mean2;
        }
        return ran;
    }

    public double[][] correlatedNormalArrays(double mean1, double mean2, double sd1, double sd2, double rho, int n) {
        return this.correlatedGaussianArrays(mean1, mean2, sd1, sd2, rho, n);
    }

    double boxMullerParkMiller() {
        double fac = 0.0;
        double rsq = 0.0;
        double v1 = 0.0;
        double v2 = 0.0;
        if (this.iset == 0) {
            while ((rsq = (v1 = 2.0 * this.parkMiller() - 1.0) * v1 + (v2 = 2.0 * this.parkMiller() - 1.0) * v2) >= 1.0 || rsq == 0.0) {
            }
            fac = Math.sqrt(-2.0 * Math.log(rsq) / rsq);
            this.gset = v1 * fac;
            this.iset = 1;
            return v2 * fac;
        }
        this.iset = 0;
        return this.gset;
    }

    public double nextLogNormal(double mu, double sigma) {
        double ran = 0.0;
        LogNormalTwoParFunct logNorm2 = new LogNormalTwoParFunct();
        logNorm2.mu = mu;
        logNorm2.sigma = sigma;
        double tolerance = 1.0E-10;
        double lowerBound = 0.0;
        double sigma2 = sigma * sigma;
        double upperBound = 5.0 * Math.sqrt((Math.exp(sigma2) - 1.0) * Math.exp(2.0 * mu + sigma2));
        RealRoot realR = new RealRoot();
        realR.noLowerBoundExtension();
        realR.setTolerance(tolerance);
        realR.resetNaNexceptionToTrue();
        realR.supressLimitReachedMessage();
        realR.supressNaNmessage();
        boolean test = true;
        int ii = 0;
        int imax = 10;
        while (test) {
            logNorm2.cfd = this.nextDouble();
            ran = realR.falsePosition(logNorm2, lowerBound, upperBound);
            if (!Double.isNaN(ran)) {
                test = false;
                continue;
            }
            if (ii > imax) {
                System.out.println("class: PsRandom,  method: nextLogNormal");
                System.out.println(imax + " successive attempts at calculating a random log-normal deviate failed for values of mu = " + mu + ", sigma = " + sigma);
                System.out.println("NaN returned");
                ran = Double.NaN;
                test = false;
                continue;
            }
            ++ii;
        }
        return ran;
    }

    public double nextLogNormalTwoPar(double mu, double sigma) {
        return this.nextLogNormal(mu, sigma);
    }

    public double[] logNormalArray(double mu, double sigma, int n) {
        double[] ran = new double[n];
        LogNormalTwoParFunct logNorm2 = new LogNormalTwoParFunct();
        logNorm2.mu = mu;
        logNorm2.sigma = sigma;
        double tolerance = 1.0E-10;
        double lowerBound = 0.0;
        double sigma2 = sigma * sigma;
        double upperBound = 5.0 * Math.sqrt((Math.exp(sigma2) - 1.0) * Math.exp(2.0 * mu + sigma2));
        for (int i = 0; i < n; ++i) {
            RealRoot realR = new RealRoot();
            realR.noLowerBoundExtension();
            realR.setTolerance(tolerance);
            realR.resetNaNexceptionToTrue();
            realR.supressLimitReachedMessage();
            realR.supressNaNmessage();
            boolean test = true;
            int ii = 0;
            int imax = 10;
            while (test) {
                logNorm2.cfd = this.nextDouble();
                double rangd = realR.bisect(logNorm2, lowerBound, upperBound);
                if (!Double.isNaN(rangd)) {
                    test = false;
                    ran[i] = rangd;
                    continue;
                }
                if (ii > imax) {
                    System.out.println("class: PsRandom,  method: logNormalArray");
                    System.out.println(imax + " successive attempts at calculating a random gamma deviate failed for values of mu = " + mu + ", sigma = " + sigma);
                    System.out.println("NaN returned");
                    ran[i] = Double.NaN;
                    test = false;
                    continue;
                }
                ++ii;
            }
        }
        return ran;
    }

    public double[] logNormalTwoParArray(double mu, double sigma, int n) {
        return this.logNormalArray(mu, sigma, n);
    }

    public double nextLogNormalThreePar(double alpha, double beta, double gamma) {
        double ran = Double.NaN;
        LogNormalThreeParFunct logNorm3 = new LogNormalThreeParFunct();
        logNorm3.alpha = alpha;
        logNorm3.beta = beta;
        logNorm3.gamma = gamma;
        double tolerance = 1.0E-10;
        double lowerBound = alpha;
        double beta2 = beta * beta;
        double upperBound = 5.0 * Math.sqrt((Math.exp(beta2) - 1.0) * Math.exp(2.0 * Math.log(gamma) + beta2));
        RealRoot realR = new RealRoot();
        realR.noLowerBoundExtension();
        realR.setTolerance(tolerance);
        realR.resetNaNexceptionToTrue();
        realR.supressLimitReachedMessage();
        realR.supressNaNmessage();
        boolean test = true;
        int ii = 0;
        int imax = 10;
        while (test) {
            logNorm3.cfd = this.nextDouble();
            ran = realR.falsePosition(logNorm3, lowerBound, upperBound);
            if (!Double.isNaN(ran)) {
                test = false;
                continue;
            }
            if (ii > imax) {
                System.out.println("class: PsRandom,  method: nextLogNormalThreePar");
                System.out.println(imax + " successive attempts at calculating a random log-normal deviate failed for values of alpha = " + alpha + ", beta = " + beta + ", gamma = " + gamma);
                System.out.println("NaN returned");
                ran = Double.NaN;
                test = false;
                continue;
            }
            ++ii;
        }
        return ran;
    }

    public double[] logNormalThreeParArray(double alpha, double beta, double gamma, int n) {
        double[] ran = new double[n];
        LogNormalThreeParFunct logNorm3 = new LogNormalThreeParFunct();
        logNorm3.alpha = alpha;
        logNorm3.beta = beta;
        logNorm3.gamma = gamma;
        double tolerance = 1.0E-10;
        double lowerBound = alpha;
        double beta2 = beta * beta;
        double upperBound = 5.0 * Math.sqrt((Math.exp(beta2) - 1.0) * Math.exp(2.0 * Math.log(gamma) + beta2));
        for (int i = 0; i < n; ++i) {
            RealRoot realR = new RealRoot();
            realR.noLowerBoundExtension();
            realR.setTolerance(tolerance);
            realR.resetNaNexceptionToTrue();
            realR.supressLimitReachedMessage();
            realR.supressNaNmessage();
            boolean test = true;
            int ii = 0;
            int imax = 10;
            while (test) {
                logNorm3.cfd = this.nextDouble();
                double rangd = realR.falsePosition(logNorm3, lowerBound, upperBound);
                if (!Double.isNaN(rangd)) {
                    test = false;
                    ran[i] = rangd;
                    continue;
                }
                if (ii > imax) {
                    System.out.println("class: PsRandom,  method: logNormalThreeParArray");
                    System.out.println(imax + " successive attempts at calculating a log-normal gamma deviate failed for values of alpha = " + alpha + ", beta = " + beta + ", gamma = " + gamma);
                    System.out.println("NaN returned");
                    ran[i] = Double.NaN;
                    test = false;
                    continue;
                }
                ++ii;
            }
        }
        return ran;
    }

    public double nextLorentzian(double mu, double gamma) {
        double ran = Math.tan((this.nextDouble() - 0.5) * Math.PI);
        ran = ran * gamma / 2.0 + mu;
        return ran;
    }

    public double[] lorentzianArray(double mu, double gamma, int n) {
        double[] ran = new double[n];
        for (int i = 0; i < n; ++i) {
            ran[i] = Math.tan((this.nextDouble() - 0.5) * Math.PI);
            ran[i] = ran[i] * gamma / 2.0 + mu;
        }
        return ran;
    }

    public double nextPoissonian(double mean) {
        double ran = 0.0;
        double oldm = -1.0;
        double expt = 0.0;
        double em = 0.0;
        double term = 0.0;
        double sq = 0.0;
        double lnMean = 0.0;
        double yDev = 0.0;
        if (mean < 12.0) {
            if (mean != oldm) {
                oldm = mean;
                expt = Math.exp(-mean);
            }
            em = -1.0;
            term = 1.0;
            do {
                em += 1.0;
            } while ((term *= this.nextDouble()) > expt);
            ran = em;
        } else {
            if (mean != oldm) {
                oldm = mean;
                sq = Math.sqrt(2.0 * mean);
                lnMean = Math.log(mean);
                expt = lnMean - Stat.logGamma(mean + 1.0);
            }
            while (true) {
                if ((em = sq * (yDev = Math.tan(Math.PI * this.nextDouble())) + mean) < 0.0) {
                    continue;
                }
                em = Math.floor(em);
                term = 0.9 * (1.0 + yDev * yDev) * Math.exp(em * lnMean - Stat.logGamma(em + 1.0) - expt);
                if (!(this.nextDouble() > term)) break;
            }
            ran = em;
        }
        return ran;
    }

    public double[] poissonianArray(double mean, int n) {
        double[] ran = new double[n];
        double oldm = -1.0;
        double expt = 0.0;
        double em = 0.0;
        double term = 0.0;
        double sq = 0.0;
        double lnMean = 0.0;
        double yDev = 0.0;
        if (mean < 12.0) {
            for (int i = 0; i < n; ++i) {
                if (mean != oldm) {
                    oldm = mean;
                    expt = Math.exp(-mean);
                }
                em = -1.0;
                term = 1.0;
                do {
                    em += 1.0;
                } while ((term *= this.nextDouble()) > expt);
                ran[i] = em;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (mean != oldm) {
                    oldm = mean;
                    sq = Math.sqrt(2.0 * mean);
                    lnMean = Math.log(mean);
                    expt = lnMean - Stat.logGamma(mean + 1.0);
                }
                while (true) {
                    if ((em = sq * (yDev = Math.tan(Math.PI * this.nextDouble())) + mean) < 0.0) {
                        continue;
                    }
                    em = Math.floor(em);
                    term = 0.9 * (1.0 + yDev * yDev) * Math.exp(em * lnMean - Stat.logGamma(em + 1.0) - expt);
                    if (!(this.nextDouble() > term)) break;
                }
                ran[i] = em;
            }
        }
        return ran;
    }

    public double nextBinomial(double prob, int nTrials) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("The probablity provided, " + prob + ", must lie between 0 and 1)");
        }
        double binomialDeviate = 0.0;
        double deviateMean = 0.0;
        double testDeviate = 0.0;
        double workingProb = 0.0;
        double logProb = 0.0;
        double probOld = -1.0;
        double probC = -1.0;
        double logProbC = -1.0;
        int nOld = -1;
        double enTrials = 0.0;
        double oldGamma = 0.0;
        double tanW = 0.0;
        double hold0 = 0.0;
        workingProb = prob <= 0.5 ? prob : 1.0 - prob;
        deviateMean = (double)nTrials * workingProb;
        if (nTrials < 25) {
            binomialDeviate = 0.0;
            for (int jj = 1; jj <= nTrials; ++jj) {
                if (!(this.nextDouble() < workingProb)) continue;
                binomialDeviate += 1.0;
            }
        } else if (deviateMean < 1.0) {
            int jj;
            double expOfMean = Math.exp(-deviateMean);
            testDeviate = 1.0;
            for (jj = 0; jj <= nTrials && !((testDeviate *= this.nextDouble()) < expOfMean); ++jj) {
            }
            binomialDeviate = jj <= nTrials ? jj : nTrials;
        } else {
            if (nTrials != nOld) {
                enTrials = nTrials;
                oldGamma = Stat.logGamma(enTrials + 1.0);
                nOld = nTrials;
            }
            if (workingProb != probOld) {
                probC = 1.0 - workingProb;
                logProb = Math.log(workingProb);
                logProbC = Math.log(probC);
                probOld = workingProb;
            }
            double sq = Math.sqrt(2.0 * deviateMean * probC);
            while (true) {
                double angle;
                if ((hold0 = sq * (tanW = Math.tan(angle = Math.PI * this.nextDouble())) + deviateMean) < 0.0 || hold0 >= enTrials + 1.0) {
                    continue;
                }
                hold0 = Math.floor(hold0);
                testDeviate = 1.2 * sq * (1.0 + tanW * tanW) * Math.exp(oldGamma - Stat.logGamma(hold0 + 1.0) - Stat.logGamma(enTrials - hold0 + 1.0) + hold0 * logProb + (enTrials - hold0) * logProbC);
                if (!(this.nextDouble() > testDeviate)) break;
            }
            binomialDeviate = hold0;
        }
        if (workingProb != prob) {
            binomialDeviate = (double)nTrials - binomialDeviate;
        }
        return binomialDeviate;
    }

    public double[] binomialArray(double prob, int nTrials, int n) {
        if (nTrials < n) {
            throw new IllegalArgumentException("Number of deviates requested, " + n + ", must be less than the number of trials, " + nTrials);
        }
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("The probablity provided, " + prob + ", must lie between 0 and 1)");
        }
        double[] ran = new double[n];
        double binomialDeviate = 0.0;
        double deviateMean = 0.0;
        double testDeviate = 0.0;
        double workingProb = 0.0;
        double logProb = 0.0;
        double probOld = -1.0;
        double probC = -1.0;
        double logProbC = -1.0;
        int nOld = -1;
        double enTrials = 0.0;
        double oldGamma = 0.0;
        double tanW = 0.0;
        double hold0 = 0.0;
        double probOriginalValue = prob;
        for (int i = 0; i < n; ++i) {
            int jj;
            prob = probOriginalValue;
            workingProb = prob <= 0.5 ? prob : 1.0 - prob;
            deviateMean = (double)nTrials * workingProb;
            if (nTrials < 25) {
                binomialDeviate = 0.0;
                for (jj = 1; jj <= nTrials; ++jj) {
                    if (!(this.nextDouble() < workingProb)) continue;
                    binomialDeviate += 1.0;
                }
            } else if (deviateMean < 1.0) {
                double expOfMean = Math.exp(-deviateMean);
                testDeviate = 1.0;
                for (jj = 0; jj <= nTrials && !((testDeviate *= this.nextDouble()) < expOfMean); ++jj) {
                }
                binomialDeviate = jj <= nTrials ? jj : nTrials;
            } else {
                if (nTrials != nOld) {
                    enTrials = nTrials;
                    oldGamma = Stat.logGamma(enTrials + 1.0);
                    nOld = nTrials;
                }
                if (workingProb != probOld) {
                    probC = 1.0 - workingProb;
                    logProb = Math.log(workingProb);
                    logProbC = Math.log(probC);
                    probOld = workingProb;
                }
                double sq = Math.sqrt(2.0 * deviateMean * probC);
                while (true) {
                    double angle;
                    if ((hold0 = sq * (tanW = Math.tan(angle = Math.PI * this.nextDouble())) + deviateMean) < 0.0 || hold0 >= enTrials + 1.0) {
                        continue;
                    }
                    hold0 = Math.floor(hold0);
                    testDeviate = 1.2 * sq * (1.0 + tanW * tanW) * Math.exp(oldGamma - Stat.logGamma(hold0 + 1.0) - Stat.logGamma(enTrials - hold0 + 1.0) + hold0 * logProb + (enTrials - hold0) * logProbC);
                    if (!(this.nextDouble() > testDeviate)) break;
                }
                binomialDeviate = hold0;
            }
            if (workingProb != prob) {
                binomialDeviate = (double)nTrials - binomialDeviate;
            }
            ran[i] = binomialDeviate;
        }
        return ran;
    }

    public double nextPareto(double alpha, double beta) {
        return Math.pow(1.0 - this.nextDouble(), -1.0 / alpha) * beta;
    }

    public double[] paretoArray(double alpha, double beta, int n) {
        double[] ran = new double[n];
        for (int i = 0; i < n; ++i) {
            ran[i] = Math.pow(1.0 - this.nextDouble(), -1.0 / alpha) * beta;
        }
        return ran;
    }

    public double nextExponential(double mu, double sigma) {
        return mu - Math.log(1.0 - this.nextDouble()) * sigma;
    }

    public double[] exponentialArray(double mu, double sigma, int n) {
        double[] ran = new double[n];
        for (int i = 0; i < n; ++i) {
            ran[i] = mu - Math.log(1.0 - this.nextDouble()) * sigma;
        }
        return ran;
    }

    public double nextRayleigh(double sigma) {
        return Math.sqrt(-2.0 * Math.log(1.0 - this.nextDouble())) * sigma;
    }

    public double[] rayleighArray(double sigma, int n) {
        double[] ran = new double[n];
        for (int i = 0; i < n; ++i) {
            ran[i] = Math.sqrt(-2.0 * Math.log(1.0 - this.nextDouble())) * sigma;
        }
        return ran;
    }

    public double nextMinimalGumbel(double mu, double sigma) {
        return Math.log(Math.log(1.0 / (1.0 - this.nextDouble()))) * sigma + mu;
    }

    public double[] minimalGumbelArray(double mu, double sigma, int n) {
        double[] ran = new double[n];
        for (int i = 0; i < n; ++i) {
            ran[i] = Math.log(Math.log(1.0 / (1.0 - this.nextDouble()))) * sigma + mu;
        }
        return ran;
    }

    public double nextMaximalGumbel(double mu, double sigma) {
        return mu - Math.log(Math.log(1.0 / (1.0 - this.nextDouble()))) * sigma;
    }

    public double[] maximalGumbelArray(double mu, double sigma, int n) {
        double[] ran = new double[n];
        for (int i = 0; i < n; ++i) {
            ran[i] = mu - Math.log(Math.log(1.0 / (1.0 - this.nextDouble()))) * sigma;
        }
        return ran;
    }

    public double nextFrechet(double mu, double sigma, double gamma) {
        return Math.pow(1.0 / Math.log(1.0 / this.nextDouble()), 1.0 / gamma) * sigma + mu;
    }

    public double[] frechetArray(double mu, double sigma, double gamma, int n) {
        double[] ran = new double[n];
        for (int i = 0; i < n; ++i) {
            ran[i] = Math.pow(1.0 / Math.log(1.0 / this.nextDouble()), 1.0 / gamma) * sigma + mu;
        }
        return ran;
    }

    public double nextWeibull(double mu, double sigma, double gamma) {
        return Math.pow(-Math.log(1.0 - this.nextDouble()), 1.0 / gamma) * sigma + mu;
    }

    public double[] weibullArray(double mu, double sigma, double gamma, int n) {
        double[] ran = new double[n];
        for (int i = 0; i < n; ++i) {
            ran[i] = Math.pow(-Math.log(1.0 - this.nextDouble()), 1.0 / gamma) * sigma + mu;
        }
        return ran;
    }

    public double nextLogistic(double mu, double scale) {
        return 2.0 * scale * Fmath.atanh(2.0 * this.nextDouble() - 1.0) + mu;
    }

    public double[] logisticArray(double mu, double scale, int n) {
        double[] ran = new double[n];
        for (int i = 0; i < n; ++i) {
            ran[i] = 2.0 * scale * Fmath.atanh(2.0 * this.nextDouble() - 1.0) + mu;
        }
        return ran;
    }

    public double nextStudentT(int nu) {
        double ran = 0.0;
        StudentTfunct strt = new StudentTfunct();
        strt.nu = nu;
        double centre = 0.0;
        double range = 100.0;
        if (nu > 2) {
            range = nu / (nu - 2);
        }
        double lowerBound = centre - 5.0 * range;
        double upperBound = centre + 5.0 * range;
        double tolerance = 1.0E-10;
        RealRoot realR = new RealRoot();
        realR.setTolerance(tolerance);
        realR.resetNaNexceptionToTrue();
        realR.supressLimitReachedMessage();
        realR.supressNaNmessage();
        boolean test = true;
        int ii = 0;
        int imax = 10;
        while (test) {
            strt.cfd = this.nextDouble();
            ran = realR.falsePosition(strt, lowerBound, upperBound);
            if (!Double.isNaN(ran)) {
                test = false;
                continue;
            }
            if (ii > imax) {
                System.out.println("class: PsRandom,  method: studentT");
                System.out.println(imax + " successive attempts at calculating a random Student's T deviate failed for values of nu = " + nu);
                System.out.println("NaN returned");
                ran = Double.NaN;
                test = false;
                continue;
            }
            ++ii;
        }
        return ran;
    }

    public double[] studentTarray(int nu, int n) {
        double[] ran = new double[n];
        StudentTfunct strt = new StudentTfunct();
        strt.nu = nu;
        double centre = 0.0;
        double range = 100.0;
        if (nu > 2) {
            range = nu / (nu - 2);
        }
        double tolerance = 1.0E-10;
        double lowerBound = centre - 5.0 * range;
        double upperBound = centre + 5.0 * range;
        for (int i = 0; i < n; ++i) {
            RealRoot realR = new RealRoot();
            realR.setTolerance(tolerance);
            realR.resetNaNexceptionToTrue();
            realR.supressLimitReachedMessage();
            realR.supressNaNmessage();
            boolean test = true;
            int ii = 0;
            int imax = 10;
            while (test) {
                strt.cfd = this.nextDouble();
                double rangd = realR.falsePosition(strt, lowerBound, upperBound);
                if (!Double.isNaN(rangd)) {
                    test = false;
                    ran[i] = rangd;
                    continue;
                }
                if (ii > imax) {
                    System.out.println("class: PsRandom,  method: studentTarray");
                    System.out.println(imax + " successive attempts at calculating a random gamma deviate failed for values of nu = " + nu);
                    System.out.println("NaN returned");
                    ran[i] = Double.NaN;
                    test = false;
                    continue;
                }
                ++ii;
            }
        }
        return ran;
    }

    public double nextBeta(double alpha, double beta) {
        return this.nextBeta(0.0, 1.0, alpha, beta);
    }

    public double nextBeta(double min, double max, double alpha, double beta) {
        double ran = 0.0;
        BetaFunct bart = new BetaFunct();
        bart.alpha = alpha;
        bart.beta = beta;
        bart.min = min;
        bart.max = max;
        double tolerance = 1.0E-10;
        double lowerBound = min;
        double upperBound = max;
        RealRoot realR = new RealRoot();
        realR.noLowerBoundExtension();
        realR.noUpperBoundExtension();
        realR.setTolerance(tolerance);
        realR.resetNaNexceptionToTrue();
        realR.supressLimitReachedMessage();
        realR.supressNaNmessage();
        boolean test = true;
        int ii = 0;
        int imax = 10;
        while (test) {
            bart.cfd = this.nextDouble();
            ran = realR.falsePosition(bart, lowerBound, upperBound);
            if (!Double.isNaN(ran)) {
                test = false;
                continue;
            }
            if (ii > imax) {
                System.out.println("class: PsRandom,  method: nextBeta");
                System.out.println(imax + " successive attempts at calculating a random beta deviate failed for values of min = " + min + ", max = " + max + ", alpha = " + alpha + ", beta = " + beta);
                System.out.println("NaN returned");
                ran = Double.NaN;
                test = false;
                continue;
            }
            ++ii;
        }
        return ran;
    }

    public double[] betaArray(double alpha, double beta, int n) {
        return this.betaArray(0.0, 1.0, alpha, beta, n);
    }

    public double[] betaArray(double min, double max, double alpha, double beta, int n) {
        double[] ran = new double[n];
        BetaFunct bart = new BetaFunct();
        bart.alpha = alpha;
        bart.beta = beta;
        bart.min = min;
        bart.max = max;
        double tolerance = 1.0E-10;
        double lowerBound = min;
        double upperBound = max;
        for (int i = 0; i < n; ++i) {
            RealRoot realR = new RealRoot();
            realR.noLowerBoundExtension();
            realR.noUpperBoundExtension();
            realR.setTolerance(tolerance);
            realR.resetNaNexceptionToTrue();
            realR.supressLimitReachedMessage();
            realR.supressNaNmessage();
            boolean test = true;
            int ii = 0;
            int imax = 10;
            while (test) {
                bart.cfd = this.nextDouble();
                double rangd = realR.bisect(bart, lowerBound, upperBound);
                if (!Double.isNaN(rangd)) {
                    test = false;
                    ran[i] = rangd;
                    continue;
                }
                if (ii > imax) {
                    System.out.println("class: PsRandom,  method: betaArray");
                    System.out.println(imax + " successive attempts at calculating a random beta deviate failed for values of min = " + min + ", max = " + max + ", alpha = " + alpha + ", beta = " + beta);
                    System.out.println("NaN returned");
                    ran[i] = Double.NaN;
                    test = false;
                    continue;
                }
                ++ii;
            }
        }
        return ran;
    }

    public double nextGamma(double mu, double beta, double gamma) {
        double ran = 0.0;
        GammaFunct gart = new GammaFunct();
        gart.mu = mu;
        gart.beta = beta;
        gart.gamma = gamma;
        double range = Math.sqrt(gamma) * beta;
        double tolerance = 1.0E-10;
        double upperBound = mu + 5.0 * range;
        double lowerBound = mu;
        if (upperBound <= lowerBound) {
            upperBound += range;
        }
        RealRoot realR = new RealRoot();
        realR.noLowerBoundExtension();
        realR.setTolerance(tolerance);
        realR.resetNaNexceptionToTrue();
        realR.supressLimitReachedMessage();
        realR.supressNaNmessage();
        boolean test = true;
        int ii = 0;
        int imax = 10;
        while (test) {
            gart.cfd = this.nextDouble();
            ran = realR.bisect(gart, lowerBound, upperBound);
            if (!Double.isNaN(ran)) {
                test = false;
                continue;
            }
            if (ii > imax) {
                System.out.println("class: PsRandom,  method: nextGamma");
                System.out.println(imax + " successive attempts at calculating a random gamma deviate failed for values of mu = " + mu + ", beta = " + beta + ", gamma = " + gamma);
                System.out.println("NaN returned");
                ran = Double.NaN;
                test = false;
                continue;
            }
            ++ii;
        }
        return ran;
    }

    public double[] gammaArray(double mu, double beta, double gamma, int n) {
        double[] ran = new double[n];
        GammaFunct gart = new GammaFunct();
        gart.mu = mu;
        gart.beta = beta;
        gart.gamma = gamma;
        double range = Math.sqrt(gamma) * beta;
        double tolerance = 1.0E-10;
        double upperBound = mu + 5.0 * range;
        double lowerBound = mu;
        if (upperBound <= lowerBound) {
            upperBound += range;
        }
        for (int i = 0; i < n; ++i) {
            RealRoot realR = new RealRoot();
            realR.noLowerBoundExtension();
            realR.setTolerance(tolerance);
            realR.resetNaNexceptionToTrue();
            realR.supressLimitReachedMessage();
            realR.supressNaNmessage();
            boolean test = true;
            int ii = 0;
            int imax = 10;
            while (test) {
                gart.cfd = this.nextDouble();
                double rangd = realR.bisect(gart, lowerBound, upperBound);
                if (!Double.isNaN(rangd)) {
                    test = false;
                    ran[i] = rangd;
                    continue;
                }
                if (ii > imax) {
                    System.out.println("class: PsRandom,  method: gammaArray");
                    System.out.println(imax + " successive attempts at calculating a random gamma deviate failed for values of mu = " + mu + ", beta = " + beta + ", gamma = " + gamma);
                    System.out.println("NaN returned");
                    ran[i] = Double.NaN;
                    test = false;
                    continue;
                }
                ++ii;
            }
        }
        return ran;
    }

    public double nextErlang(double lambda, int kay) {
        return this.nextGamma(0.0, 1.0 / lambda, kay);
    }

    public double[] erlangArray(double lambda, int kay, int n) {
        return this.gammaArray(0.0, 1.0 / lambda, kay, n);
    }

    public double[] chiSquareArray(int nu, int n) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        double[] ran = new double[n];
        ChiSquareFunct csrt = new ChiSquareFunct();
        csrt.nu = nu;
        double tolerance = 1.0E-10;
        double lowerBound = 0.0;
        double upperBound = 5.0 * Math.sqrt(2 * nu);
        for (int i = 0; i < n; ++i) {
            RealRoot realR = new RealRoot();
            realR.noLowerBoundExtension();
            realR.setTolerance(tolerance);
            realR.resetNaNexceptionToTrue();
            realR.supressLimitReachedMessage();
            realR.supressNaNmessage();
            boolean test = true;
            int ii = 0;
            int imax = 10;
            while (test) {
                csrt.cfd = this.nextDouble();
                double rangd = realR.falsePosition(csrt, lowerBound, upperBound);
                if (!Double.isNaN(rangd)) {
                    test = false;
                    ran[i] = rangd;
                    continue;
                }
                if (ii > imax) {
                    System.out.println("class: PsRandom,  method: chiSquareArray");
                    System.out.println(imax + " successive attempts at calculating a random chi square deviate failed for values of nu = " + nu);
                    System.out.println("NaN returned");
                    ran[i] = Double.NaN;
                    test = false;
                    continue;
                }
                ++ii;
            }
        }
        return ran;
    }

    public double nextChiSquare(int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        double ran = 0.0;
        ChiSquareFunct csrt = new ChiSquareFunct();
        csrt.nu = nu;
        double tolerance = 1.0E-10;
        double lowerBound = 0.0;
        double upperBound = 5.0 * Math.sqrt(2 * nu);
        RealRoot realR = new RealRoot();
        realR.noLowerBoundExtension();
        realR.setTolerance(tolerance);
        realR.resetNaNexceptionToTrue();
        realR.supressLimitReachedMessage();
        realR.supressNaNmessage();
        boolean test = true;
        int ii = 0;
        int imax = 10;
        while (test) {
            csrt.cfd = this.nextDouble();
            ran = realR.falsePosition(csrt, lowerBound, upperBound);
            if (!Double.isNaN(ran)) {
                test = false;
                continue;
            }
            if (ii > imax) {
                System.out.println("class: PsRandom,  method: nextChiSqauare");
                System.out.println(imax + " successive attempts at calculating a random Chi Square deviate failed for values of nu = " + nu);
                System.out.println("NaN returned");
                ran = Double.NaN;
                test = false;
                continue;
            }
            ++ii;
        }
        return ran;
    }

    public double nextF(int nu1, int nu2) {
        double ran = Double.NaN;
        Ffunct frt = new Ffunct();
        frt.nu1 = nu1;
        frt.nu2 = nu2;
        double tolerance = 1.0E-10;
        double lowerBound = 0.0;
        double upperBound = 10.0;
        if (nu2 > 4) {
            upperBound = 5.0 * Math.sqrt(2 * nu2 * nu2 * (nu1 + nu2 - 2) / (nu1 * (nu2 - 2) * (nu2 - 2) * (nu2 - 4)));
        }
        RealRoot realR = new RealRoot();
        realR.noLowerBoundExtension();
        realR.setTolerance(tolerance);
        realR.resetNaNexceptionToTrue();
        realR.supressLimitReachedMessage();
        realR.supressNaNmessage();
        boolean test = true;
        int ii = 0;
        int imax = 10;
        while (test) {
            frt.cfd = this.nextDouble();
            ran = realR.falsePosition(frt, lowerBound, upperBound);
            if (!Double.isNaN(ran)) {
                test = false;
                continue;
            }
            if (ii > imax) {
                System.out.println("class: PsRandom,  method: nextF");
                System.out.println(imax + " successive attempts at calculating a random F-distribution deviate failed for values of nu1 = " + nu1 + ", nu2 = " + nu2);
                System.out.println("NaN returned");
                ran = Double.NaN;
                test = false;
                continue;
            }
            ++ii;
        }
        return ran;
    }

    public double[] fArray(int nu1, int nu2, int n) {
        double[] ran = new double[n];
        Ffunct frt = new Ffunct();
        frt.nu1 = nu1;
        frt.nu2 = nu2;
        double tolerance = 1.0E-10;
        double lowerBound = 0.0;
        double upperBound = 10.0;
        double nu1d = nu1;
        double nu2d = nu2;
        if (nu2 > 4) {
            upperBound = 5.0 * Math.sqrt(2.0 * nu2d * nu2d * (nu1d + nu2d - 2.0) / (nu1d * (nu2d - 2.0) * (nu2d - 2.0) * (nu2d - 4.0)));
        }
        for (int i = 0; i < n; ++i) {
            RealRoot realR = new RealRoot();
            realR.noLowerBoundExtension();
            realR.setTolerance(tolerance);
            realR.resetNaNexceptionToTrue();
            realR.supressLimitReachedMessage();
            realR.supressNaNmessage();
            boolean test = true;
            int ii = 0;
            int imax = 10;
            while (test) {
                frt.cfd = this.nextDouble();
                double rangd = realR.falsePosition(frt, lowerBound, upperBound);
                if (!Double.isNaN(rangd)) {
                    test = false;
                    ran[i] = rangd;
                    continue;
                }
                if (ii > imax) {
                    System.out.println("class: PsRandom,  method: fArray");
                    System.out.println(imax + " successive attempts at calculating a random f-distribution deviate failed for values of nu1 = " + nu1 + ", nu2 = " + nu2);
                    System.out.println("NaN returned");
                    ran[i] = Double.NaN;
                    test = false;
                    continue;
                }
                ++ii;
            }
        }
        return ran;
    }

    public int nextInteger(int bottom, int top) {
        int randint = 0;
        switch (this.methodOptionInteger) {
            case 1: {
                randint = this.rr.nextInt(++top - bottom) + bottom;
                break;
            }
            case 2: {
                randint = (int)Math.round(this.nextDouble() * (double)(top - bottom)) + bottom;
                break;
            }
            case 3: {
                randint = (int)Math.floor(this.nextDouble() * (double)(++top - bottom)) + bottom;
                break;
            }
            default: {
                throw new IllegalArgumentException("methodOptionInteger, " + this.methodOptionInteger + " is not recognised");
            }
        }
        return randint;
    }

    public int nextInteger(int top) {
        return this.nextInteger(0, top);
    }

    public int[] integerArray(int arrayLength, int top) {
        int[] array = new int[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            array[i] = this.nextInteger(top);
        }
        return array;
    }

    public int[] integerArray(int arrayLength, int bottom, int top) {
        int[] array = new int[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            array[i] = this.nextInteger(top - bottom) + bottom;
        }
        return array;
    }

    public int[] noRepeatIntegerArray(int arrayLength, int bottom, int top) {
        int[] array = new int[arrayLength];
        boolean test = true;
        int hold = -1;
        int nFound = 0;
        boolean repeatTest = true;
        while (test) {
            hold = this.nextInteger(top - bottom) + bottom;
            if (nFound == 0) {
                array[0] = hold;
                nFound = 1;
            } else {
                repeatTest = true;
                for (int i = 0; i < nFound; ++i) {
                    if (array[i] != hold) continue;
                    repeatTest = false;
                }
                if (repeatTest) {
                    array[nFound] = hold;
                    ++nFound;
                }
            }
            if (nFound != arrayLength) continue;
            test = false;
        }
        return array;
    }

    public int[] uniqueIntegerArray(int bottom, int top) {
        int range = top - bottom;
        int[] array = this.uniqueIntegerArray(range);
        int i = 0;
        while (i < range + 1) {
            int n = i++;
            array[n] = array[n] + bottom;
        }
        return array;
    }

    public int[] uniqueIntegerArray(int top) {
        int numberOfIntegers = top + 1;
        int[] array = new int[numberOfIntegers];
        boolean allFound = false;
        int nFound = 0;
        boolean[] found = new boolean[numberOfIntegers];
        for (int i = 0; i < numberOfIntegers; ++i) {
            found[i] = false;
        }
        while (!allFound) {
            int ii = this.nextInteger(top);
            if (found[ii]) continue;
            array[nFound] = ii;
            found[ii] = true;
            if (++nFound != numberOfIntegers) continue;
            allFound = true;
        }
        return array;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }
}

