/*
 * Decompiled with CFR 0.152.
 */
package flanagan.complex;

import flanagan.complex.Complex;
import flanagan.math.Fmath;
import flanagan.math.Matrix;

public class ComplexMatrix {
    private int nrow = 0;
    private int ncol = 0;
    private Complex[][] matrix = null;
    private int[] index = null;
    private double dswap = 1.0;
    private static final double TINY = 1.0E-30;

    public ComplexMatrix(int nrow, int ncol) {
        this.nrow = nrow;
        this.ncol = ncol;
        this.matrix = Complex.twoDarray(nrow, ncol);
        this.index = new int[nrow];
        for (int i = 0; i < nrow; ++i) {
            this.index[i] = i;
        }
        this.dswap = 1.0;
    }

    public ComplexMatrix(int nrow, int ncol, Complex constant) {
        this.nrow = nrow;
        this.ncol = ncol;
        this.matrix = Complex.twoDarray(nrow, ncol, constant);
        this.index = new int[nrow];
        for (int i = 0; i < nrow; ++i) {
            this.index[i] = i;
        }
        this.dswap = 1.0;
    }

    public ComplexMatrix(Complex[][] twoD) {
        int i;
        this.nrow = twoD.length;
        this.ncol = twoD[0].length;
        this.matrix = Complex.twoDarray(this.nrow, this.ncol);
        for (i = 0; i < this.nrow; ++i) {
            if (twoD[i].length != this.ncol) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            for (int j = 0; j < this.ncol; ++j) {
                this.matrix[i][j] = Complex.copy(twoD[i][j]);
            }
        }
        this.index = new int[this.nrow];
        for (i = 0; i < this.nrow; ++i) {
            this.index[i] = i;
        }
        this.dswap = 1.0;
    }

    public ComplexMatrix(double[][] twoD) {
        int i;
        this.nrow = twoD.length;
        this.ncol = twoD[0].length;
        for (i = 0; i < this.nrow; ++i) {
            if (twoD[i].length == this.ncol) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = Complex.twoDarray(this.nrow, this.ncol);
        for (i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                this.matrix[i][j] = new Complex(twoD[i][j], 0.0);
            }
        }
        this.index = new int[this.nrow];
        for (i = 0; i < this.nrow; ++i) {
            this.index[i] = i;
        }
        this.dswap = 1.0;
    }

    public ComplexMatrix(ComplexMatrix bb) {
        this.nrow = bb.nrow;
        this.ncol = bb.ncol;
        this.matrix = bb.copy().matrix;
        this.index = bb.index;
        this.dswap = bb.dswap;
    }

    public ComplexMatrix(Matrix bb) {
        this.nrow = bb.getNrow();
        this.ncol = bb.getNcol();
        double[][] array = bb.getArrayCopy();
        this.matrix = Complex.twoDarray(this.nrow, this.ncol);
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                this.matrix[i][j] = new Complex(array[i][j], 0.0);
            }
        }
        this.index = bb.getIndexCopy();
        this.dswap = bb.getSwap();
    }

    public void setTwoDarray(Complex[][] aarray) {
        if (this.nrow != aarray.length) {
            throw new IllegalArgumentException("row length of this ComplexMatrix differs from that of the 2D array argument");
        }
        if (this.ncol != aarray[0].length) {
            throw new IllegalArgumentException("column length of this ComplexMatrix differs from that of the 2D array argument");
        }
        for (int i = 0; i < this.nrow; ++i) {
            if (aarray[i].length != this.ncol) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            for (int j = 0; j < this.ncol; ++j) {
                this.matrix[i][j] = Complex.copy(aarray[i][j]);
            }
        }
    }

    public void setTwoDarray(double[][] aarray) {
        if (this.nrow != aarray.length) {
            throw new IllegalArgumentException("row length of this ComplexMatrix differs from that of the 2D array argument");
        }
        if (this.ncol != aarray[0].length) {
            throw new IllegalArgumentException("column length of this ComplexMatrix differs from that of the 2D array argument");
        }
        for (int i = 0; i < this.nrow; ++i) {
            if (aarray[i].length != this.ncol) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            for (int j = 0; j < this.ncol; ++j) {
                this.matrix[i][j] = new Complex(aarray[i][j]);
            }
        }
    }

    public void setElement(int i, int j, Complex aa) {
        this.matrix[i][j] = Complex.copy(aa);
    }

    public void setElement(int i, int j, double aa, double bb) {
        this.matrix[i][j].reset(aa, bb);
    }

    public void setSubMatrix(int i, int j, int k, int l, Complex[][] subMatrix) {
        this.setSubMatrix(i, j, subMatrix);
    }

    public void setSubMatrix(int i, int j, Complex[][] subMatrix) {
        int k = subMatrix.length;
        int l = subMatrix[0].length;
        if (i + k - 1 >= this.nrow) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (j + l - 1 >= this.ncol) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix");
        }
        int m = 0;
        int n = 0;
        for (int p = 0; p < k; ++p) {
            n = 0;
            for (int q = 0; q < l; ++q) {
                this.matrix[i + p][j + q] = Complex.copy(subMatrix[m][n]);
                ++n;
            }
            ++m;
        }
    }

    public void setSubMatrix(int[] row, int[] col, Complex[][] subMatrix) {
        int n = row.length;
        int m = col.length;
        for (int p = 0; p < n; ++p) {
            for (int q = 0; q < m; ++q) {
                this.matrix[row[p]][col[q]] = Complex.copy(subMatrix[p][q]);
            }
        }
    }

    public static ComplexMatrix identityMatrix(int nrow) {
        ComplexMatrix u = new ComplexMatrix(nrow, nrow);
        for (int i = 0; i < nrow; ++i) {
            u.matrix[i][i] = Complex.plusOne();
        }
        return u;
    }

    public static ComplexMatrix scalarMatrix(int nrow, Complex diagconst) {
        ComplexMatrix u = new ComplexMatrix(nrow, nrow);
        Complex[][] uarray = u.getArrayReference();
        for (int i = 0; i < nrow; ++i) {
            for (int j = i; j < nrow; ++j) {
                if (i != j) continue;
                uarray[i][j] = Complex.copy(diagconst);
            }
        }
        return u;
    }

    public static ComplexMatrix diagonalMatrix(int nrow, Complex[] diag) {
        if (diag.length != nrow) {
            throw new IllegalArgumentException("matrix dimension differs from diagonal array length");
        }
        ComplexMatrix u = new ComplexMatrix(nrow, nrow);
        Complex[][] uarray = u.getArrayReference();
        for (int i = 0; i < nrow; ++i) {
            for (int j = i; j < nrow; ++j) {
                if (i != j) continue;
                uarray[i][j] = Complex.copy(diag[i]);
            }
        }
        return u;
    }

    public static ComplexMatrix columnMatrix(Complex[] darray) {
        int nr = darray.length;
        ComplexMatrix pp = new ComplexMatrix(nr, 1);
        for (int i = 0; i < nr; ++i) {
            pp.matrix[i][0] = darray[i];
        }
        return pp;
    }

    public static ComplexMatrix rowMatrix(Complex[] darray) {
        int nc = darray.length;
        ComplexMatrix pp = new ComplexMatrix(1, nc);
        for (int i = 0; i < nc; ++i) {
            pp.matrix[0][i] = darray[i];
        }
        return pp;
    }

    public static ComplexMatrix toComplexColumnMatrix(Complex[] carray) {
        int nr = carray.length;
        ComplexMatrix cc = new ComplexMatrix(nr, 1);
        for (int i = 0; i < nr; ++i) {
            cc.matrix[i][0] = carray[i].copy();
        }
        return cc;
    }

    public static ComplexMatrix toComplexColumnMatrix(double[] darray) {
        int nr = darray.length;
        ComplexMatrix cc = new ComplexMatrix(nr, 1);
        for (int i = 0; i < nr; ++i) {
            cc.matrix[i][0].reset(darray[i], 0.0);
        }
        return cc;
    }

    public static ComplexMatrix toComplexRowMatrix(Complex[] carray) {
        int nc = carray.length;
        ComplexMatrix cc = new ComplexMatrix(1, nc);
        for (int i = 0; i < nc; ++i) {
            cc.matrix[0][i] = carray[i].copy();
        }
        return cc;
    }

    public static ComplexMatrix toComplexRowMatrix(double[] darray) {
        int nc = darray.length;
        ComplexMatrix cc = new ComplexMatrix(1, nc);
        for (int i = 0; i < nc; ++i) {
            cc.matrix[0][i].reset(darray[i], 0.0);
        }
        return cc;
    }

    public static ComplexMatrix toComplexMatrix(Matrix marray) {
        int nr = marray.getNrow();
        int nc = marray.getNcol();
        ComplexMatrix pp = new ComplexMatrix(nr, nc);
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                pp.matrix[i][j].reset(marray.getElementCopy(i, j), 0.0);
            }
        }
        return pp;
    }

    public static ComplexMatrix toComplexMatrix(double[][] darray) {
        int nr = darray.length;
        int nc = darray[0].length;
        for (int i = 1; i < nr; ++i) {
            if (darray[i].length == nc) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        ComplexMatrix pp = new ComplexMatrix(nr, nc);
        for (int i = 0; i < pp.nrow; ++i) {
            for (int j = 0; j < pp.ncol; ++j) {
                pp.matrix[i][j].reset(darray[i][j], 0.0);
            }
        }
        return pp;
    }

    public int getNrow() {
        return this.nrow;
    }

    public int getNcol() {
        return this.ncol;
    }

    public Complex[][] getArrayReference() {
        return this.matrix;
    }

    public Complex[][] getArray() {
        return this.matrix;
    }

    public Complex[][] getArrayPointer() {
        return this.matrix;
    }

    public Complex[][] getArrayCopy() {
        Complex[][] c = new Complex[this.nrow][this.ncol];
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                c[i][j] = Complex.copy(this.matrix[i][j]);
            }
        }
        return c;
    }

    public Complex getElementReference(int i, int j) {
        return this.matrix[i][j];
    }

    public Complex getElementPointer(int i, int j) {
        return this.matrix[i][j];
    }

    public Complex getElementCopy(int i, int j) {
        return Complex.copy(this.matrix[i][j]);
    }

    public ComplexMatrix getSubMatrix(int i, int j, int k, int l) {
        if (i > k) {
            throw new IllegalArgumentException("row indices inverted");
        }
        if (j > l) {
            throw new IllegalArgumentException("column indices inverted");
        }
        if (k >= this.nrow) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (l >= this.ncol) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix" + i + " " + l);
        }
        int n = k - i + 1;
        int m = l - j + 1;
        ComplexMatrix subMatrix = new ComplexMatrix(n, m);
        Complex[][] sarray = subMatrix.getArrayReference();
        for (int p = 0; p < n; ++p) {
            for (int q = 0; q < m; ++q) {
                sarray[p][q] = Complex.copy(this.matrix[i + p][j + q]);
            }
        }
        return subMatrix;
    }

    public ComplexMatrix getSubMatrix(int[] row, int[] col) {
        int n = row.length;
        int m = col.length;
        ComplexMatrix subMatrix = new ComplexMatrix(n, m);
        Complex[][] sarray = subMatrix.getArrayReference();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                sarray[i][j] = Complex.copy(this.matrix[row[i]][col[j]]);
            }
        }
        return subMatrix;
    }

    public int[] getIndexReference() {
        return this.index;
    }

    public int[] getIndexPointer() {
        return this.index;
    }

    public int[] getIndexCopy() {
        int[] indcopy = new int[this.nrow];
        for (int i = 0; i < this.nrow; ++i) {
            indcopy[i] = this.index[i];
        }
        return indcopy;
    }

    public double getSwap() {
        return this.dswap;
    }

    public static ComplexMatrix copy(ComplexMatrix a) {
        int i;
        if (a == null) {
            return null;
        }
        int nr = a.getNrow();
        int nc = a.getNcol();
        Complex[][] aarray = a.getArrayReference();
        ComplexMatrix b = new ComplexMatrix(nr, nc);
        b.nrow = nr;
        b.ncol = nc;
        Complex[][] barray = b.getArrayReference();
        for (i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                barray[i][j] = Complex.copy(aarray[i][j]);
            }
        }
        for (i = 0; i < nr; ++i) {
            b.index[i] = a.index[i];
        }
        return b;
    }

    public ComplexMatrix copy() {
        int i;
        if (this == null) {
            return null;
        }
        int nr = this.nrow;
        int nc = this.ncol;
        ComplexMatrix b = new ComplexMatrix(nr, nc);
        Complex[][] barray = b.getArrayReference();
        b.nrow = nr;
        b.ncol = nc;
        for (i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                barray[i][j] = Complex.copy(this.matrix[i][j]);
            }
        }
        for (i = 0; i < nr; ++i) {
            b.index[i] = this.index[i];
        }
        return b;
    }

    public Object clone() {
        int i;
        if (this == null) {
            return null;
        }
        int nr = this.nrow;
        int nc = this.ncol;
        ComplexMatrix b = new ComplexMatrix(nr, nc);
        Complex[][] barray = b.getArrayReference();
        b.nrow = nr;
        b.ncol = nc;
        for (i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                barray[i][j] = Complex.copy(this.matrix[i][j]);
            }
        }
        for (i = 0; i < nr; ++i) {
            b.index[i] = this.index[i];
        }
        return b;
    }

    public ComplexMatrix plus(ComplexMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.nrow;
        int nc = bmat.ncol;
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j].plus(bmat.matrix[i][j]);
            }
        }
        return cmat;
    }

    public ComplexMatrix plus(Complex[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j].plus(bmat[i][j]);
            }
        }
        return cmat;
    }

    public ComplexMatrix plus(Matrix bmat) {
        int nr = bmat.getNrow();
        int nc = bmat.getNcol();
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j].plus(bmat.getElement(i, j));
            }
        }
        return cmat;
    }

    public ComplexMatrix plus(double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j].plus(bmat[i][j]);
            }
        }
        return cmat;
    }

    public static ComplexMatrix plus(ComplexMatrix amat, ComplexMatrix bmat) {
        if (amat.nrow != bmat.nrow || amat.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = amat.nrow;
        int nc = amat.ncol;
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = amat.matrix[i][j].plus(bmat.matrix[i][j]);
            }
        }
        return cmat;
    }

    public void plusEquals(ComplexMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.nrow;
        int nc = bmat.ncol;
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                this.matrix[i][j].plusEquals(bmat.matrix[i][j]);
            }
        }
    }

    public ComplexMatrix minus(ComplexMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = this.nrow;
        int nc = this.ncol;
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j].minus(bmat.matrix[i][j]);
            }
        }
        return cmat;
    }

    public ComplexMatrix minus(Complex[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j].minus(bmat[i][j]);
            }
        }
        return cmat;
    }

    public ComplexMatrix minus(Matrix bmat) {
        int nr = bmat.getNrow();
        int nc = bmat.getNcol();
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j].minus(bmat.getElement(i, j));
            }
        }
        return cmat;
    }

    public ComplexMatrix minus(double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j].minus(bmat[i][j]);
            }
        }
        return cmat;
    }

    public static ComplexMatrix minus(ComplexMatrix amat, ComplexMatrix bmat) {
        if (amat.nrow != bmat.nrow || amat.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = amat.nrow;
        int nc = amat.ncol;
        ComplexMatrix cmat = new ComplexMatrix(nr, nc);
        Complex[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = amat.matrix[i][j].minus(bmat.matrix[i][j]);
            }
        }
        return cmat;
    }

    public void minusEquals(ComplexMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.nrow;
        int nc = bmat.ncol;
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                this.matrix[i][j].minusEquals(bmat.matrix[i][j]);
            }
        }
    }

    public ComplexMatrix times(ComplexMatrix bmat) {
        if (this.ncol != bmat.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix cmat = new ComplexMatrix(this.nrow, bmat.ncol);
        Complex[][] carray = cmat.getArrayReference();
        Complex sum = new Complex();
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < bmat.ncol; ++j) {
                sum = Complex.zero();
                for (int k = 0; k < this.ncol; ++k) {
                    sum.plusEquals(this.matrix[i][k].times(bmat.matrix[k][j]));
                }
                carray[i][j] = Complex.copy(sum);
            }
        }
        return cmat;
    }

    public ComplexMatrix times(Complex[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.ncol != nr) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix cmat = new ComplexMatrix(this.nrow, nc);
        Complex[][] carray = cmat.getArrayReference();
        Complex sum = new Complex();
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < nc; ++j) {
                sum = Complex.zero();
                for (int k = 0; k < this.ncol; ++k) {
                    sum.plusEquals(this.matrix[i][k].times(bmat[k][j]));
                }
                carray[i][j] = Complex.copy(sum);
            }
        }
        return cmat;
    }

    public ComplexMatrix times(Matrix bmat) {
        int nr = bmat.getNrow();
        int nc = bmat.getNcol();
        if (this.ncol != nr) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix cmat = new ComplexMatrix(this.nrow, nc);
        Complex[][] carray = cmat.getArrayReference();
        Complex sum = new Complex();
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < nc; ++j) {
                sum = Complex.zero();
                for (int k = 0; k < this.ncol; ++k) {
                    sum.plusEquals(this.matrix[i][k].times(bmat.getElement(k, j)));
                }
                carray[i][j] = Complex.copy(sum);
            }
        }
        return cmat;
    }

    public ComplexMatrix times(double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.ncol != nr) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix cmat = new ComplexMatrix(this.nrow, nc);
        Complex[][] carray = cmat.getArrayReference();
        Complex sum = new Complex();
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < nc; ++j) {
                sum = Complex.zero();
                for (int k = 0; k < this.ncol; ++k) {
                    sum.plusEquals(this.matrix[i][k].times(bmat[k][j]));
                }
                carray[i][j] = Complex.copy(sum);
            }
        }
        return cmat;
    }

    public ComplexMatrix times(Complex constant) {
        ComplexMatrix cmat = new ComplexMatrix(this.nrow, this.ncol);
        Complex[][] carray = cmat.getArrayReference();
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                carray[i][j] = this.matrix[i][j].times(constant);
            }
        }
        return cmat;
    }

    public ComplexMatrix times(double constant) {
        ComplexMatrix cmat = new ComplexMatrix(this.nrow, this.ncol);
        Complex[][] carray = cmat.getArrayReference();
        Complex cconstant = new Complex(constant, 0.0);
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                carray[i][j] = this.matrix[i][j].times(cconstant);
            }
        }
        return cmat;
    }

    public static ComplexMatrix times(ComplexMatrix amat, ComplexMatrix bmat) {
        if (amat.ncol != bmat.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix cmat = new ComplexMatrix(amat.nrow, bmat.ncol);
        Complex[][] carray = cmat.getArrayReference();
        Complex sum = new Complex();
        for (int i = 0; i < amat.nrow; ++i) {
            for (int j = 0; j < bmat.ncol; ++j) {
                sum = Complex.zero();
                for (int k = 0; k < amat.ncol; ++k) {
                    sum.plusEquals(amat.matrix[i][k].times(bmat.matrix[k][j]));
                }
                carray[i][j] = Complex.copy(sum);
            }
        }
        return cmat;
    }

    public static ComplexMatrix times(ComplexMatrix amat, Complex constant) {
        ComplexMatrix cmat = new ComplexMatrix(amat.nrow, amat.ncol);
        Complex[][] carray = cmat.getArrayReference();
        for (int i = 0; i < amat.nrow; ++i) {
            for (int j = 0; j < amat.ncol; ++j) {
                carray[i][j] = amat.matrix[i][j].times(constant);
            }
        }
        return cmat;
    }

    public static ComplexMatrix times(ComplexMatrix amat, double constant) {
        ComplexMatrix cmat = new ComplexMatrix(amat.nrow, amat.ncol);
        Complex[][] carray = cmat.getArrayReference();
        Complex cconstant = new Complex(constant, 0.0);
        for (int i = 0; i < amat.nrow; ++i) {
            for (int j = 0; j < amat.ncol; ++j) {
                carray[i][j] = amat.matrix[i][j].times(cconstant);
            }
        }
        return cmat;
    }

    public void timesEquals(ComplexMatrix bmat) {
        int j;
        int i;
        if (this.ncol != bmat.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix cmat = new ComplexMatrix(this.nrow, bmat.ncol);
        Complex[][] carray = cmat.getArrayReference();
        Complex sum = new Complex();
        for (i = 0; i < this.nrow; ++i) {
            for (j = 0; j < bmat.ncol; ++j) {
                sum = Complex.zero();
                for (int k = 0; k < this.ncol; ++k) {
                    sum.plusEquals(this.matrix[i][k].times(bmat.matrix[k][j]));
                }
                carray[i][j] = Complex.copy(sum);
            }
        }
        this.nrow = cmat.nrow;
        this.ncol = cmat.ncol;
        for (i = 0; i < this.nrow; ++i) {
            for (j = 0; j < this.ncol; ++j) {
                this.matrix[i][j] = cmat.matrix[i][j];
            }
        }
    }

    public void timesEquals(Complex constant) {
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                this.matrix[i][j].timesEquals(constant);
            }
        }
    }

    public void timesEquals(double constant) {
        Complex cconstant = new Complex(constant, 0.0);
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                this.matrix[i][j].timesEquals(cconstant);
            }
        }
    }

    public ComplexMatrix over(ComplexMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        return this.times(bmat.inverse());
    }

    public ComplexMatrix over(Complex[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.nrow != nr || this.ncol != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(bmat);
        return this.times(cmat.inverse());
    }

    public ComplexMatrix over(Matrix bmat) {
        ComplexMatrix pmat = ComplexMatrix.toComplexMatrix(bmat);
        return this.over(pmat);
    }

    public ComplexMatrix over(double[][] bmat) {
        ComplexMatrix pmat = ComplexMatrix.toComplexMatrix(bmat);
        return this.over(pmat);
    }

    public ComplexMatrix over(ComplexMatrix amat, ComplexMatrix bmat) {
        if (amat.nrow != bmat.nrow || amat.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        return amat.times(bmat.inverse());
    }

    public void overEquals(ComplexMatrix bmat) {
        if (this.nrow != bmat.nrow || this.ncol != bmat.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix cmat = new ComplexMatrix(bmat);
        this.timesEquals(cmat.inverse());
    }

    public ComplexMatrix inverse() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        ComplexMatrix invmat = new ComplexMatrix(n, n);
        if (n == 1) {
            Complex[][] hold = this.getArrayCopy();
            if (hold[0][0].isZero()) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            hold[0][0] = Complex.plusOne().over(hold[0][0]);
            invmat = new ComplexMatrix(hold);
        } else if (n == 2) {
            Complex[][] hold = this.getArrayCopy();
            Complex det = hold[0][0].times(hold[1][1]).minus(hold[0][1].times(hold[1][0]));
            if (det.isZero()) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            Complex[][] hold2 = Complex.twoDarray(2, 2);
            hold2[0][0] = hold[1][1].over(det);
            hold2[1][1] = hold[0][0].over(det);
            hold2[1][0] = hold[1][0].negate().over(det);
            hold2[0][1] = hold[0][1].negate().over(det);
            invmat = new ComplexMatrix(hold2);
        } else {
            Complex[] col = new Complex[n];
            Complex[] xvec = new Complex[n];
            Complex[][] invarray = invmat.getArrayReference();
            ComplexMatrix ludmat = this.luDecomp();
            for (int j = 0; j < n; ++j) {
                int i;
                for (i = 0; i < n; ++i) {
                    col[i] = Complex.zero();
                }
                col[j] = Complex.plusOne();
                xvec = ludmat.luBackSub(col);
                for (i = 0; i < n; ++i) {
                    invarray[i][j] = Complex.copy(xvec[i]);
                }
            }
        }
        return invmat;
    }

    public static ComplexMatrix inverse(ComplexMatrix amat) {
        int n = amat.nrow;
        if (n != amat.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        ComplexMatrix invmat = new ComplexMatrix(n, n);
        if (n == 1) {
            Complex[][] hold = amat.getArrayCopy();
            if (hold[0][0].isZero()) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            hold[0][0] = Complex.plusOne().over(hold[0][0]);
            invmat = new ComplexMatrix(hold);
        } else if (n == 2) {
            Complex[][] hold = amat.getArrayCopy();
            Complex det = hold[0][0].times(hold[1][1]).minus(hold[0][1].times(hold[1][0]));
            if (det.isZero()) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            Complex[][] hold2 = Complex.twoDarray(2, 2);
            hold2[0][0] = hold[1][1].over(det);
            hold2[1][1] = hold[0][0].over(det);
            hold2[1][0] = hold[1][0].negate().over(det);
            hold2[0][1] = hold[0][1].negate().over(det);
            invmat = new ComplexMatrix(hold2);
        } else {
            Complex[] col = new Complex[n];
            Complex[] xvec = new Complex[n];
            Complex[][] invarray = invmat.getArrayReference();
            ComplexMatrix ludmat = amat.luDecomp();
            for (int j = 0; j < n; ++j) {
                int i;
                for (i = 0; i < n; ++i) {
                    col[i] = Complex.zero();
                }
                col[j] = Complex.plusOne();
                xvec = ludmat.luBackSub(col);
                for (i = 0; i < n; ++i) {
                    invarray[i][j] = Complex.copy(xvec[i]);
                }
            }
        }
        return invmat;
    }

    public ComplexMatrix transpose() {
        ComplexMatrix tmat = new ComplexMatrix(this.ncol, this.nrow);
        Complex[][] tarray = tmat.getArrayReference();
        for (int i = 0; i < this.ncol; ++i) {
            for (int j = 0; j < this.nrow; ++j) {
                tarray[i][j] = Complex.copy(this.matrix[j][i]);
            }
        }
        return tmat;
    }

    public static ComplexMatrix transpose(ComplexMatrix amat) {
        ComplexMatrix tmat = new ComplexMatrix(amat.ncol, amat.nrow);
        Complex[][] tarray = tmat.getArrayReference();
        for (int i = 0; i < amat.ncol; ++i) {
            for (int j = 0; j < amat.nrow; ++j) {
                tarray[i][j] = Complex.copy(amat.matrix[j][i]);
            }
        }
        return tmat;
    }

    public ComplexMatrix conjugate() {
        ComplexMatrix conj = ComplexMatrix.copy(this);
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                conj.matrix[i][j] = this.matrix[i][j].conjugate();
            }
        }
        return conj;
    }

    public static ComplexMatrix conjugate(ComplexMatrix amat) {
        ComplexMatrix conj = ComplexMatrix.copy(amat);
        for (int i = 0; i < amat.nrow; ++i) {
            for (int j = 0; j < amat.ncol; ++j) {
                conj.matrix[i][j] = amat.matrix[i][j].conjugate();
            }
        }
        return conj;
    }

    public ComplexMatrix adjoin() {
        ComplexMatrix adj = ComplexMatrix.copy(this);
        adj = adj.transpose();
        adj = adj.conjugate();
        return adj;
    }

    public ComplexMatrix adjoin(ComplexMatrix amat) {
        ComplexMatrix adj = ComplexMatrix.copy(amat);
        adj = adj.transpose();
        adj = adj.conjugate();
        return adj;
    }

    public ComplexMatrix opposite() {
        ComplexMatrix opp = ComplexMatrix.copy(this);
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                opp.matrix[i][j] = this.matrix[i][j].times(Complex.minusOne());
            }
        }
        return opp;
    }

    public static ComplexMatrix opposite(ComplexMatrix amat) {
        ComplexMatrix opp = ComplexMatrix.copy(amat);
        for (int i = 0; i < amat.nrow; ++i) {
            for (int j = 0; j < amat.ncol; ++j) {
                opp.matrix[i][j] = amat.matrix[i][j].times(Complex.minusOne());
            }
        }
        return opp;
    }

    public Complex trace() {
        Complex trac = new Complex(0.0, 0.0);
        for (int i = 0; i < Math.min(this.ncol, this.ncol); ++i) {
            trac.plusEquals(this.matrix[i][i]);
        }
        return trac;
    }

    public static Complex trace(ComplexMatrix amat) {
        Complex trac = new Complex(0.0, 0.0);
        for (int i = 0; i < Math.min(amat.ncol, amat.ncol); ++i) {
            trac.plusEquals(amat.matrix[i][i]);
        }
        return trac;
    }

    public Complex determinant() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Complex det = new Complex();
        ComplexMatrix ludmat = this.luDecomp();
        det.reset(ludmat.dswap, 0.0);
        for (int j = 0; j < n; ++j) {
            det.timesEquals(ludmat.matrix[j][j]);
        }
        return det;
    }

    public static Complex determinant(ComplexMatrix amat) {
        int n = amat.nrow;
        if (n != amat.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Complex det = new Complex();
        ComplexMatrix ludmat = amat.luDecomp();
        det.reset(ludmat.dswap, 0.0);
        for (int j = 0; j < n; ++j) {
            det.timesEquals(ludmat.matrix[j][j]);
        }
        return det;
    }

    public Complex logDeterminant() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Complex det = new Complex();
        ComplexMatrix ludmat = this.luDecomp();
        det.reset(ludmat.dswap, 0.0);
        det = Complex.log(det);
        for (int j = 0; j < n; ++j) {
            det.plusEquals(Complex.log(ludmat.matrix[j][j]));
        }
        return det;
    }

    public static Complex logDeterminant(ComplexMatrix amat) {
        int n = amat.nrow;
        if (n != amat.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Complex det = new Complex();
        ComplexMatrix ludmat = amat.luDecomp();
        det.reset(ludmat.dswap, 0.0);
        det = Complex.log(det);
        for (int j = 0; j < n; ++j) {
            det.plusEquals(Complex.log(ludmat.matrix[j][j]));
        }
        return det;
    }

    public ComplexMatrix cofactor() {
        Complex[][] cof = Complex.twoDarray(this.nrow, this.ncol);
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                cof[i][j] = this.cofactor(i, j);
            }
        }
        return new ComplexMatrix(cof);
    }

    public Complex cofactor(int ii, int jj) {
        int i;
        if (ii < 0 || ii >= this.nrow) {
            throw new IllegalArgumentException("The entered row index, " + ii + " must lie between 0 and " + (this.nrow - 1) + " inclusive");
        }
        if (jj < 0 || jj >= this.ncol) {
            throw new IllegalArgumentException("The entered column index, " + jj + " must lie between 0 and " + (this.ncol - 1) + " inclusive");
        }
        int[] rowi = new int[this.nrow - 1];
        int[] colj = new int[this.ncol - 1];
        int kk = 0;
        for (i = 0; i < this.nrow; ++i) {
            if (i == ii) continue;
            rowi[kk] = i;
            ++kk;
        }
        kk = 0;
        for (i = 0; i < this.ncol; ++i) {
            if (i == jj) continue;
            colj[kk] = i;
            ++kk;
        }
        ComplexMatrix aa = this.getSubMatrix(rowi, colj);
        Complex aadet = aa.determinant();
        return aadet.times(Math.pow(-1.0, ii + jj));
    }

    public ComplexMatrix reducedRowEchelonForm() {
        Complex[][] mat = Complex.twoDarray(this.nrow, this.ncol);
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                mat[i][j] = this.matrix[i][j];
            }
        }
        int leadingCoeff = 0;
        int rowPointer = 0;
        boolean testOuter = true;
        while (testOuter) {
            int counter = rowPointer;
            boolean testInner = true;
            while (testInner && mat[counter][leadingCoeff].equals(Complex.zero())) {
                if (++counter != this.nrow) continue;
                counter = rowPointer;
                if (++leadingCoeff != this.ncol) continue;
                testInner = false;
            }
            if (testInner) {
                Complex[] temp = mat[rowPointer];
                mat[rowPointer] = mat[counter];
                mat[counter] = temp;
                Complex pivot = mat[rowPointer][leadingCoeff];
                for (int j = 0; j < this.ncol; ++j) {
                    mat[rowPointer][j] = mat[rowPointer][j].over(pivot);
                }
                for (int i = 0; i < this.nrow; ++i) {
                    if (i == rowPointer) continue;
                    pivot = mat[i][leadingCoeff];
                    for (int j = 0; j < this.ncol; ++j) {
                        mat[i][j] = mat[i][j].minus(pivot.times(mat[rowPointer][j]));
                    }
                }
                if (++leadingCoeff >= this.ncol) {
                    testOuter = false;
                }
            }
            if (++rowPointer < this.nrow && testInner) continue;
            testOuter = false;
        }
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                if (mat[i][j].getReal() == -0.0) {
                    mat[i][j].reset(0.0, mat[i][j].getImag());
                }
                if (mat[i][j].getImag() != -0.0) continue;
                mat[i][j].reset(mat[i][j].getReal(), 0.0);
            }
        }
        return new ComplexMatrix(mat);
    }

    public double frobeniusNorm() {
        double norm = 0.0;
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                norm = Fmath.hypot(norm, Complex.abs(this.matrix[i][j]));
            }
        }
        return norm;
    }

    public double oneNorm() {
        double norm = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.nrow; ++i) {
            sum = 0.0;
            for (int j = 0; j < this.ncol; ++j) {
                sum += Complex.abs(this.matrix[i][j]);
            }
            norm = Math.max(norm, sum);
        }
        return norm;
    }

    public double infinityNorm() {
        double norm = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.nrow; ++i) {
            sum = 0.0;
            for (int j = 0; j < this.ncol; ++j) {
                sum += Complex.abs(this.matrix[i][j]);
            }
            norm = Math.max(norm, sum);
        }
        return norm;
    }

    public ComplexMatrix luDecomp() {
        if (this.nrow != this.ncol) {
            throw new IllegalArgumentException("A matrix is not square");
        }
        int n = this.nrow;
        int imax = 0;
        double dum = 0.0;
        double temp = 0.0;
        double big = 0.0;
        double[] vv = new double[n];
        Complex sum = new Complex();
        Complex dumm = new Complex();
        ComplexMatrix ludmat = ComplexMatrix.copy(this);
        Complex[][] ludarray = ludmat.getArrayReference();
        ludmat.dswap = 1.0;
        for (int i = 0; i < n; ++i) {
            big = 0.0;
            for (int j = 0; j < n; ++j) {
                double d;
                temp = Complex.abs(ludarray[i][j]);
                if (!(d > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                throw new ArithmeticException("Singular matrix");
            }
            vv[i] = 1.0 / big;
        }
        for (int j = 0; j < n; ++j) {
            int k;
            int i;
            for (i = 0; i < j; ++i) {
                sum = Complex.copy(ludarray[i][j]);
                for (k = 0; k < i; ++k) {
                    sum.minusEquals(ludarray[i][k].times(ludarray[k][j]));
                }
                ludarray[i][j] = Complex.copy(sum);
            }
            big = 0.0;
            for (i = j; i < n; ++i) {
                double d;
                sum = Complex.copy(ludarray[i][j]);
                for (k = 0; k < j; ++k) {
                    sum.minusEquals(ludarray[i][k].times(ludarray[k][j]));
                }
                ludarray[i][j] = Complex.copy(sum);
                dum = vv[i] * Complex.abs(sum);
                if (!(d >= big)) continue;
                big = dum;
                imax = i;
            }
            if (j != imax) {
                for (int k2 = 0; k2 < n; ++k2) {
                    dumm = Complex.copy(ludarray[imax][k2]);
                    ludarray[imax][k2] = Complex.copy(ludarray[j][k2]);
                    ludarray[j][k2] = Complex.copy(dumm);
                }
                ludmat.dswap = -ludmat.dswap;
                vv[imax] = vv[j];
            }
            ludmat.index[j] = imax;
            if (ludarray[j][j].isZero()) {
                ludarray[j][j].reset(1.0E-30, 1.0E-30);
            }
            if (j == n - 1) continue;
            dumm = Complex.over(1.0, ludarray[j][j]);
            for (i = j + 1; i < n; ++i) {
                ludarray[i][j].timesEquals(dumm);
            }
        }
        return ludmat;
    }

    public Complex[] luBackSub(Complex[] bvec) {
        int j;
        int i;
        int ii = 0;
        int ip = 0;
        int n = bvec.length;
        if (n != this.ncol) {
            throw new IllegalArgumentException("vector length is not equal to matrix dimension");
        }
        if (this.ncol != this.nrow) {
            throw new IllegalArgumentException("matrix is not square");
        }
        Complex sum = new Complex();
        Complex[] xvec = new Complex[n];
        for (i = 0; i < n; ++i) {
            xvec[i] = Complex.copy(bvec[i]);
        }
        for (i = 0; i < n; ++i) {
            ip = this.index[i];
            sum = Complex.copy(xvec[ip]);
            xvec[ip] = Complex.copy(xvec[i]);
            if (ii == 0) {
                for (j = ii; j <= i - 1; ++j) {
                    sum.minusEquals(this.matrix[i][j].times(xvec[j]));
                }
            } else if (sum.isZero()) {
                ii = i;
            }
            xvec[i] = Complex.copy(sum);
        }
        for (i = n - 1; i >= 0; --i) {
            sum = Complex.copy(xvec[i]);
            for (j = i + 1; j < n; ++j) {
                sum.minusEquals(this.matrix[i][j].times(xvec[j]));
            }
            xvec[i] = sum.over(this.matrix[i][i]);
        }
        return xvec;
    }

    public Complex[] solveLinearSet(Complex[] bvec) {
        ComplexMatrix ludmat = this.luDecomp();
        return ludmat.luBackSub(bvec);
    }
}

