/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.util;

import ca.mcgill.mcb.pcingola.fastq.Fastq;
import ca.mcgill.mcb.pcingola.fastq.FastqVariant;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Random;

public class GprSeq {
    public static final char FASTQ_SANGER_ZERO = '!';
    public static final char[] BASES = new char[]{'A', 'C', 'G', 'T'};
    public static final char[] AMINO_ACIDS = new char[]{'A', 'R', 'N', 'D', 'C', 'E', 'Q', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V'};
    public static final String[] KNOWN_FILE_EXTENSIONS = new String[]{".fa", ".fasta", ".fq", ".fastq", ".sai", ".sam", ".bam", ".bcf", ".vcf", "pileup", "mpileup"};

    public static String changeQuality(String qualityStr, FastqVariant fqSrc, FastqVariant fqDst) {
        int dst;
        int src;
        if (fqSrc == fqDst) {
            return qualityStr;
        }
        switch (fqSrc) {
            case FASTQ_SOLEXA: 
            case FASTQ_ILLUMINA: {
                src = 64;
                break;
            }
            case FASTQ_SANGER: {
                src = 33;
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented fastq variant '" + (Object)((Object)fqSrc) + "'");
            }
        }
        switch (fqDst) {
            case FASTQ_SOLEXA: 
            case FASTQ_ILLUMINA: {
                dst = 64;
                break;
            }
            case FASTQ_SANGER: {
                dst = 33;
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented fastq variant '" + (Object)((Object)fqDst) + "'");
            }
        }
        int diff = dst - src;
        if (diff == 0) {
            return qualityStr;
        }
        char[] oldQ = qualityStr.toCharArray();
        char[] newQ = new char[oldQ.length];
        for (int i = 0; i < oldQ.length; ++i) {
            int q = oldQ[i] - src;
            if (q < -5) {
                throw new RuntimeException("Invalid quality char '" + oldQ[i] + "' (quality = " + q + "). This doesn't look like a valid '" + (Object)((Object)fqSrc) + "' format");
            }
            newQ[i] = (char)(Math.max(0, q) + dst);
        }
        return new String(newQ);
    }

    public static String fastaSimpleRead(String fastaFile) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader inFile = Gpr.reader(fastaFile);
            if (inFile == null) {
                return "";
            }
            String line = inFile.readLine();
            while (inFile.ready()) {
                line = inFile.readLine().trim();
                sb.append(line);
            }
            inFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    public static String fastqId(Fastq fastq) {
        return GprSeq.readId(fastq.getDescription().substring(1));
    }

    public static boolean isAmbiguous(String sequence) {
        char[] seq = sequence.toLowerCase().toCharArray();
        for (int i = 0; i < seq.length; ++i) {
            char c = seq[i];
            if (c == 'a' || c == 'c' || c == 'g' || c == 't') continue;
            return true;
        }
        return false;
    }

    public static char randBase(Random random) {
        switch (random.nextInt(4)) {
            case 0: {
                return 'A';
            }
            case 1: {
                return 'C';
            }
            case 2: {
                return 'G';
            }
            case 3: {
                return 'T';
            }
        }
        throw new RuntimeException("This should never happen!");
    }

    public static String randSequence(Random random, int len) {
        char[] bases = new char[len];
        for (int i = 0; i < len; ++i) {
            bases[i] = GprSeq.randBase(random);
        }
        return new String(bases);
    }

    public static String readId(String line) {
        String id = line.split("\\s")[0];
        if (id.endsWith("/1")) {
            return id.substring(0, id.length() - 2);
        }
        if (id.endsWith("/2")) {
            return id.substring(0, id.length() - 2);
        }
        return id;
    }

    public static String removeExt(String fileName) {
        return Gpr.removeExt(fileName, KNOWN_FILE_EXTENSIONS);
    }

    public static String reverse(String seq) {
        char[] bases;
        char[] reverse = new char[seq.length()];
        int i = reverse.length - 1;
        for (char base : bases = seq.toCharArray()) {
            reverse[i--] = base;
        }
        return new String(reverse);
    }

    public static String reverseWc(String seq) {
        char[] bases;
        char[] rwc = new char[seq.length()];
        int i = rwc.length - 1;
        for (char base : bases = seq.toCharArray()) {
            rwc[i--] = GprSeq.wc(base);
        }
        return new String(rwc);
    }

    public static String string2fasta(String name, String sequence) {
        StringBuffer sb = new StringBuffer();
        sb.append(">" + name + "\n");
        int lineLen = 80;
        for (int i = 0; i < sequence.length(); i += lineLen) {
            int max = Math.min(i + lineLen, sequence.length());
            sb.append(sequence.substring(i, max) + "\n");
        }
        return sb.toString();
    }

    public static char wc(char base) {
        switch (base) {
            case 'A': 
            case 'a': {
                return 'T';
            }
            case 'C': 
            case 'c': {
                return 'G';
            }
            case 'G': 
            case 'g': {
                return 'C';
            }
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                return 'A';
            }
            case 'N': 
            case 'n': {
                return 'N';
            }
        }
        return base;
    }

    public static String wc(String seq) {
        char[] rwc = new char[seq.length()];
        char[] bases = seq.toCharArray();
        for (int i = 0; i < bases.length; ++i) {
            rwc[i] = GprSeq.wc(bases[i]);
        }
        return new String(rwc);
    }
}

