/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine.eff;

import ca.mcgill.mcb.pcingola.akka.vcfStr.WorkerVcfStr;
import ca.mcgill.mcb.pcingola.filter.SeqChangeFilter;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalForest;
import ca.mcgill.mcb.pcingola.outputFormatter.OutputFormatter;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;

public class WorkerEff
extends WorkerVcfStr {
    SnpEffCmdEff snpEffCmdEff;
    SnpEffectPredictor snpEffectPredictor;
    OutputFormatter outputFormatter;
    IntervalForest filterIntervals;
    SeqChangeFilter seqChangeFilter;

    public WorkerEff(SnpEffCmdEff snpEffCmdEff, SnpEffectPredictor snpEffectPredictor, OutputFormatter outputFormatter, IntervalForest filterIntervals, SeqChangeFilter seqChangeFilter) {
        this.snpEffCmdEff = snpEffCmdEff;
        this.snpEffectPredictor = snpEffectPredictor;
        this.outputFormatter = outputFormatter;
        this.filterIntervals = filterIntervals;
        this.seqChangeFilter = seqChangeFilter;
    }

    @Override
    public String calculate(VcfEntry vcfEntry) {
        if (vcfEntry == null) {
            return null;
        }
        try {
            vcfEntry.parse();
            if (this.filterIntervals != null && this.filterIntervals.query(vcfEntry).isEmpty()) {
                return null;
            }
            this.outputFormatter.startSection(vcfEntry);
            for (SeqChange seqChange : vcfEntry.seqChanges()) {
                if (this.seqChangeFilter != null && !this.seqChangeFilter.filter(seqChange)) continue;
                List<ChangeEffect> changeEffects = this.snpEffectPredictor.seqChangeEffect(seqChange);
                this.outputFormatter.startSection(seqChange);
                for (ChangeEffect changeEffect : changeEffects) {
                    this.outputFormatter.add(changeEffect);
                }
                this.outputFormatter.endSection(seqChange);
            }
            this.outputFormatter.endSection(vcfEntry);
        }
        catch (Throwable t) {
            this.snpEffCmdEff.error(t, "Error while processing VCF entry (line " + vcfEntry.getLineNum() + ") :\n\t" + vcfEntry);
            t.printStackTrace();
        }
        return vcfEntry.toString();
    }
}

