/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.sideeffect;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import com.tinkerpop.pipes.util.structures.Pair;
import java.util.HashMap;
import java.util.Map;

public class GroupCountFunctionPipe<S, K>
extends AbstractPipe<S, S>
implements SideEffectPipe<S, Map<K, Number>> {
    private Map<K, Number> countMap;
    private final PipeFunction<Pair<S, Number>, Number> valueFunction;
    private final PipeFunction<S, K> keyFunction;

    public GroupCountFunctionPipe(Map<K, Number> countMap, PipeFunction<S, K> keyFunction, PipeFunction<Pair<S, Number>, Number> valueFunction) {
        this.countMap = countMap;
        this.valueFunction = valueFunction;
        this.keyFunction = keyFunction;
    }

    public GroupCountFunctionPipe(PipeFunction<S, K> keyFunction, PipeFunction<Pair<S, Number>, Number> valueFunction) {
        this(new HashMap(), keyFunction, valueFunction);
    }

    @Override
    protected S processNextStart() {
        Object s = this.starts.next();
        K key = this.getKey(s);
        this.countMap.put(key, this.getValue(s, key));
        return (S)s;
    }

    @Override
    public Map<K, Number> getSideEffect() {
        return this.countMap;
    }

    @Override
    public void reset() {
        try {
            this.countMap = (Map)this.countMap.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        super.reset();
    }

    private K getKey(S start) {
        if (null == this.keyFunction) {
            return (K)start;
        }
        return this.keyFunction.compute(start);
    }

    private Number getValue(S start, K key) {
        Number number = this.countMap.get(key);
        if (null == number) {
            number = 0L;
        }
        if (null == this.valueFunction) {
            return 1L + number.longValue();
        }
        return this.valueFunction.compute(new Pair<S, Number>(start, number));
    }
}

