/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics.genbank;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.symbol.Location;
import org.biojavax.CrossRef;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RankedCrossRef;
import org.biojavax.RichAnnotation;
import org.biojavax.SimpleNamespace;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;

public class Genbank2JSONPipe
extends AbstractPipe<String, String> {
    private String fileType = "DNA";
    private boolean mIsFileGzip = false;
    private List<String> queue = new ArrayList<String>();
    private String[] presets = new String[15];
    private RichSequenceIterator mRichSeqIter = null;
    private String currentFile = null;
    private BufferedReader reader;

    public Genbank2JSONPipe() {
        this.initPresets();
    }

    public Genbank2JSONPipe(String fileType) {
        this.fileType = fileType;
        this.initPresets();
    }

    public Genbank2JSONPipe(String fileType, String[] featureTypes) {
        this.fileType = fileType;
        this.presets = featureTypes;
    }

    public Genbank2JSONPipe(String[] featureTypes) {
        this.presets = featureTypes;
    }

    private void initPresets() {
        this.presets[0] = "gene";
        this.presets[1] = "misc_feature";
        this.presets[2] = "CDS";
        this.presets[3] = "STS";
        this.presets[4] = "repeat_region";
        this.presets[5] = "exon";
        this.presets[6] = "ncRNA";
        this.presets[7] = "rRNA";
        this.presets[8] = "rep_origin";
        this.presets[9] = "source";
        this.presets[10] = "tRNA";
        this.presets[11] = "tmRNA";
        this.presets[12] = "misc_RNA";
        this.presets[13] = "Protein";
        this.presets[14] = "Site";
    }

    public Genbank2JSONPipe(boolean isGzipFile) {
        this.mIsFileGzip = isGzipFile;
        this.initPresets();
    }

    protected String processNextStart() throws NoSuchElementException {
        try {
            if (!this.queueHasNext()) {
                RichSequence rs = this.nextRichSequence();
                String landmark = this.getLandmark(rs);
                this.queue = this.extractFeaturesByPreset(rs, landmark);
                return this.queue.remove(0);
            }
            return this.queue.remove(0);
        }
        catch (Exception e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    public boolean queueHasNext() {
        return this.queue.size() > 0;
    }

    private BufferedReader openFile(String filename) throws Exception {
        BufferedReader reader = this.mIsFileGzip ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filename)))) : new BufferedReader(new FileReader(filename));
        return reader;
    }

    public RichSequence getRichSequenceFromFilename(String filename) throws Exception {
        BufferedReader reader = this.openFile(filename);
        this.currentFile = filename;
        RichSequenceIterator mRichSeqIter = this.getRichSequenceIterator(reader, filename, this.fileType);
        if (mRichSeqIter == null) {
            throw new Exception("BioJava Can Not Parse this file! RichSequenceIterator is null!");
        }
        if (mRichSeqIter.hasNext()) {
            try {
                RichSequence rs = mRichSeqIter.nextRichSequence();
                reader.close();
                return rs;
            }
            catch (BioException ex) {
                reader.close();
                throw new NoSuchElementException(ex.getMessage());
            }
        }
        reader.close();
        throw new Exception("BioJava Can Not Find Parse-able text in this file! " + filename + " hasNext() failed!");
    }

    public RichSequence nextRichSequence() throws Exception {
        if (this.mRichSeqIter != null && !this.mRichSeqIter.hasNext()) {
            this.mRichSeqIter = null;
        }
        if (this.mRichSeqIter == null) {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.setCurrentFile();
            this.reader = this.openFile(this.currentFile);
            this.mRichSeqIter = this.getRichSequenceIterator(this.reader, this.currentFile, this.fileType);
        }
        RichSequence rs = this.mRichSeqIter.nextRichSequence();
        return rs;
    }

    private void setCurrentFile() {
        if (this.currentFile == null || this.reader == null) {
            if (this.starts.hasNext()) {
                this.currentFile = (String)this.starts.next();
            } else {
                throw new NoSuchElementException();
            }
        }
    }

    public RichSequenceIterator getRichSequenceIterator(BufferedReader reader, String filename, String fileType) {
        SimpleNamespace namespace = new SimpleNamespace("biojava");
        if (fileType.startsWith("DNA") || fileType.startsWith("dna")) {
            return RichSequence.IOTools.readGenbankDNA((BufferedReader)reader, (Namespace)namespace);
        }
        if (fileType.toLowerCase().startsWith("protein")) {
            return RichSequence.IOTools.readGenbankProtein((BufferedReader)reader, (Namespace)namespace);
        }
        return null;
    }

    public String getLandmark(RichSequence rs) {
        String id = rs.toString();
        if ((id = id.replaceAll("biojava:", "")).contains("/")) {
            String[] tokens = id.split("/");
            id = tokens[0];
        }
        return id;
    }

    public List<String> extractFeaturesByPreset(RichSequence rs, String landmark) {
        ArrayList<String> allFeatures = new ArrayList<String>();
        for (String type : this.presets) {
            List<String> jsonfeatures = this.extractFeaturesByType(type, rs, landmark);
            allFeatures.addAll(jsonfeatures);
        }
        return allFeatures;
    }

    public List<String> extractFeaturesByType(String type, RichSequence rs, String landmark) {
        ArrayList<String> features = new ArrayList<String>();
        FeatureFilter.ByType ff = new FeatureFilter.ByType(type);
        FeatureHolder fh = rs.filter((FeatureFilter)ff);
        Iterator i = fh.features();
        while (i.hasNext()) {
            RichFeature rf = (RichFeature)i.next();
            JsonObject f = new JsonObject();
            f.addProperty(CoreAttributes._type.toString(), type);
            f.addProperty(CoreAttributes._landmark.toString(), landmark);
            char featureStrand = rf.getStrand().getToken();
            if (featureStrand == '+') {
                f.addProperty(CoreAttributes._strand.toString(), "+");
            } else if (featureStrand == '-') {
                f.addProperty(CoreAttributes._strand.toString(), "-");
            } else {
                f.addProperty(CoreAttributes._strand.toString(), ".");
            }
            String subregionType = "subregions";
            JsonArray subregions = new JsonArray();
            if (type.equalsIgnoreCase("mRNA") || type.equalsIgnoreCase("transcript") || type.equalsIgnoreCase("CDS")) {
                subregionType = "exons";
            }
            String featureLocation = rf.getLocation().toString();
            f.addProperty(CoreAttributes._minBP.toString(), (Number)rf.getLocation().getMin());
            f.addProperty(CoreAttributes._maxBP.toString(), (Number)rf.getLocation().getMax());
            Location location = rf.getLocation();
            Iterator blockIterator = location.blockIterator();
            while (blockIterator.hasNext()) {
                JsonObject sregion = new JsonObject();
                Location next = (Location)blockIterator.next();
                int min = next.getMin();
                int max = next.getMax();
                sregion.addProperty("minBP", (Number)min);
                sregion.addProperty("maxBP", (Number)max);
                subregions.add((JsonElement)sregion);
            }
            if (subregions.size() > 1) {
                f.add(subregionType, (JsonElement)subregions);
            } else if (type.equalsIgnoreCase("mRNA") || type.equalsIgnoreCase("transcript") || type.equalsIgnoreCase("CDS")) {
                f.add(subregionType, (JsonElement)subregions);
            }
            RichAnnotation ra = (RichAnnotation)rf.getAnnotation();
            for (Note note : ra.getNoteSet()) {
                f.addProperty(note.getTerm().toString().replace("biojavax:", ""), note.getValue().toString());
            }
            Set rankedCrossRefs = rf.getRankedCrossRefs();
            for (RankedCrossRef next : rankedCrossRefs) {
                CrossRef crossRef = next.getCrossRef();
                f.addProperty(crossRef.getDbname(), crossRef.getAccession());
            }
            features.add(f.toString());
        }
        return features;
    }
}

