/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.functions;

import org.biojava.bio.BioError;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.GeneticAlgorithm;
import org.biojavax.ga.Organism;
import org.biojavax.ga.Population;
import org.biojavax.ga.functions.FitnessFunction;

public interface SelectionFunction {
    public static final SelectionFunction DEFAULT = new SelectAll();

    public Population select(Population var1, GeneticAlgorithm var2) throws ChangeVetoException;

    public static final class SelectAll
    implements SelectionFunction {
        public Population select(Population pop, GeneticAlgorithm genAlg) {
            return pop;
        }

        public FitnessFunction getFitnessFunction() {
            throw new UnsupportedOperationException("No FitnessFunction defined for SelectAll SelectionFunction");
        }

        public void setFitnessFunction(FitnessFunction func) throws ChangeVetoException {
            throw new ChangeVetoException("Cannot set the FitnessFunction of SelectAll SelectionFunction");
        }
    }

    public static final class Threshold
    implements SelectionFunction {
        private double cutoff;

        public Threshold(double cutoff) {
            this.cutoff = cutoff;
        }

        public double getCutoff() {
            return this.cutoff;
        }

        public Population select(Population pop, GeneticAlgorithm genAlg) {
            for (Organism o : pop.getOrganisms()) {
                try {
                    double[] fitness = o.getFitness();
                    boolean remove = false;
                    for (int j = 0; j < fitness.length && !remove; ++j) {
                        if (!(fitness[j] < this.cutoff)) continue;
                        remove = true;
                    }
                    if (!remove) continue;
                    pop.removeOrganism(o);
                }
                catch (ChangeVetoException ex) {
                    throw new BioError("population has been locked, cannot select individuals", ex);
                }
            }
            return pop;
        }
    }
}

