/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.homol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.alignment.Alignment;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;

public interface SimilarityPairFeature
extends StrandedFeature {
    public static final ChangeType SIBLING = new ChangeType("Sibling has altered", SimilarityPairFeature.class, "SIBLING");
    public static final String QUERY_LABEL = "query";
    public static final String SUBJECT_LABEL = "subject";
    public static final Alignment EMPTY_PAIRWISE = new EmptyPairwiseAlignment();

    public SimilarityPairFeature getSibling();

    public void setSibling(SimilarityPairFeature var1) throws ChangeVetoException;

    public Alignment getAlignment();

    public double getScore();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EmptyPairwiseAlignment
    extends Unchangeable
    implements Alignment {
        private List<String> labels = new ArrayList<String>(2);

        EmptyPairwiseAlignment() {
            this.labels.add(SimilarityPairFeature.QUERY_LABEL);
            this.labels.add(SimilarityPairFeature.SUBJECT_LABEL);
        }

        @Override
        public List<String> getLabels() {
            return this.labels;
        }

        @Override
        public Symbol symbolAt(String label, int index) throws NoSuchElementException {
            throw new NoSuchElementException("Attempted to retrieve symbol from empty list at " + label + ":" + index);
        }

        @Override
        public SymbolList symbolListForLabel(String label) throws NoSuchElementException {
            return SymbolList.EMPTY_LIST;
        }

        @Override
        public Alignment subAlignment(Set<String> labels, Location loc) throws NoSuchElementException {
            throw new NoSuchElementException("Attempted to retrieve sub-alignment from empty list at " + labels + ":" + loc);
        }

        @Override
        public int length() {
            return 0;
        }

        public Iterator iterator() {
            return Collections.EMPTY_LIST.iterator();
        }

        @Override
        public SymbolList subList(int index1, int index2) throws IndexOutOfBoundsException {
            Collections.EMPTY_LIST.subList(index1 - 1, index2);
            return SymbolList.EMPTY_LIST;
        }

        @Override
        public Symbol symbolAt(int index) throws IndexOutOfBoundsException {
            throw new IndexOutOfBoundsException("Attempted to retrieve symbol from empty list at " + index);
        }

        @Override
        public Alphabet getAlphabet() {
            return Alphabet.EMPTY_ALPHABET;
        }

        public List toList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public String seqString() {
            return "";
        }

        @Override
        public String subStr(int index1, int index2) throws IndexOutOfBoundsException {
            throw new IndexOutOfBoundsException("You can not retrieve part of an empty symbol list");
        }

        @Override
        public void edit(Edit edit) throws IndexOutOfBoundsException, IllegalAlphabetException, ChangeVetoException {
            throw new ChangeVetoException("You can't edit the empty symbol list");
        }

        @Override
        public Iterator<SymbolList> symbolListIterator() {
            return new Alignment.SymbolListIterator(this);
        }
    }

    public static class Template
    extends StrandedFeature.Template {
        public SimilarityPairFeature sibling;
        public Alignment alignment;
        public double score;
    }
}

