/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.integration.junit4;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jmock.Mockery;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.JUnit4ClassRunner;
import org.junit.internal.runners.TestMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMock
extends JUnit4ClassRunner {
    private Field mockeryField;

    public JMock(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.mockeryField = JMock.findMockeryField(testClass);
        this.mockeryField.setAccessible(true);
    }

    protected TestMethod wrapMethod(Method method) {
        return new TestMethod(method, this.getTestClass()){

            public void invoke(Object testFixture) throws IllegalAccessException, InvocationTargetException {
                try {
                    super.invoke(testFixture);
                    JMock.this.assertMockeryIsSatisfied(testFixture);
                }
                catch (InvocationTargetException e) {
                    Throwable actual = e.getTargetException();
                    Class expectedType = this.getExpectedException();
                    if (expectedType != null && expectedType.isInstance(actual)) {
                        JMock.this.assertMockeryIsSatisfied(testFixture);
                    }
                    throw e;
                }
            }
        };
    }

    private void assertMockeryIsSatisfied(Object testFixture) {
        this.mockeryOf(testFixture).assertIsSatisfied();
    }

    protected Mockery mockeryOf(Object test) {
        try {
            Mockery mockery = (Mockery)this.mockeryField.get(test);
            if (mockery == null) {
                throw new IllegalStateException("Mockery named '" + this.mockeryField.getName() + "' is null");
            }
            return mockery;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("cannot get value of field " + this.mockeryField.getName(), e);
        }
    }

    static Field findMockeryField(Class<?> testClass) throws InitializationError {
        for (Class<?> c = testClass; c != Object.class; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!Mockery.class.isAssignableFrom(field.getType())) continue;
                return field;
            }
        }
        throw new InitializationError("no Mockery found in test class " + testClass);
    }
}

