/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.biorAPI.resources;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.exec.Command;
import edu.mayo.pipes.bioinformatics.sequence.Bed2SequencePipe;
import edu.mayo.pipes.bioinformatics.sequence.Fasta2Tabix;
import edu.mayo.pipes.string.ComplementPipe;
import edu.mayo.pipes.string.ReversePipe;
import edu.mayo.pipes.util.GenomicObjectUtils;
import edu.mayo.pipes.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.io.FileUtils;
import org.codehaus.jettison.json.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="bior/genome")
public class Genome {
    String buildPath = null;
    private HashMap<String, GetBases> getBasesHash = new HashMap();
    private ComplementPipe complement = new ComplementPipe();
    private ReversePipe reverse = new ReversePipe();
    private static final Map<String, String> NO_CUSTOM_ENV = Collections.emptyMap();

    public List<String> getGenomeBuilds() throws IOException {
        if (this.buildPath == null) {
            SystemProperties sysprop = new SystemProperties();
            this.buildPath = sysprop.get("genomes_path");
        }
        File f = new File(this.buildPath);
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(f.list()));
        ArrayList<String> ret = new ArrayList<String>();
        for (String listing : names) {
            if (!listing.contains("GRCh")) continue;
            ret.add(listing);
        }
        return ret;
    }

    @GET
    @Path(value="/builds")
    @Produces(value={"application/json"})
    public JSONArray getGenomeBuildsREST() throws IOException {
        return new JSONArray(this.getGenomeBuilds());
    }

    public String getReferenceSequence(String build, String chrom, String minBP, String maxBP, String strand) throws IOException, NumberFormatException {
        GetBases getBases = null;
        if (this.getBasesHash.containsKey(build)) {
            getBases = this.getBasesHash.get(build);
        } else {
            String path = this.constructPathForBuild(build);
            getBases = new GetBases(path);
            this.getBasesHash.put(build, getBases);
        }
        String chr = GenomicObjectUtils.computechr((String)chrom);
        try {
            Integer min = new Integer(minBP);
            Integer max = new Integer(maxBP);
            if (max < min) {
                String temp = maxBP;
                maxBP = minBP;
                minBP = temp;
            }
        }
        catch (Exception e) {
            throw new NumberFormatException("minBP/maxBP must be an integer!!" + minBP + ":" + maxBP);
        }
        String seq = getBases.getBasePairAtPosition(chr, minBP, maxBP);
        if (strand.equalsIgnoreCase("-")) {
            return this.reverse.reverse(this.complement.complement(seq));
        }
        return seq;
    }

    public String constructPathForBuild(String build) throws IOException {
        File f;
        if (this.buildPath == null) {
            SystemProperties sysprop = new SystemProperties();
            this.buildPath = sysprop.get("genomes_path");
        }
        if (!this.buildPath.endsWith("/")) {
            this.buildPath = this.buildPath + "/";
        }
        if (!(f = new File(this.buildPath + build)).exists()) {
            throw new IOException("no path for build: " + this.buildPath + build);
        }
        if (!f.isDirectory()) {
            throw new IOException("path is not a directory for build: " + this.buildPath + build);
        }
        File versionDir = new File(this.buildPath + build);
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(versionDir.list()));
        for (String file : names) {
            if (!file.endsWith(".tsv.bgz")) continue;
            return this.buildPath + build + "/" + file;
        }
        throw new IOException("genome file not found: " + this.buildPath + build);
    }

    public void buildIndexedGenome(String inputDir, String build) throws IOException, InterruptedException {
        Fasta2Tabix f2t = new Fasta2Tabix();
        if (this.buildPath == null) {
            SystemProperties sysprop = new SystemProperties();
            this.buildPath = sysprop.get("genomes_path");
        }
        if (!this.buildPath.endsWith("/")) {
            this.buildPath = this.buildPath + "/";
        }
        FileUtils.deleteDirectory((File)new File(this.buildPath + build));
        String out = this.buildPath + build + "/hs_ref_" + build + ".fa.tsv";
        File outF = new File(this.buildPath + build);
        outF.mkdirs();
        f2t.processDir(inputDir, build, out);
        System.out.println("Compressing please wait....");
        SystemProperties sysprop = new SystemProperties();
        String[] zipcommand = new String[]{sysprop.get("bgzip_path"), out};
        Command bgzip = new Command(zipcommand, NO_CUSTOM_ENV, true);
        bgzip.execute();
        System.out.println(bgzip.getStdout());
        System.err.println(bgzip.getStderr());
        System.out.println("deleting raw output file: " + out);
        File fout = new File(out);
        if (fout.exists()) {
            fout.delete();
        }
        System.out.println("Changing the name of: " + out + ".gz" + " to " + out + ".bgz");
        File fzipped = new File(out + ".gz");
        File newfile = new File(out + ".bgz");
        if (!fzipped.renameTo(newfile)) {
            throw new IOException("File rename failed! " + out);
        }
        String[] tabixcommand = new String[]{sysprop.get("tabix_path"), "-s", "1", "-b", "2", "-e", "3", out + ".bgz"};
        Command tabix = new Command(tabixcommand, NO_CUSTOM_ENV, true);
        tabix.execute();
    }

    public void usage() {
        System.out.println("Usage: Genome <rawDataDir> <GenomeBuild>");
        System.out.println("e.g. Genome /data5/bsi/refdata-new/ncbi_genome/human/downloaded/latest/2014_02_04/Assembled_chromosomes/seq GRCh37.p13");
    }

    public static void main(String[] args) throws Exception {
        Genome g = new Genome();
        if (args.length < 2) {
            g.usage();
            System.exit(1);
        }
        String downloadDir = args[0];
        String build = args[1];
        if (downloadDir.length() < 2 || build.length() < 2) {
            g.usage();
        } else {
            System.out.println("ReferenceFileDirectory: " + downloadDir);
            System.out.println("GenomeBuild: " + build);
            g.buildIndexedGenome(downloadDir, build);
        }
        System.out.println("Finished!");
    }

    public class GetBases {
        private String GenomePath;
        Pipe pipeline = null;
        Bed2SequencePipe bed2sequencePipe = null;

        public GetBases(String genomePath) {
            this.GenomePath = genomePath;
        }

        public String getBasePairAtPosition(String landmark, String minBP, String maxBP) {
            ArrayList<String> in = new ArrayList<String>();
            in.add(landmark);
            in.add(minBP);
            in.add(maxBP);
            String result = "";
            try {
                if (this.bed2sequencePipe == null) {
                    this.bed2sequencePipe = new Bed2SequencePipe(this.GenomePath);
                    this.pipeline = new Pipeline(new Pipe[]{this.bed2sequencePipe});
                }
                this.bed2sequencePipe.reset();
                this.pipeline.reset();
                this.pipeline.setStarts(Arrays.asList(in));
                ArrayList out = (ArrayList)this.pipeline.next();
                result = (String)out.get(3);
            }
            catch (Exception e) {
                result = "";
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
            return result;
        }
    }
}

