/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalogvalidator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.catalogvalidator.CatalogColumn;
import edu.mayo.bior.catalogvalidator.CatalogColumnsMap;
import edu.mayo.bior.catalogvalidator.CatalogTabixEntry;
import edu.mayo.bior.catalogvalidator.FileUtils;
import edu.mayo.bior.catalogvalidator.GoldenJsonVariant;
import edu.mayo.bior.catalogvalidator.WholeCatalogValidationThread;
import edu.mayo.pipes.JSON.lookup.LookupPipe;
import edu.mayo.pipes.JSON.tabix.TabixReader;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CatalogValidatorUtils {
    private boolean logBoth = true;
    private TreeMap<String, Integer> uniqueMessageMap = null;
    private final Pattern DNA_NUCLEOTIDES = Pattern.compile("^[ACGTN]{1,}+$");
    private final List<String> VALID_CHR = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "X", "Y", "M");
    private final String NL = "\n";
    private final String TAB = "\t";

    public CatalogValidatorUtils(TreeMap<String, Integer> logMessageMap) {
        this.uniqueMessageMap = logMessageMap;
    }

    private CatalogValidatorUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CatalogTabixEntry readCatalogRow(String lineInCatalog) {
        if (lineInCatalog == null) {
            return null;
        }
        String[] lnElems = lineInCatalog.split("\t");
        CatalogTabixEntry tabixRowEntry = null;
        if (lnElems.length == 4) {
            if (lnElems[0] != null && lnElems[0].length() > 0 && lnElems[1] != null && lnElems[1].length() > 0 && lnElems[2] != null && lnElems[2].length() > 0 && lnElems[3] != null && lnElems[3].length() > 0 && lnElems[3].startsWith("{") && lnElems[3].endsWith("}")) {
                try {
                    return new CatalogTabixEntry(lnElems[0], lnElems[1], lnElems[2], lnElems[3], lineInCatalog.trim());
                }
                catch (NumberFormatException nf) {
                    String err = "readCatalogRow(): Catalog format unexpected: number of tab-separated columns is 4 but some of fields not valid to create CatalogTabixEntry object. line: " + lineInCatalog;
                    this.logMessage(err);
                    return null;
                }
            }
            String err = "readCatalogRow(): Catalog format unexpected: number of tab-separated columns is 4 but some of fields are empty or not json. line: " + lineInCatalog;
            this.logMessage(err);
            return null;
        }
        if (lnElems.length == 1) {
            if (lnElems[0] == null) return tabixRowEntry;
            if (!lnElems[0].startsWith("{")) return tabixRowEntry;
            if (!lnElems[0].endsWith("}")) return tabixRowEntry;
            return new CatalogTabixEntry((String)null, (Integer)null, (Integer)null, lnElems[0], lineInCatalog.trim());
        }
        String err = "readCatalogRow(): Catalog format unexpected: number of tab-separated columns is not 4 or 1. line: " + lineInCatalog;
        this.logMessage(err);
        return null;
    }

    protected GoldenJsonVariant getGoldenJsonVariant(JsonObject catalogRowJson) {
        GoldenJsonVariant variant = new GoldenJsonVariant();
        try {
            JsonArray jsonAltAlleles;
            variant.setChr(catalogRowJson.get("_landmark").getAsString());
            variant.setMinBP(this.getJsonPrimitive(catalogRowJson, "_minBP").getAsInt());
            variant.setMaxBP(this.getJsonPrimitive(catalogRowJson, "_maxBP").getAsInt());
            JsonPrimitive goldenRefAllele = this.getJsonPrimitive(catalogRowJson, "_refAllele");
            if (goldenRefAllele != null) {
                variant.setRefAllele(goldenRefAllele.getAsString());
                JsonPrimitive strandPrim = this.getJsonPrimitive(catalogRowJson, "_strand");
                if (strandPrim != null) {
                    variant.setStrand(strandPrim.getAsString());
                }
            }
            if ((jsonAltAlleles = catalogRowJson.getAsJsonArray("_altAlleles")) != null) {
                Iterator iterator = jsonAltAlleles.iterator();
                while (iterator.hasNext()) {
                    String eachAltAllele = ((JsonElement)iterator.next()).getAsString();
                    variant.addAltAllele(eachAltAllele);
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return variant;
    }

    protected JsonObject getJsonObject(String jsonAsString) {
        JsonParser jp = new JsonParser();
        JsonElement catalogRowJsonElem = null;
        JsonObject catalogRowJsonObj = null;
        catalogRowJsonElem = jp.parse(jsonAsString);
        catalogRowJsonObj = catalogRowJsonElem.getAsJsonObject();
        return catalogRowJsonObj;
    }

    protected JsonPrimitive getJsonPrimitive(JsonObject jsonObj, String jsonKey) {
        JsonElement jsonElem = jsonObj.get(jsonKey);
        if (jsonElem == null || !jsonElem.isJsonPrimitive()) {
            return null;
        }
        return jsonElem.getAsJsonPrimitive();
    }

    private Object getJsonValueForJsonKey(JsonObject jsonObj, String keyOfValueToRetrieve, String parentJsonKey) {
        Object currentJsonObj = null;
        for (Map.Entry thisEntry : jsonObj.entrySet()) {
            String strVal;
            String jsonKey = (String)thisEntry.getKey();
            if (!jsonKey.equals(keyOfValueToRetrieve) && !jsonKey.contains(keyOfValueToRetrieve)) continue;
            JsonElement jsonElem = (JsonElement)thisEntry.getValue();
            if (jsonElem.isJsonNull()) {
                System.err.println("getJavaObjectForJsonID(): Value for json key [" + jsonKey + "] is empty." + "\n");
                break;
            }
            if (jsonElem.isJsonObject()) {
                JsonObject embeddedJsonObj = jsonElem.getAsJsonObject();
                currentJsonObj = this.getJsonValueForJsonKey(embeddedJsonObj, keyOfValueToRetrieve, jsonKey);
                continue;
            }
            if (jsonElem.isJsonArray()) {
                JsonArray jsonArrVal;
                currentJsonObj = jsonArrVal = jsonElem.getAsJsonArray();
                break;
            }
            if (!jsonElem.isJsonPrimitive()) break;
            JsonPrimitive jsonPrimVal = jsonElem.getAsJsonPrimitive();
            if (jsonPrimVal.isBoolean()) {
                Boolean boolVal = jsonPrimVal.getAsBoolean();
                currentJsonObj = boolVal;
                break;
            }
            if (jsonPrimVal.isNumber()) {
                currentJsonObj = this.jsonNumberToJavaNumber(jsonPrimVal);
                break;
            }
            if (!jsonPrimVal.isString() || (strVal = jsonPrimVal.getAsString()) == null) break;
            currentJsonObj = strVal;
            break;
        }
        return currentJsonObj;
    }

    private Object getJsonValueForCatalogColumn(String columnName, JsonObject jsonObj, CatalogColumn catalogCol) throws Exception {
        String[] columnNameElems = null;
        if (!columnName.contains(".")) {
            columnNameElems = new String[]{columnName};
        } else {
            columnNameElems = columnName.split("\\.");
            if (columnNameElems.length < 1) {
                String msg = "Bad column name format. Less than one element: " + columnName;
                throw new Exception(msg);
            }
        }
        try {
            Object currentJsonObj = jsonObj;
            Iterator<String> columnNameElemItr = Arrays.asList(columnNameElems).iterator();
            while (columnNameElemItr.hasNext()) {
                String colElem = columnNameElemItr.next();
                JsonElement jsonElem = null;
                if (currentJsonObj instanceof JsonObject) {
                    JsonObject currentJson = currentJsonObj;
                    jsonElem = currentJson.get(colElem);
                }
                if (jsonElem == null) {
                    return null;
                }
                if (jsonElem.isJsonObject()) {
                    JsonObject embeddedJsonObj = jsonElem.getAsJsonObject();
                    if (embeddedJsonObj == null) {
                        this.logMessage("ERROR: getJsonForCatalogColumn(): Embedded json object retrieval was null for column name [" + columnName + "] and column name element[" + colElem + "]." + "\n");
                        return null;
                    }
                    if (!columnNameElemItr.hasNext()) {
                        return embeddedJsonObj;
                    }
                    String nextColNameElement = columnNameElemItr.next();
                    Object foundObj = this.getJsonValueForCatalogColumn(nextColNameElement, embeddedJsonObj, catalogCol);
                    currentJsonObj = foundObj;
                } else if (jsonElem.isJsonArray()) {
                    JsonArray jsonArr = jsonElem.getAsJsonArray();
                    currentJsonObj = jsonArr;
                    catalogCol.setMaximumNumElementsInColumn(jsonArr.size());
                } else if (jsonElem.isJsonPrimitive()) {
                    JsonPrimitive jsonPrim = jsonElem.getAsJsonPrimitive();
                    if (jsonPrim.isJsonNull()) {
                        currentJsonObj = jsonPrim;
                    } else if (jsonPrim.isBoolean()) {
                        currentJsonObj = jsonPrim.getAsBoolean();
                    } else if (jsonPrim.isNumber()) {
                        String numStr = jsonPrim.getAsString();
                        currentJsonObj = !this.isValidInteger(numStr, catalogCol.getDataType()) ? (Number)jsonPrim.getAsDouble() : (Number)jsonPrim.getAsInt();
                    } else if (jsonPrim.isString()) {
                        currentJsonObj = jsonPrim.getAsString();
                        String strVal = (String)currentJsonObj;
                        if (!this.isQuotedString(strVal)) {
                            this.logMessage("ERROR: getJsonForCatalogColumn(): Invalid JSON formatting: json string value [" + strVal + "] is not quoted." + "\n");
                        }
                    } else {
                        if (jsonPrim.isJsonObject()) {
                            throw new RuntimeException("ERROR: getJsonForCatalogColumn(): column element name: " + colElem + " WARNING: Embedded JsonObject is Json primitive but says it is a json object too. Not expecting this.");
                        }
                        if (jsonPrim.isJsonArray()) {
                            throw new RuntimeException("ERROR: getJsonForCatalogColumn(): column element name: " + colElem + " WARNING: Embedded JsonObject is Json primitive but says it is a json array too. Not expecting this.");
                        }
                    }
                }
                if (currentJsonObj != null && columnNameElemItr.hasNext()) continue;
                catalogCol.incrementNumberObservedInCatalog();
                return currentJsonObj;
            }
        }
        catch (MalformedJsonException jsonExc) {
            jsonExc.printStackTrace();
            this.logMessage("getJsonForCatalogColumn(): Exception parsing thru Json for row: Exception: " + jsonExc.getMessage() + " Column Name: " + columnName + " Json row value: " + jsonObj.toString() + "\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logMessage("getJsonForCatalogColumn(): Exception parsing thru Json for row: Exception: " + e.getMessage() + " Column Name: " + columnName + " Json row value: " + jsonObj.toString() + "\n");
        }
        return null;
    }

    protected boolean isTabixRetrievalSuccessful(TabixReader tabixRdr, CatalogTabixEntry tabixCatEntry, WholeCatalogValidationThread.TABIX_QUERY_ORDER tabixOrderToCheck) throws IOException {
        boolean successfulMatch = false;
        boolean allResultsRelavent = true;
        TabixReader.Iterator tabixItr = this.getTabixIterator(tabixRdr, tabixCatEntry);
        if (tabixItr == null) {
            successfulMatch = false;
            allResultsRelavent = false;
        } else {
            int iteratorIdxThatMatched = -1;
            int numTabixResults = 0;
            int currentIteratorIdx = 0;
            String tabixLine = null;
            while ((tabixLine = tabixItr.next()) != null) {
                ++currentIteratorIdx;
                ++numTabixResults;
                if (tabixLine.equals(tabixCatEntry.getCatalogTabixLine())) {
                    successfulMatch = true;
                    iteratorIdxThatMatched = currentIteratorIdx;
                    continue;
                }
                String[] elems = tabixLine.split("\t");
                CatalogTabixEntry qryTabixEntry = new CatalogTabixEntry(elems[0], elems[1], elems[2], elems[3], tabixLine);
                if (this.withinRange(qryTabixEntry.getMinPosition(), tabixCatEntry.getMinPosition(), tabixCatEntry.getMaxPosition()) || this.withinRange(qryTabixEntry.getMaxPosition(), tabixCatEntry.getMinPosition(), tabixCatEntry.getMaxPosition())) continue;
                allResultsRelavent = false;
            }
            if (!(successfulMatch && tabixOrderToCheck.name().equals(WholeCatalogValidationThread.TABIX_QUERY_ORDER.FIRST_ELEM_IN_RESULT.name()) && iteratorIdxThatMatched == 1 || successfulMatch && tabixOrderToCheck.name().equals(WholeCatalogValidationThread.TABIX_QUERY_ORDER.LAST_ELEM_IN_RESULT.name()) && iteratorIdxThatMatched == numTabixResults)) {
                successfulMatch = false;
            }
        }
        return successfulMatch && allResultsRelavent;
    }

    protected boolean isBiorIndexRetrievalSuccessful(File catalogFile, File biorIndexFile, String indexedColumnName, CatalogTabixEntry sourceTabix) throws Exception {
        JsonParser jp = new JsonParser();
        JsonElement catalogRowJsonElem = jp.parse(sourceTabix.getJsonString());
        JsonObject catalogRowJsonObj = catalogRowJsonElem.getAsJsonObject();
        catalogRowJsonElem = catalogRowJsonObj.get(indexedColumnName);
        Object valueForIndexedKey = this.getJsonValueForJsonKey(catalogRowJsonObj, indexedColumnName, null);
        if (valueForIndexedKey == null) {
            this.logMessage("WARNING: in method: isBiorIndexRetrievalSuccessful(): value for indexed key [" + indexedColumnName + "] is null for catalog json: " + sourceTabix.getJsonString());
            return false;
        }
        String catalog = catalogFile.getCanonicalPath();
        String index = biorIndexFile.getCanonicalPath();
        Metadata md = new Metadata(catalog, "bior_lookup");
        Pipeline p = new Pipeline(new Pipe[]{new HistoryInPipe(md), new LookupPipe(catalog, index), new HistoryOutPipe()});
        p.setStarts(Arrays.asList(valueForIndexedKey.toString()));
        ArrayList<String> matches = new ArrayList<String>();
        int i = 0;
        while (p.hasNext()) {
            String out = (String)p.next();
            String[] elems = out.split("\t");
            if (!out.startsWith("#") && elems.length == 2) {
                String out_indexedColumnValue = elems[0];
                if (valueForIndexedKey.toString().equals(out_indexedColumnValue)) {
                    String out_jsonOutput = elems[1];
                    if (sourceTabix.getJsonString().equals(out_jsonOutput)) {
                        matches.add(out);
                    }
                }
            }
            ++i;
        }
        if (matches.size() == 1) {
            return true;
        }
        if (matches.size() > 1) {
            System.err.println("WARNING: BIOR index lookup on key [" + indexedColumnName + "] value [" + valueForIndexedKey + "] produced more than one row of output. Results are: " + ((Object)matches).toString());
            return true;
        }
        return false;
    }

    private boolean isValidInteger(String intStrValue, String catalogDataType) {
        if (catalogDataType.equalsIgnoreCase("int") || catalogDataType.equalsIgnoreCase("Integer")) {
            try {
                Integer intVal = new Integer(intStrValue);
                if (intVal % 1 != 0) {
                    return false;
                }
                if (intVal >= Integer.MIN_VALUE && intVal <= Integer.MAX_VALUE) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private boolean isValidLong(String longStrValue, String catalogDataType) {
        if (catalogDataType.equalsIgnoreCase("Long")) {
            try {
                Long longVal = new Long(longStrValue);
                if (longVal % 1L != 0L) {
                    return false;
                }
                if (longVal >= Long.MIN_VALUE && longVal <= Long.MAX_VALUE) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean isEmptyJsonValue(String jsonValue) {
        String trimmedJsonVal = this.trim(jsonValue);
        return this.isEmpty(trimmedJsonVal) || trimmedJsonVal.equals(".");
    }

    public boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        String trimmedStr = this.trim(str);
        return trimmedStr.length() <= 0;
    }

    public boolean isQuotedString(String str) {
        if (str == null) {
            return false;
        }
        return !str.startsWith("\"") || !str.endsWith("\"");
    }

    public boolean isPositionalCatalog(File catalogFile) {
        int linesChecking = 50000;
        int linesRead = 0;
        boolean numJSONOnly = false;
        int numNonPositonalTabixEntries = 0;
        int numPositionalTabixEntries = 0;
        int numUnexpectedFormat = 0;
        try {
            BufferedReader catalogRdr = FileUtils.getBufferedReader(catalogFile.getCanonicalPath());
            String curCatalogRow = null;
            while (linesRead <= 50000 && (curCatalogRow = catalogRdr.readLine()) != null) {
                if (curCatalogRow.startsWith("#")) continue;
                ++linesRead;
                CatalogTabixEntry thisTabixEntry = this.readCatalogRow(curCatalogRow);
                if (thisTabixEntry.getChromosome() == null || thisTabixEntry.getChromosome().equals(".")) {
                    if (thisTabixEntry.getMinPosition() == null || thisTabixEntry.getMinPosition() != 0 || thisTabixEntry.getMaxPosition() == null || thisTabixEntry.getMaxPosition() != 0) continue;
                    ++numNonPositonalTabixEntries;
                    continue;
                }
                if (thisTabixEntry.getChromosome() != null && this.VALID_CHR.contains(thisTabixEntry.getChromosome())) {
                    if (thisTabixEntry.getMinPosition() == null || thisTabixEntry.getMinPosition() <= 0 || thisTabixEntry.getMaxPosition() == null || thisTabixEntry.getMaxPosition() <= 0) continue;
                    ++numPositionalTabixEntries;
                    continue;
                }
                ++numUnexpectedFormat;
            }
        }
        catch (Exception e) {
            this.logMessage("isPositionalCatalog(): Exception while determining whether catalog is positional: catalog: " + catalogFile.getAbsolutePath() + " Exception: " + e.getMessage());
        }
        if (numUnexpectedFormat == 0 && (numNonPositonalTabixEntries == 50000 || numNonPositonalTabixEntries == linesRead)) {
            return false;
        }
        if (numUnexpectedFormat == 0 && (numPositionalTabixEntries == 50000 || numPositionalTabixEntries == linesRead)) {
            return true;
        }
        if (numUnexpectedFormat == 0 && numPositionalTabixEntries > 5000) {
            return true;
        }
        this.logMessage("isPositionalCatalog() failed to determine whether catalog is positional. " + catalogFile.getAbsolutePath() + " linesChecked=" + 50000 + " numUnexpectedFormat=" + numUnexpectedFormat);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean traverseJsonForInvalidJson(JsonReader rdr) throws Exception {
        boolean foundAllValidJson = true;
        String currentPropName = null;
        try {
            if (rdr.isLenient()) {
                String msg = "Raising Exception in traverseJsonToCheckForInvalidJson(): Json Reader is set to lenient. Validation needs the reader set to strict checking for this method to perform checks adequately.";
                System.err.println(msg);
                rdr.close();
                throw new Exception(msg);
            }
            rdr.beginObject();
            while (rdr.hasNext()) {
                Object valueFromJson;
                currentPropName = rdr.nextName();
                if (currentPropName.contains(".")) {
                    this.logMessage("ERROR: traverseJsonForInvalidJson() period in json property name: " + currentPropName + "\n");
                    foundAllValidJson = false;
                }
                if (rdr.peek() == JsonToken.NAME || (valueFromJson = this.readNextJsonTokenValue(rdr, currentPropName)) != null) continue;
                this.logMessage("ERROR: traverseJsonForInvalidJson()/readNextJsonTokenValue() did not return a json value for json property name: " + currentPropName + "\n");
                foundAllValidJson = false;
            }
            rdr.endObject();
        }
        catch (MalformedJsonException mal) {
            System.err.println("MalformedJsonException parsing JSON property name [" + currentPropName + "].");
            foundAllValidJson = false;
        }
        catch (Exception e) {
            System.err.println("Exception parsing JSON property name [" + currentPropName + "].");
            foundAllValidJson = false;
        }
        return foundAllValidJson;
    }

    protected Object readNextJsonTokenValue(JsonReader rdr, String currentPropName) throws Exception {
        Serializable jsonValue = null;
        try {
            JsonToken jsonToken = rdr.peek();
            if (currentPropName.equals("_altAlleles") && !jsonToken.equals((Object)JsonToken.BEGIN_ARRAY)) {
                this.logMessage("WARNING: data type of _altAlleles is not an array.\n");
            }
            if (jsonToken == JsonToken.NULL) {
                this.logMessage("WARNING: value null/empty for property name: " + currentPropName + " skipping it..." + "\n");
                rdr.skipValue();
            } else if (jsonToken == JsonToken.BEGIN_ARRAY) {
                ArrayList<Object> arrayElements = new ArrayList<Object>();
                int idx = 0;
                rdr.beginArray();
                while (rdr.hasNext()) {
                    arrayElements.add(this.readNextJsonTokenValue(rdr, currentPropName + "_" + idx));
                    ++idx;
                }
                rdr.endArray();
                jsonValue = arrayElements.size() > 0 ? arrayElements : null;
            } else if (jsonToken == JsonToken.BEGIN_OBJECT) {
                boolean successfullyParsedEmbeddedObj = this.traverseJsonForInvalidJson(rdr);
                jsonValue = !successfullyParsedEmbeddedObj ? null : new Boolean(successfullyParsedEmbeddedObj);
            } else if (jsonToken == JsonToken.NUMBER) {
                String numStr = rdr.nextString();
                jsonValue = numStr.contains(".") ? (Number)new Double(numStr) : (Number)new Integer(numStr);
            } else if (jsonToken == JsonToken.STRING) {
                String s = rdr.nextString();
                jsonValue = s;
            } else if (jsonToken == JsonToken.BOOLEAN) {
                jsonValue = rdr.nextBoolean();
            }
        }
        catch (MalformedJsonException mal) {
            this.logMessage("MalformedJsonException parsing JSON property name [" + currentPropName + "]." + "\n");
        }
        catch (Exception e) {
            this.logMessage("Exception parsing JSON property name [" + currentPropName + "]." + "\n");
        }
        return jsonValue;
    }

    protected List<String> traverseJsonByColumn(JsonObject catalogRowJsonObj, CatalogColumnsMap columnInfo) throws Exception {
        ArrayList<String> columnsNotFoundInJson = new ArrayList<String>();
        String curColNmChecking = null;
        try {
            Iterator<String> i$ = columnInfo.getOrderedColumnNames().iterator();
            while (i$.hasNext()) {
                String eachCatColNm;
                curColNmChecking = eachCatColNm = i$.next();
                Object jsonObjFound = this.getJsonValueForCatalogColumn(eachCatColNm, catalogRowJsonObj, columnInfo.getColumn(eachCatColNm));
                if (jsonObjFound == null) {
                    columnsNotFoundInJson.add(eachCatColNm);
                    continue;
                }
                columnInfo.getColumn(eachCatColNm).incrementNumberObservedInCatalog();
            }
        }
        catch (MalformedJsonException jsonExc) {
            this.logMessage("ERROR: Exception parsing thru Json for Catalog Column [" + curColNmChecking + "] & Row: Exception: " + jsonExc.getMessage() + " Json row value: " + catalogRowJsonObj.getAsString() + "\n");
            return null;
        }
        catch (Exception e) {
            this.logMessage("ERROR: Exception parsing thru Json for Catalog Column [" + curColNmChecking + "] & Row: Exception: " + e.getMessage() + " Json row value: " + catalogRowJsonObj.getAsString() + "\n");
            return null;
        }
        return columnsNotFoundInJson;
    }

    protected List<String> traverseJsonByJsonKey(JsonObject catalogRowJsonObj, CatalogColumnsMap columnInfo) throws Exception {
        return this.traverseJsonByJsonKey(catalogRowJsonObj, columnInfo, null);
    }

    protected List<String> traverseJsonByJsonKey(JsonObject catalogRowJsonObj, CatalogColumnsMap columnInfo, String parentJsonKeyName) throws Exception {
        ArrayList<String> jsonObjsNotInColumnInfo = new ArrayList<String>();
        Object currentJsonObj = null;
        for (Map.Entry thisEntry : catalogRowJsonObj.entrySet()) {
            String jsonKey = (String)thisEntry.getKey();
            JsonElement jsonElem = (JsonElement)thisEntry.getValue();
            if (jsonKey.contains(".")) {
                this.logMessage("WARNING: JSON key has a period within it. Key: " + jsonKey + " Whole JSON: " + catalogRowJsonObj.toString() + "\n");
            }
            if (jsonElem.isJsonNull()) {
                this.logMessage("traverseJsonByJsonKeyset(): NO json object with key: " + jsonKey + "\n");
            } else {
                if (jsonElem.isJsonObject()) {
                    currentJsonObj = jsonElem.getAsJsonObject();
                    List<String> jsonKeysNotFoundInCols = this.traverseJsonByJsonKey(jsonElem.getAsJsonObject(), columnInfo, jsonKey);
                    if (jsonKeysNotFoundInCols == null || jsonKeysNotFoundInCols.size() <= 0) continue;
                    jsonObjsNotInColumnInfo.addAll(jsonKeysNotFoundInCols);
                    continue;
                }
                if (jsonElem.isJsonArray()) {
                    JsonArray jsonArrVal = jsonElem.getAsJsonArray();
                    currentJsonObj = jsonArrVal;
                } else if (jsonElem.isJsonPrimitive()) {
                    String strVal;
                    JsonPrimitive jsonPrimVal = jsonElem.getAsJsonPrimitive();
                    if (jsonPrimVal.isBoolean()) {
                        Boolean boolVal = jsonPrimVal.getAsBoolean();
                        currentJsonObj = boolVal;
                    } else if (jsonPrimVal.isNumber()) {
                        currentJsonObj = this.jsonNumberToJavaNumber(jsonPrimVal);
                    } else if (jsonPrimVal.isString() && (strVal = jsonPrimVal.getAsString()) != null) {
                        currentJsonObj = strVal;
                    }
                } else {
                    this.logMessage("ERROR: traverseJsonByJsonKeyset(): haven't found a json datatype for json key: " + jsonKey + "\n");
                    currentJsonObj = null;
                }
            }
            if (currentJsonObj == null) continue;
            boolean foundCatColNameForJson = false;
            String curKey = null;
            String matchedCatalogColNm = null;
            for (String definedColName : columnInfo.getOrderedColumnNames()) {
                if (parentJsonKeyName != null) {
                    curKey = parentJsonKeyName + '.' + jsonKey;
                    Pattern keyCombo = Pattern.compile(parentJsonKeyName + "\\." + jsonKey + "(\\.|$)");
                    Matcher keyComMatcher = keyCombo.matcher(definedColName);
                    if (!keyComMatcher.matches()) continue;
                    foundCatColNameForJson = true;
                    matchedCatalogColNm = definedColName;
                    break;
                }
                curKey = jsonKey;
                if (!definedColName.equals(curKey)) continue;
                foundCatColNameForJson = true;
                matchedCatalogColNm = definedColName;
                break;
            }
            if (!foundCatColNameForJson || matchedCatalogColNm == null) {
                jsonObjsNotInColumnInfo.add(curKey);
                this.logMessage("ERROR: No Catalog Column Name found for Json Object Found: JSON [" + jsonElem.toString() + "] JSON Key [" + curKey + "].");
                continue;
            }
            CatalogColumn catColumnDefinition = columnInfo.getColumn(matchedCatalogColNm);
            if (catColumnDefinition == null) {
                this.logMessage("WARNING: catalog column name [" + matchedCatalogColNm + "] not found in catalog column map. Cannot check data type.");
                continue;
            }
            if (this.dataTypesMatch(currentJsonObj, catColumnDefinition)) continue;
            String msg = "ERROR: traverseJsonByJsonKey(): data type does not match between json [" + currentJsonObj.getClass().getName() + "] and columns.tsv [" + catColumnDefinition.getDataType() + "] for matched catalog column key: " + matchedCatalogColNm + "\n";
            this.logMessage(msg);
        }
        return jsonObjsNotInColumnInfo;
    }

    protected boolean dataTypesMatch(Object jsonObj, CatalogColumn columnDefition) {
        String definedDataType = columnDefition.getDataType();
        String definedCount = columnDefition.getCount();
        if (jsonObj instanceof Boolean && definedDataType.equalsIgnoreCase("boolean")) {
            return true;
        }
        if (jsonObj instanceof Long && definedDataType.equalsIgnoreCase("long")) {
            return true;
        }
        if (jsonObj instanceof Integer && (definedDataType.equalsIgnoreCase("integer") || definedDataType.equalsIgnoreCase("int"))) {
            return true;
        }
        return jsonObj instanceof String && definedDataType.equalsIgnoreCase("string") ? definedCount.equals("1") : jsonObj instanceof JsonArray && definedDataType.equalsIgnoreCase("string") && definedCount.equals(".");
    }

    protected TabixReader.Iterator getTabixIterator(TabixReader tabixRdr, CatalogTabixEntry tabixRowEntry) {
        return this.getTabixIterator(tabixRdr, tabixRowEntry.getChromosome(), tabixRowEntry.getMinPosition(), tabixRowEntry.getMaxPosition());
    }

    protected TabixReader.Iterator getTabixIterator(TabixReader tabixRdr, String chr, Integer start, Integer stop) {
        TabixReader.Iterator chrItr = null;
        try {
            chrItr = tabixRdr.query(chr + ":" + start + "-" + stop);
        }
        catch (Throwable t) {
            System.err.println("RowLevelValidationThread.run(): WARNING: Exception while requesting tabix iterator for region [" + chr + ":" + start + "-" + stop + "].  Exception is: " + t.getMessage() + "\n");
            return null;
        }
        return chrItr;
    }

    protected String validateGoldenJsonLandmark(JsonObject catalogRowJson, boolean isPositionalCatalogEntry) throws IOException {
        String jsonGolden_landmarkStr = null;
        JsonElement goldenLandmarkElem = catalogRowJson.get("_landmark");
        if (goldenLandmarkElem == null) {
            if (isPositionalCatalogEntry) {
                this.logMessage("_landmark golden value is not in JSON String, but catalog entry is positional. row id: " + catalogRowJson.get("_id").getAsString() + "\n");
                return null;
            }
        } else {
            jsonGolden_landmarkStr = goldenLandmarkElem.getAsString();
            if (!(jsonGolden_landmarkStr.equals("X") || jsonGolden_landmarkStr.equals("Y") || jsonGolden_landmarkStr.equals("M"))) {
                Integer iLandmark = -1;
                try {
                    iLandmark = goldenLandmarkElem.getAsInt();
                    if (iLandmark < 1 || iLandmark > 22) {
                        this.logMessage("ERROR: _landmark value should be valid numeric chr value at this point [" + iLandmark + "], but is not. Json obj id: " + catalogRowJson.get("_id") + "\n");
                        return null;
                    }
                }
                catch (Exception e) {
                    this.logMessage("ERROR: _landmark value should be valid numeric chr value at this point [" + iLandmark + "], but could not create Integer object for value. Json obj id: " + catalogRowJson.get("_id") + "\n");
                    return null;
                }
            }
        }
        return jsonGolden_landmarkStr;
    }

    protected String validateGoldenJsonRefAllele(JsonObject catalogRowJson) throws Exception {
        String golden_refAllele = null;
        JsonPrimitive refAllelePrim = this.getJsonPrimitive(catalogRowJson, "_refAllele");
        if (refAllelePrim == null || !refAllelePrim.isString()) {
            this.logMessage("_refAllele golden value is not in JSON String or is not a Json Primitive String. row id: " + catalogRowJson.get("_id").getAsString() + "\n");
            return null;
        }
        golden_refAllele = refAllelePrim.getAsString();
        if (this.isEmptyJsonValue(golden_refAllele)) {
            this.logMessage("_refAllele value is emtpy; not expected in human variant catalog. row id: " + catalogRowJson.get("_id").getAsString() + "\n");
        } else {
            String jsonREF;
            if (!this.validDNANucleotides(golden_refAllele)) {
                this.logMessage("ERROR: _refAllele value [" + golden_refAllele + "] contains an invalid nucleotide value. row id: " + catalogRowJson.get("_id").getAsString() + "\n");
            }
            if (!this.isEmptyJsonValue(jsonREF = catalogRowJson.get("REF").getAsString()) && !jsonREF.equals(golden_refAllele)) {
                this.logMessage("WARNING: The _refAllele value [" + golden_refAllele + "] is not equal to the JSON REF value [" + jsonREF + "].");
            }
        }
        return golden_refAllele;
    }

    protected List<String> validateGoldenJsonAltAllele(JsonObject catalogRowJson, String goldenRefAllele) throws Exception {
        ArrayList<String> altAlleleList = new ArrayList<String>();
        if (!catalogRowJson.get("_altAlleles").isJsonArray()) {
            this.logMessage("ERROR: _altAlleles is not a JsonArray data type, but should be. Json object as string: " + catalogRowJson.get("_altAlleles").toString() + "\n");
        } else {
            JsonArray altAlleles = catalogRowJson.getAsJsonArray("_altAlleles");
            String jsonALT = catalogRowJson.get("ALT").getAsString();
            Iterator iterator = altAlleles.iterator();
            while (iterator.hasNext()) {
                String eachAltAllele = ((JsonElement)iterator.next()).getAsString();
                if (eachAltAllele.length() == 0) {
                    this.logMessage("ERROR: One of the _altAllele values [" + eachAltAllele + "] is empty value. row id: " + catalogRowJson.get("_id").getAsString() + "\n");
                    continue;
                }
                if (!this.validDNANucleotides(eachAltAllele)) {
                    this.logMessage("ERROR: One of the _altAllele values [" + eachAltAllele + "] is not valid nucleotide value. row id: " + catalogRowJson.get("_id").getAsString());
                }
                if (goldenRefAllele != null && goldenRefAllele.equals(eachAltAllele)) {
                    this.logMessage("ERROR: One of the _altAllele values is equal to the _refAllele. row id: " + catalogRowJson.get("_id").getAsString() + "\n");
                } else if (goldenRefAllele == null) {
                    this.logMessage("WARNING: Couldn't verify that the _altAllele value is not equal to the _refAllele. _refAllele is null. row id: " + catalogRowJson.get("_id").getAsString() + "\n");
                }
                if (!eachAltAllele.equals(jsonALT)) {
                    this.logMessage("WARNING: One of the _altAllele values [" + eachAltAllele + "] not equal to the JSON ALT value [" + jsonALT + "]." + "\n");
                }
                if (altAlleleList.add(eachAltAllele)) continue;
                this.logMessage("WARNING: One of the _altAllele values [" + eachAltAllele + "] is repeated multiple times. row id: " + catalogRowJson.get("_id").getAsString() + "\n");
            }
        }
        return altAlleleList;
    }

    protected String validateGoldenJsonStrand(JsonObject catalogRowJson) throws Exception {
        String strand = null;
        JsonElement strandJsonElem = catalogRowJson.get("_strand");
        if (strandJsonElem != null && strandJsonElem.isJsonPrimitive()) {
            JsonPrimitive strandPrim = strandJsonElem.getAsJsonPrimitive();
            if (!strandPrim.isString()) {
                this.logMessage("_strand golden value is not a JSON Primitive String type. row id: " + catalogRowJson.get("_id").getAsString() + "\n");
                return null;
            }
            strand = strandJsonElem.getAsString();
            if (!strand.equals("+")) {
                this.logMessage("_strand golden value is not equal to a '+'. row id: " + catalogRowJson.get("_id").getAsString() + "\n");
                return null;
            }
        } else {
            return null;
        }
        return strand;
    }

    protected Object jsonNumberToJavaNumber(JsonPrimitive jsonNumber) {
        Number correctInstanceOfJavaNumber = null;
        Number num = this.stringToJavaNumber(jsonNumber.getAsString());
        if (num instanceof Long) {
            correctInstanceOfJavaNumber = (Long)num;
        } else if (num instanceof Integer) {
            correctInstanceOfJavaNumber = (Integer)num;
        } else if (num instanceof BigDecimal) {
            correctInstanceOfJavaNumber = (BigDecimal)num;
        } else if (num instanceof Double) {
            correctInstanceOfJavaNumber = (Double)num;
        }
        return correctInstanceOfJavaNumber;
    }

    protected Number stringToJavaNumber(String value) {
        if (!value.contains(".")) {
            try {
                long longValue = Long.parseLong(value);
                if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                    return (int)longValue;
                }
                return longValue;
            }
            catch (NumberFormatException longValue) {
                // empty catch block
            }
        }
        try {
            Double valueAsADouble = Double.parseDouble(value);
            Float valueAsFloat = Float.valueOf(Float.parseFloat(value));
            if (valueAsADouble >= (double)1.4E-45f && valueAsADouble <= 3.4028234663852886E38) {
                return valueAsFloat;
            }
            return valueAsADouble;
        }
        catch (NumberFormatException nf) {
            return new BigDecimal(value);
        }
    }

    public String trim(String inputStr) {
        if (inputStr == null) {
            return null;
        }
        return inputStr.trim();
    }

    public boolean validDNANucleotides(String dnaSeq) {
        Matcher m = this.DNA_NUCLEOTIDES.matcher(dnaSeq);
        return m.find();
    }

    private boolean withinRange(int queryPosition, int minRange, int maxRange) {
        return queryPosition >= minRange && queryPosition <= maxRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logMessage(String strToLog) {
        TreeMap<String, Integer> treeMap = this.uniqueMessageMap;
        synchronized (treeMap) {
            Integer numOccurrences = this.uniqueMessageMap.get(strToLog);
            if (numOccurrences == null) {
                this.uniqueMessageMap.put(strToLog, 1);
            } else {
                this.uniqueMessageMap.put(strToLog, numOccurrences + 1);
            }
        }
        if (this.logBoth) {
            System.err.println(strToLog);
        }
    }

    protected Set<String> getLoggedMessages() {
        return this.uniqueMessageMap.keySet();
    }
}

