/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.util.validation;

import edu.mayo.cli.InvalidDataException;

public class GoldenValidator {
    public static GoldenAttributes getGoldenAttribute(String goldenJsonKey) throws InvalidDataException {
        if (goldenJsonKey.equals(GoldenAttributes._landmark.name())) {
            return GoldenAttributes._landmark;
        }
        if (goldenJsonKey.equals(GoldenAttributes._minBP.name())) {
            return GoldenAttributes._minBP;
        }
        if (goldenJsonKey.equals(GoldenAttributes._maxBP.name())) {
            return GoldenAttributes._maxBP;
        }
        if (goldenJsonKey.equals(GoldenAttributes._type.name())) {
            return GoldenAttributes._type;
        }
        if (goldenJsonKey.equals(GoldenAttributes._id.name())) {
            return GoldenAttributes._id;
        }
        if (goldenJsonKey.equals(GoldenAttributes._refAllele.name())) {
            return GoldenAttributes._refAllele;
        }
        if (goldenJsonKey.equals(GoldenAttributes._altAlleles.name())) {
            return GoldenAttributes._altAlleles;
        }
        if (goldenJsonKey.equals(GoldenAttributes._strand.name())) {
            return GoldenAttributes._strand;
        }
        return null;
    }

    public static boolean isValidGolden(String inputGoldenKey) {
        for (GoldenAttributes each : GoldenAttributes.values()) {
            if (!each.name().equals(inputGoldenKey)) continue;
            return true;
        }
        return false;
    }

    public static void validateGoldenKey(String goldenJsonKey) throws InvalidDataException {
        if (!(goldenJsonKey.equals(GoldenAttributes._landmark.name()) || goldenJsonKey.equals(GoldenAttributes._minBP.name()) || goldenJsonKey.equals(GoldenAttributes._maxBP.name()) || goldenJsonKey.equals(GoldenAttributes._type.name()) || goldenJsonKey.equals(GoldenAttributes._id.name()) || goldenJsonKey.equals(GoldenAttributes._refAllele.name()) || goldenJsonKey.equals(GoldenAttributes._altAlleles.name()) || goldenJsonKey.equals(GoldenAttributes._strand.name()))) {
            throw new InvalidDataException("Not a valid BioR golden attribute name: " + goldenJsonKey);
        }
    }

    public static void validateDataType(String goldenJsonKey, String dataType) throws InvalidDataException {
        GoldenAttributes goldenKey = GoldenValidator.getGoldenAttribute(goldenJsonKey);
        GoldenValidator.validateDataType(goldenKey, dataType);
    }

    public static void validateDataType(GoldenAttributes goldenJsonKey, String dataType) throws InvalidDataException {
        String dType = dataType.toUpperCase();
        switch (goldenJsonKey) {
            case _landmark: {
                if (dType.equals("STRING")) break;
                throw new InvalidDataException(GoldenAttributes._landmark.name() + " golden attribute must be of type String.");
            }
            case _minBP: {
                if (dType.equals("INTEGER") || dType.equals("NUMBER")) break;
                throw new InvalidDataException(GoldenAttributes._minBP.name() + " golden attribute must be of type JsonType Number or Integer.");
            }
            case _maxBP: {
                if (dType.equals("INTEGER") || dType.equals("NUMBER")) break;
                throw new InvalidDataException(GoldenAttributes._maxBP.name() + " golden attribute must be of type JsonType Number or Integer.");
            }
            case _altAlleles: {
                if (dType.equals("STRING")) break;
                throw new InvalidDataException(GoldenAttributes._altAlleles.name() + " golden attribute must be of type String.");
            }
            case _refAllele: {
                if (dType.equals("STRING")) break;
                throw new InvalidDataException(GoldenAttributes._refAllele.name() + " golden attribute must be of type String.");
            }
        }
    }

    public static enum GoldenAttributes {
        _landmark,
        _minBP,
        _maxBP,
        _type,
        _id,
        _refAllele,
        _altAlleles,
        _strand;

    }
}

