/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.util;

import edu.mayo.cli.InvalidDataException;
import edu.mayo.pipes.history.History;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ColumnResolver {
    private static final String TAB_DELIMITER = "\t";

    public static List<Integer> rangesToZeroBasedIndexes(History history, String ranges) throws Exception {
        String header = history.getMetaData().getColumnHeaderRow(history, TAB_DELIMITER);
        List<Integer> positiveCols = new ColumnResolver().getColumnsFromRanges(header, ranges);
        ArrayList<Integer> zeroBasedCols = new ArrayList<Integer>();
        for (int i = 0; i < positiveCols.size(); ++i) {
            zeroBasedCols.add(positiveCols.get(i) - 1);
        }
        return zeroBasedCols;
    }

    public static Integer nameToZeroBasedIndex(History history, String columnName) throws Exception {
        throw new Exception("Not implemented yet");
    }

    public static Integer numberToZeroBasedIndex(History history, int columnNumber_oneBased, long lineNum) {
        if (columnNumber_oneBased == 0 || columnNumber_oneBased < -history.size() || columnNumber_oneBased > history.size()) {
            throw new IndexOutOfBoundsException("Error on line " + lineNum + ".  Specified column index is beyond the range of the columns in the data row" + ".  Specified column:  " + columnNumber_oneBased + ".  Size of data row: " + history.size());
        }
        int col = columnNumber_oneBased;
        if (col < 0) {
            col = history.size() + columnNumber_oneBased;
        } else if (col > 0) {
            col = columnNumber_oneBased - 1;
        }
        return col;
    }

    protected List<Integer> getColumnsFromRanges(String header, String ranges) throws InvalidDataException {
        if (header == null || header.trim().length() == 0 || header.trim().equals("#")) {
            throw new InvalidDataException("Error: Invalid column - no header found");
        }
        if (ranges == null || ranges.trim().length() == 0) {
            return new ArrayList<Integer>();
        }
        int numColsInHeader = header.split(TAB_DELIMITER).length;
        String[] rangesArray = ranges.split(",");
        ArrayList<Integer> cols = new ArrayList<Integer>();
        for (String range : rangesArray) {
            if (range.trim().length() == 0) continue;
            cols.addAll(this.getColsFromSingleRange(range, numColsInHeader));
        }
        this.removeDuplicates(cols);
        Collections.sort(cols);
        return cols;
    }

    private void removeDuplicates(List<Integer> cols) {
        HashSet<Integer> colsHashSet = new HashSet<Integer>();
        for (int i = cols.size() - 1; i >= 0; --i) {
            if (colsHashSet.contains(cols.get(i))) {
                cols.remove(i);
                continue;
            }
            colsHashSet.add(cols.get(i));
        }
    }

    protected List<Integer> getColsFromSingleRange(String range, int numColsInHeader) throws NumberFormatException, InvalidDataException {
        ArrayList<Integer> cols = new ArrayList<Integer>();
        if (this.isInteger(range)) {
            cols.add(this.getPositiveCol(range, Integer.parseInt(range), numColsInHeader));
        } else if (range.contains("..")) {
            try {
                String[] vals = range.trim().split("\\.\\.");
                if (range.trim().startsWith("..")) {
                    vals = new String[]{"1", vals[1]};
                }
                if (range.trim().endsWith("..")) {
                    vals = new String[]{vals[0], numColsInHeader + ""};
                }
                Integer int1 = this.getPositiveCol(range, Integer.parseInt(vals[0]), numColsInHeader);
                Integer int2 = this.getPositiveCol(range, Integer.parseInt(vals[1]), numColsInHeader);
                Integer first = Math.min(int1, int2);
                Integer last = Math.max(int1, int2);
                for (int i = first.intValue(); i <= last; ++i) {
                    cols.add(i);
                }
            }
            catch (InvalidDataException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidDataException("Error: Invalid column or range [" + range + "] - range could not be parsed");
            }
        } else {
            throw new InvalidDataException("Error: Invalid column or range [" + range + "] - range could not be parsed");
        }
        return cols;
    }

    protected int getPositiveCol(String range, int colPosOrNeg, int numColsInHeader) throws InvalidDataException {
        if (colPosOrNeg > numColsInHeader) {
            throw new InvalidDataException("Error: Invalid column or range [" + range + "] - header only contains " + numColsInHeader + " columns");
        }
        if (colPosOrNeg < 0) {
            colPosOrNeg = numColsInHeader + colPosOrNeg + 1;
        }
        if (colPosOrNeg < 0) {
            throw new InvalidDataException("Error: Invalid column or range [" + range + "] - header only contains " + numColsInHeader + " columns");
        }
        if (colPosOrNeg == 0) {
            throw new InvalidDataException("Error: Invalid column or range [" + range + "] - 0 is not a valid column number.  Column numbers start at 1");
        }
        return colPosOrNeg;
    }

    protected boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

