/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.cli.cmd.MergeCommand;
import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.bior.pipeline.Variant2JSONPipe;
import edu.mayo.bior.pipes.history.MakeFirstLineHeaderPipe;
import edu.mayo.bior.util.BiorProperties;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.cli.InvalidOptionArgValueException;
import edu.mayo.pipes.JSON.lookup.LookupPipe;
import edu.mayo.pipes.JSON.lookup.lookupUtils.IndexUtils;
import edu.mayo.pipes.UNIX.CatPipe;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class Variant2JSONCommand
implements CommandPlugin {
    private static Logger sLogger = Logger.getLogger(MergeCommand.class);
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private String operation;
    private static final char kOptionInputFile = 'f';
    private static final char OPTION_INDEX_FILE = 'i';
    private static final char OPTION_CATALOG_FILE = 'd';
    private static final char OPTION_KEY = 'p';
    private static final char kOptionBuild = 'b';
    private static final String kDefaultKey = "ID";
    private static final String kDefaultCatalog = "/dbSNP/142/00-All_GRCh37.tsv.bgz";

    public void init(Properties props) throws Exception {
        this.operation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        try {
            File inputFile;
            String catalogFilePath = this.getCatalogFile(line);
            if (!new File(catalogFilePath).exists()) {
                throw new InvalidOptionArgValueException(opts.getOption("d"), catalogFilePath, "The catalog file path '" + catalogFilePath + "' does not exist. Please specify a valid catalog file path.");
            }
            String key = kDefaultKey;
            if (line.hasOption('p')) {
                key = line.getOptionValue('p');
            }
            String build = null;
            if (line.hasOption('b')) {
                build = line.getOptionValue('b');
            }
            String indexFilePath = "";
            boolean isIndexSpecified = line.hasOption('i');
            if (isIndexSpecified) {
                indexFilePath = line.getOptionValue('i');
            } else {
                try {
                    indexFilePath = IndexUtils.getH2DbIndexPath((String)catalogFilePath, (String)key);
                }
                catch (IOException ioe) {
                    throw new InvalidOptionArgValueException(opts.getOption("d"), indexFilePath, "Error locating the index file");
                }
            }
            String defaultIndexNotExistMsg = "The built-in index for " + key + " does not exist.  " + "Please e-mail the BioR development team at bior@mayo.edu to add this, " + "or create your own custom index using the bior_index command.";
            String specifiedIndexNotExistMsg = "The index file path you specified does not exist: " + indexFilePath;
            String specifiedIndexNotReadableMsg = "The index file path you specified does not have read access: " + indexFilePath + ".  Please verify file permissions.";
            File indexFile = new File(indexFilePath);
            if (!indexFile.exists()) {
                throw new InvalidOptionArgValueException(opts.getOption("i"), indexFilePath, isIndexSpecified ? specifiedIndexNotExistMsg : defaultIndexNotExistMsg, isIndexSpecified);
            }
            if (!indexFile.canRead()) {
                throw new InvalidOptionArgValueException(opts.getOption("i"), indexFilePath, specifiedIndexNotReadableMsg, isIndexSpecified);
            }
            Metadata metadata = new Metadata(this.operation);
            String inputPath = line.getOptionValue('f');
            String inputNotExistMsg = "The input file path you specified does not exist: " + inputPath;
            String inputNotReadMsg = "The input file path you specified does not have read access: " + inputPath + ".  Please verify file permissions.";
            File file = inputFile = inputPath == null ? null : new File(inputPath);
            if (inputFile != null && !inputFile.exists()) {
                throw new InvalidOptionArgValueException(opts.getOption("f"), indexFilePath, inputNotExistMsg, true);
            }
            if (inputFile != null && !indexFile.canRead()) {
                throw new InvalidOptionArgValueException(opts.getOption("f"), indexFilePath, inputNotReadMsg, true);
            }
            MakeFirstLineHeaderPipe addHeader = new MakeFirstLineHeaderPipe();
            HistoryInPipe setup = new HistoryInPipe(metadata);
            Pipeline preLogic = new Pipeline(new Pipe[]{addHeader, setup});
            LookupPipe rsISLookup = new LookupPipe(catalogFilePath, indexFilePath);
            Variant2JSONPipe logic = new Variant2JSONPipe(rsISLookup, null, build);
            HistoryOutPipe postLogic = new HistoryOutPipe();
            if (inputPath != null) {
                this.mPipeline.execute(preLogic, logic, postLogic, new CatPipe(), Arrays.asList(inputPath));
            } else {
                this.mPipeline.execute(preLogic, logic, postLogic);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
            throw e;
        }
    }

    private String getCatalogFile(CommandLine line) throws IOException {
        if (line.hasOption('d')) {
            return line.getOptionValue('d');
        }
        String catalogDir = System.getenv("BIOR_CATALOG");
        if (catalogDir == null) {
            this.logEnvironmentVariables();
            sLogger.warn((Object)"BIOR_CATALOG not passed in, and not found in the system environment variables.  Pulling it from bior.properties...");
            catalogDir = this.getCatalogDirFromBiorProps();
        }
        String catalogPath = catalogDir + kDefaultCatalog;
        sLogger.warn((Object)("BIOR_CATALOG = " + catalogPath));
        return catalogPath;
    }

    private String getCatalogDirFromBiorProps() throws IOException {
        return new BiorProperties().get(BiorProperties.Key.fileBase);
    }

    private void logEnvironmentVariables() {
        Map<String, String> env = System.getenv();
        sLogger.info((Object)"Environment variables:");
        for (Map.Entry<String, String> entry : env.entrySet()) {
            sLogger.info((Object)(entry.getKey() + ":= " + entry.getValue()));
        }
    }
}

