/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalogvalidator;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import edu.mayo.bior.catalogvalidator.CatalogColumnsMap;
import edu.mayo.bior.catalogvalidator.CatalogTabixEntry;
import edu.mayo.bior.catalogvalidator.CatalogValidator;
import edu.mayo.bior.catalogvalidator.CatalogValidatorUtils;
import edu.mayo.bior.catalogvalidator.FileUtils;
import edu.mayo.bior.catalogvalidator.GoldenJsonVariant;
import edu.mayo.pipes.JSON.tabix.TabixReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class RowLevelValidationThread
extends Thread
implements Runnable {
    private String mCatFileNm = null;
    private CatalogColumnsMap mCatalogColumnInfo = null;
    private String mChr = null;
    private int mChrSize = -1;
    private TreeMap<String, Integer> mChrSizeMap = null;
    private CatalogValidator.CAT_ATTR_VAL_TYPE mValidationType = null;
    boolean mIsPositionalCatalog = false;
    private CatalogValidatorUtils mCatalogUtil = null;
    private List<String> mCatalogColsNotFoundInSomeJsonRows = new ArrayList<String>();
    private List<String> mJsonKeysNotFoundInColumnsTsv = new ArrayList<String>();
    private RUN_MODE mRunMode = null;
    public static String NL = "\n";

    @Override
    public void run() {
        if (this.mValidationType == null) {
            throw new RuntimeException("ERROR: RowLevelValidationThread.mValidationType is not set. It must be set to run this validation.");
        }
        if (this.mValidationType != null && this.mValidationType == CatalogValidator.CAT_ATTR_VAL_TYPE.NONHUMAN_VARIANT_ATTRIBUTES) {
            throw new RuntimeException(CatalogValidator.CAT_ATTR_VAL_TYPE.NONHUMAN_VARIANT_ATTRIBUTES.name() + ": catalog type is not implemented at this time.");
        }
        if (this.mCatalogUtil == null) {
            System.out.println("RowLevelValidationThread: No catalog utilities set by caller, initializing them now...");
            this.mCatalogUtil = new CatalogValidatorUtils(new TreeMap<String, Integer>());
        }
        if (this.mRunMode.name().equals(RUN_MODE.SERIAL.name())) {
            this.runSerial();
        } else {
            this.runParallel();
        }
    }

    private void runParallel() {
        TabixReader tbxRdr = null;
        try {
            tbxRdr = new TabixReader(this.mCatFileNm);
            TabixReader.Iterator chrItr = null;
            Integer BATCH_SIZE = 5000000;
            int curStop = 0;
            String firstPosCheckedInChr = null;
            String lastPosCheckedInChr = null;
            String curTabixRow = null;
            String prevTabixRow = null;
            int numTabixRowsProcessed = 0;
            int curStart = 1;
            while (curStart <= this.mChrSize) {
                curStop = curStop + 1 + BATCH_SIZE < this.mChrSize ? curStop + BATCH_SIZE : this.mChrSize;
                chrItr = this.mCatalogUtil.getTabixIterator(tbxRdr, this.mChr, curStart, curStop);
                if (chrItr == null) {
                    this.mCatalogUtil.logMessage("RowLevelValidationThread.run(): WARNING: Couldn't get tabix iterator for region [" + this.mChr + ":" + curStart + "-" + curStop + "]" + NL);
                } else {
                    int rowsInBatch = 0;
                    String firstPosCheckedInBatch = null;
                    String lastPosCheckedInBatch = null;
                    while ((curTabixRow = chrItr.next()) != null) {
                        CatalogTabixEntry tabixRowEntry;
                        if (curTabixRow.startsWith("#")) continue;
                        ++rowsInBatch;
                        if (numTabixRowsProcessed % 100000 == 0) {
                            this.mCatalogUtil.logMessage("Completed validating [" + numTabixRowsProcessed + "] rows of catalog." + NL);
                        }
                        if ((tabixRowEntry = this.mCatalogUtil.readCatalogRow(curTabixRow)) == null) {
                            this.getCatalogUtil().logMessage("CatalogValidatorThread.runSerial(): Error occurred in runSerial(). Could not read in catalog row as valid Tabix Entry: line: " + curTabixRow + NL);
                            continue;
                        }
                        if (firstPosCheckedInBatch == null) {
                            firstPosCheckedInBatch = tabixRowEntry.getMinPosition().toString();
                        }
                        if (firstPosCheckedInChr == null) {
                            firstPosCheckedInChr = tabixRowEntry.getMinPosition().toString();
                        }
                        this.validateCatalogRow(tabixRowEntry);
                        ++numTabixRowsProcessed;
                        prevTabixRow = curTabixRow;
                    }
                    if (lastPosCheckedInBatch == null && prevTabixRow != null) {
                        String[] prevelems = prevTabixRow.split("\t");
                        lastPosCheckedInBatch = prevelems[1];
                    }
                    this.mCatalogUtil.logMessage("Tabix batch result row count for region [" + this.mChr + ":" + curStart + "-" + curStop + "]: catalog rows in batch: " + rowsInBatch + NL);
                    this.mCatalogUtil.logMessage("Tabix batch result for region [" + this.mChr + ":" + curStart + "-" + curStop + "]: First position in batch: [" + firstPosCheckedInBatch + "]: Last position in batch: [" + lastPosCheckedInBatch + "]" + NL);
                }
                curStart = curStop + 1;
            }
            if (lastPosCheckedInChr == null && prevTabixRow != null) {
                String[] prevelems = prevTabixRow.split("\t");
                lastPosCheckedInChr = prevelems[1];
            }
            this.mCatalogUtil.logMessage("Thread [" + this.getName() + "] ending. Num rows [" + numTabixRowsProcessed + "]. Chr [" + this.mChr + "] start [" + firstPosCheckedInChr + "] end [" + lastPosCheckedInChr + "]" + NL);
        }
        catch (Throwable t) {
            try {
                this.mCatalogUtil.logMessage("CatalogValidatorThread.run(): Error occurred for chromosome [" + this.mChr + "]: " + t.getMessage() + NL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            t.printStackTrace();
        }
    }

    private void runSerial() {
        BufferedReader catalogRdr = null;
        int rowsInCatalog = 0;
        try {
            catalogRdr = FileUtils.getBufferedReader(this.mCatFileNm);
            String curCatalogRow = null;
            while ((curCatalogRow = catalogRdr.readLine()) != null) {
                CatalogTabixEntry tabixRowEntry;
                if (curCatalogRow.startsWith("#")) continue;
                if (++rowsInCatalog % 100000 == 0) {
                    System.out.println("Completed validating [" + rowsInCatalog + "] rows of catalog.");
                }
                if ((tabixRowEntry = this.mCatalogUtil.readCatalogRow(curCatalogRow)) == null) {
                    this.getCatalogUtil().logMessage("CatalogValidatorThread.runSerial(): Error occurred in runSerial(). Could not read in catalog row as valid Tabix Entry: line: " + curCatalogRow + NL);
                    continue;
                }
                this.validateCatalogRow(tabixRowEntry);
            }
            this.mCatalogUtil.logMessage("Thread [" + this.getName() + "] ending. Num rows in catalog [" + rowsInCatalog + "]." + NL);
        }
        catch (Throwable t) {
            try {
                this.getCatalogUtil().logMessage("CatalogValidatorThread.run(): Error occurred in runSerial(): " + t.getMessage() + NL);
                t.printStackTrace();
            }
            catch (Exception exception) {
                // empty catch block
            }
            t.printStackTrace();
        }
    }

    private void validateCatalogRow(CatalogTabixEntry tabixCatEntry) throws Exception {
        JsonObject catalogRowJsonObj = null;
        try {
            catalogRowJsonObj = this.mCatalogUtil.getJsonObject(tabixCatEntry.getJsonString());
        }
        catch (JsonSyntaxException jse) {
            this.mCatalogUtil.logMessage("Exception: RowLevelValidationThread.run(): Exception parsing json content. json value for tabix row =" + tabixCatEntry.getJsonString() + NL);
            jse.printStackTrace();
        }
        try {
            this.validateCatalogRowTabix(tabixCatEntry, this.isPositionalCatalog());
            GoldenJsonVariant goldenVariant = this.validateGoldenJson_PositionInfo(catalogRowJsonObj, this.isPositionalCatalog());
            if (this.mValidationType == CatalogValidator.CAT_ATTR_VAL_TYPE.HUMAN_VARIANT_ATTRIBUTES) {
                goldenVariant = this.validateGoldenJson_Variant(catalogRowJsonObj, goldenVariant);
            }
            this.compareTabixToGoldenElements(tabixCatEntry, goldenVariant, this.isPositionalCatalog());
            this.validateCatalogRowJson(tabixCatEntry.getJsonString(), catalogRowJsonObj);
        }
        catch (Exception e) {
            this.mCatalogUtil.logMessage("Exception: RowLevelValidationThread.run(): Exception in detailed catalog row checking. json value for tabix row =" + tabixCatEntry.getJsonString() + NL);
            e.printStackTrace();
        }
    }

    private void validateCatalogRowJson(String catalogRowJsonStr, JsonObject catalogRowJsonObj) throws Exception {
        List<String> jsonKeysNotFoundInColInfo;
        List<String> columnsNotFoundInJson;
        JsonReader jsonRdrFromTabix = new JsonReader((Reader)new InputStreamReader(new ByteArrayInputStream(catalogRowJsonStr.getBytes("UTF-8"))));
        boolean keysAndQuotingValid = this.mCatalogUtil.traverseJsonForInvalidJson(jsonRdrFromTabix);
        jsonRdrFromTabix.close();
        if (!keysAndQuotingValid) {
            this.mCatalogUtil.logMessage("ERROR: Catalog row json has invalid elements: " + catalogRowJsonStr);
        }
        if ((columnsNotFoundInJson = this.mCatalogUtil.traverseJsonByColumn(catalogRowJsonObj, this.mCatalogColumnInfo)).size() > 0) {
            this.mCatalogColsNotFoundInSomeJsonRows.addAll(columnsNotFoundInJson);
        }
        if ((jsonKeysNotFoundInColInfo = this.mCatalogUtil.traverseJsonByJsonKey(catalogRowJsonObj, this.mCatalogColumnInfo)).size() > 0) {
            this.mJsonKeysNotFoundInColumnsTsv.addAll(jsonKeysNotFoundInColInfo);
        }
    }

    protected void validateCatalogRowTabix(CatalogTabixEntry catalogTabixEntry, boolean catalogEntryIsPositional) throws Exception {
        if (this.mValidationType == CatalogValidator.CAT_ATTR_VAL_TYPE.HUMAN_VARIANT_ATTRIBUTES || this.mValidationType == CatalogValidator.CAT_ATTR_VAL_TYPE.NONVARIANT_ATTRIBUTES && catalogEntryIsPositional) {
            this.validateTabixHumanPositionsInChrRange(catalogTabixEntry);
        } else if (this.mValidationType == CatalogValidator.CAT_ATTR_VAL_TYPE.NONVARIANT_ATTRIBUTES) {
            this.validateTabixNonPositional(catalogTabixEntry);
        }
    }

    protected GoldenJsonVariant validateGoldenJson_PositionInfo(JsonObject catalogRowJson, boolean catalogIsPositional) {
        GoldenJsonVariant variant = new GoldenJsonVariant();
        try {
            String chr = this.mCatalogUtil.validateGoldenJsonLandmark(catalogRowJson, catalogIsPositional);
            if (chr != null) {
                variant.setChr(chr);
            }
            int jsonGolden_Minbp = -1;
            JsonPrimitive minBPPrim = this.mCatalogUtil.getJsonPrimitive(catalogRowJson, "_minBP");
            if (minBPPrim == null) {
                if (this.isPositionalCatalog()) {
                    this.mCatalogUtil.logMessage("_minBP golden value is not in JSON String or is not a JsonPrimitive type, but is expected in positional catalog entry. row id: " + catalogRowJson.get("_id").getAsString() + NL);
                }
            } else if (!minBPPrim.isNumber()) {
                this.mCatalogUtil.logMessage("_minBP golden value is not in JSON Number. row id: " + catalogRowJson.get("_id").getAsString() + NL);
            } else {
                jsonGolden_Minbp = minBPPrim.getAsInt();
                variant.setMinBP(jsonGolden_Minbp);
            }
            int jsonGolden_Maxbp = -1;
            JsonPrimitive maxBPPrim = this.mCatalogUtil.getJsonPrimitive(catalogRowJson, "_maxBP");
            if (maxBPPrim == null) {
                if (this.isPositionalCatalog()) {
                    this.mCatalogUtil.logMessage("_maxBP golden value is not in JSON String or is not a JsonPrimitive type. row id: " + catalogRowJson.get("_id").getAsString() + NL);
                }
            } else if (!maxBPPrim.isNumber()) {
                this.mCatalogUtil.logMessage("_maxBP golden value is not in JSON Number. row id: " + catalogRowJson.get("_id").getAsString() + NL);
            } else {
                jsonGolden_Maxbp = maxBPPrim.getAsInt();
                variant.setMaxBP(jsonGolden_Maxbp);
            }
        }
        catch (Exception e) {
            this.mCatalogUtil.logMessage("Unable to create variant object from golden attributes. row id: " + catalogRowJson.get("_id").getAsString() + NL);
        }
        return variant;
    }

    private GoldenJsonVariant validateGoldenJson_Variant(JsonObject catalogRowJson, GoldenJsonVariant inJsonVariant) {
        GoldenJsonVariant variant = null;
        variant = inJsonVariant == null ? new GoldenJsonVariant() : inJsonVariant;
        try {
            String refAllele = this.mCatalogUtil.validateGoldenJsonRefAllele(catalogRowJson);
            if (refAllele != null && !this.mCatalogUtil.isEmptyJsonValue(refAllele)) {
                variant.setRefAllele(refAllele);
                String strand = this.mCatalogUtil.validateGoldenJsonStrand(catalogRowJson);
                variant.setStrand(strand);
            } else {
                this.mCatalogUtil.logMessage("ERROR: RefAllele not set for variant: chr: " + variant.getChr() + " position: " + variant.getMinBP());
            }
            variant.setAltAlleles(this.mCatalogUtil.validateGoldenJsonAltAllele(catalogRowJson, refAllele));
            JsonPrimitive minBPPrim = this.mCatalogUtil.getJsonPrimitive(catalogRowJson, "_minBP");
            variant.setMinBP(minBPPrim.getAsInt());
            JsonPrimitive maxBPPrim = this.mCatalogUtil.getJsonPrimitive(catalogRowJson, "_maxBP");
            variant.setMaxBP(maxBPPrim.getAsInt());
            int jsonGoldenVariantLength = variant.getMaxBP() - variant.getMinBP() + 1;
            if (refAllele != null && refAllele.length() != jsonGoldenVariantLength) {
                this.mCatalogUtil.logMessage("ERROR: _refAllele length [" + refAllele.length() + "] is not equal Json position length [" + jsonGoldenVariantLength + "]. row id: " + catalogRowJson.get("_id").getAsString() + NL);
            } else if (refAllele == null) {
                this.mCatalogUtil.logMessage("ERROR: _refAllele null. not checking json golden position length [" + jsonGoldenVariantLength + "]. row id: " + catalogRowJson.get("_id").getAsString() + NL);
            }
        }
        catch (Exception e) {
            this.mCatalogUtil.logMessage("Unable to create variant object from golden attributes. row id: " + catalogRowJson.get("_id").getAsString() + NL);
        }
        return variant;
    }

    private void validateNonVariantGoldenAttributes(JsonObject catalogRowJson) {
    }

    private void validateTabixHumanPositionsInChrRange(CatalogTabixEntry tabixEntry) throws Exception {
        if (tabixEntry.getChromosome() == null || tabixEntry.getChromosome().equals(".")) {
            return;
        }
        if (!this.inChromosomeRange(tabixEntry.getChromosome(), tabixEntry.getMinPosition())) {
            this.mCatalogUtil.logMessage("ERROR: Tabix start position not in valid chromosome size range.  Chr: " + tabixEntry.getChromosome() + " Chr Max Position: " + this.mChrSizeMap.get(tabixEntry.getChromosome()) + " Tabix entry start position: " + tabixEntry.getMinPosition() + NL);
        }
        if (!this.inChromosomeRange(tabixEntry.getChromosome(), tabixEntry.getMaxPosition())) {
            this.mCatalogUtil.logMessage("ERROR: Tabix stop position not in valid chromosome size range.  Chr: " + tabixEntry.getChromosome() + " Chr Max Position: " + this.mChrSizeMap.get(tabixEntry.getChromosome()) + " Tabix entry stop position: " + tabixEntry.getMaxPosition() + NL);
        }
    }

    private void validateTabixNonPositional(CatalogTabixEntry tabixEntry) throws Exception {
        String tabixChr = tabixEntry.getChromosome();
        if (tabixChr != null && !tabixChr.equals(".")) {
            this.mCatalogUtil.logMessage("WARNING: Non positional non-variant catalog has unexpected non-empty tabix chromosome value of: " + tabixChr);
        }
    }

    protected boolean compareTabixToGoldenElements(CatalogTabixEntry tabixRowEntry, GoldenJsonVariant goldenVariant, boolean catalogIsPositional) throws Exception {
        Integer jsonGoldenInt_maxBP;
        Integer jsonGoldenInt_minBP;
        String jsonLandmarkChr = goldenVariant.getChr();
        if (catalogIsPositional) {
            if (!tabixRowEntry.getChromosome().equals(jsonLandmarkChr)) {
                this.mCatalogUtil.logMessage("ERROR: Tabix chr [" + tabixRowEntry.getChromosome() + "] not string-equal to _landmark golden value [" + jsonLandmarkChr + "], but is positional catalog entry and should be equal, and present." + NL);
                return false;
            }
        } else if (!(jsonLandmarkChr == null && tabixRowEntry.getChromosome() == null || tabixRowEntry.getChromosome().equals("."))) {
            this.mCatalogUtil.logMessage("ERROR: Tabix chr [" + tabixRowEntry.getChromosome() + "] not equivalent to _landmark golden value [" + jsonLandmarkChr + "], for non-positional catalog entry and should be." + NL);
            return false;
        }
        if ((jsonGoldenInt_minBP = goldenVariant.getMinBP()) != null) {
            if (tabixRowEntry.getMinPosition().intValue() != jsonGoldenInt_minBP.intValue()) {
                this.mCatalogUtil.logMessage("ERROR: Tabix start position [" + tabixRowEntry.getMinPosition() + "] not equal to golden _minBP value [" + jsonGoldenInt_minBP + "]." + NL);
                return false;
            }
        } else if (catalogIsPositional) {
            this.mCatalogUtil.logMessage("ERROR: compareTabixToGoldenElements(): Json Golden _minBP is null but catalog is positional." + NL);
            return false;
        }
        if ((jsonGoldenInt_maxBP = goldenVariant.getMaxBP()) != null) {
            if (tabixRowEntry.getMaxPosition().intValue() != jsonGoldenInt_maxBP.intValue()) {
                this.mCatalogUtil.logMessage("ERROR: Tabix start position [" + tabixRowEntry.getMaxPosition() + "] not equal to golden _maxBP value [" + jsonGoldenInt_maxBP + "]." + NL);
                return false;
            }
        } else if (catalogIsPositional) {
            this.mCatalogUtil.logMessage("ERROR: compareTabixToGoldenElements(): Json Golden _maxBP is null but catalog is positional." + NL);
            return false;
        }
        if (catalogIsPositional) {
            if (tabixRowEntry.getMaxPosition() < tabixRowEntry.getMinPosition()) {
                this.mCatalogUtil.logMessage("ERROR: Tabix stop position [" + tabixRowEntry.getMaxPosition() + "] less than tabix start position [" + tabixRowEntry.getMinPosition() + "]. Invalid catalog format." + NL);
                return false;
            }
            if (jsonGoldenInt_minBP != null && jsonGoldenInt_maxBP != null && jsonGoldenInt_maxBP < jsonGoldenInt_minBP) {
                this.mCatalogUtil.logMessage("ERROR: Golden _maxBP stop position [" + jsonGoldenInt_maxBP + "] less than golden _minBP start value [" + jsonGoldenInt_minBP + "]. Invalid catalog format." + NL);
                return false;
            }
        }
        return true;
    }

    private boolean inChromosomeRange(String chr, int pos) {
        return pos >= 1 && pos <= this.mChrSizeMap.get(chr);
    }

    protected void setCatalogFileName(String catalogFileName) {
        this.mCatFileNm = catalogFileName;
    }

    protected void setCatalogColumnInfo(CatalogColumnsMap catalogColumnInfo) {
        this.mCatalogColumnInfo = catalogColumnInfo;
    }

    protected void setChromosome(String chr) {
        this.mChr = chr;
    }

    protected void setChromosomeSize(int chrSize) {
        this.mChrSize = chrSize;
    }

    protected void setChromosomeSizeMap(TreeMap<String, Integer> chrSizeMap) {
        this.mChrSizeMap = chrSizeMap;
    }

    protected void setValidationType(CatalogValidator.CAT_ATTR_VAL_TYPE valType) {
        this.mValidationType = valType;
    }

    protected boolean isPositionalCatalog() {
        return this.mIsPositionalCatalog;
    }

    protected void setPositionalCatalogIndicator(boolean isPositionalCatalog) {
        this.mIsPositionalCatalog = isPositionalCatalog;
    }

    protected CatalogValidatorUtils getCatalogUtil() {
        return this.mCatalogUtil;
    }

    protected void setCatalogUtil(CatalogValidatorUtils ourCatalogUtil) {
        this.mCatalogUtil = ourCatalogUtil;
    }

    protected void setRunMode(RUN_MODE runMode) {
        this.mRunMode = runMode;
    }

    public static enum RUN_MODE {
        PARALLEL,
        SERIAL;

    }
}

