/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalogvalidator;

import edu.mayo.bior.catalogvalidator.CatalogColumn;
import edu.mayo.bior.catalogvalidator.CatalogColumnsMap;
import edu.mayo.bior.catalogvalidator.CatalogValidatorUtils;
import edu.mayo.bior.catalogvalidator.DataSourceProperties;
import edu.mayo.bior.catalogvalidator.FileUtils;
import edu.mayo.bior.catalogvalidator.RowLevelValidationThread;
import edu.mayo.bior.catalogvalidator.WholeCatalogValidationThread;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CatalogValidator {
    public static final String BASEDIR_TEST = "/data5/";
    public static final String LOG_DIR = "/data5//bsi/BORA/Testing/jaj/bior/";
    public static final String kCatFileSuffix = ".tsv.bgz";
    public static final String kCatColsSuffix = ".columns.tsv";
    public static final String kCatTabixIndexSuffix = ".tsv.bgz.tbi";
    public static final String kCatDataSrcPropsSuffix = ".datasource.properties";
    public static final String kCatBlacklistSuffix = ".columns.tsv.blacklist";
    public static final String kCatBlacklistBiorwebSuffix = ".columns.tsv.blacklist.biorweb";
    public static final String kCatIndexDir = "index";
    public static final String kCatIndexSuffix = ".idx.h2.db";
    private TreeMap<String, Integer> mMessageTrackingMap = null;
    private CatalogValidatorUtils mCatalogUtil = null;
    private String mCatalogDir = null;
    private String mCatalogName = null;
    private File mColumnsTsvFile = null;
    private CatalogColumnsMap mCatalogColumns = null;
    private TreeMap<String, Integer> mChrSizeMap = null;
    private TreeMap<String, String> mBIORIndexMap_colNameToFilePath = null;
    RowLevelValidationThread.RUN_MODE mRowLevelCheck_runMode = RowLevelValidationThread.RUN_MODE.SERIAL;
    VAL_TYPE mvalType = VAL_TYPE.STRICT;
    private static String NL = "\n";
    private static String TAB = "\t";

    public CatalogValidator() {
        this.mMessageTrackingMap = new TreeMap();
        this.mCatalogUtil = new CatalogValidatorUtils(this.mMessageTrackingMap);
    }

    private void verifyCosmicLines() throws NumberFormatException, IOException {
        BufferedReader instr = new BufferedReader(new FileReader("cosmic_catalog_positionsCheck.tsv"));
        String line = null;
        while ((line = instr.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] cols = line.split(TAB);
            String chr = cols[0];
            int start = Integer.parseInt(cols[1]);
            int end = Integer.parseInt(cols[2]);
            String sampleId = cols[3];
            String genomePos = cols[4];
            String[] genPosParts = genomePos.split(":");
            String chr2 = genPosParts[0];
            String minAndMax = genPosParts[1];
            String[] posParts = minAndMax.split("-");
            int minbp = Integer.parseInt(posParts[0]);
            int maxbp = Integer.parseInt(posParts[1]);
            if (!chr.equalsIgnoreCase(chr2)) {
                System.err.println("Chromosome is not equal!  Line: " + line);
            }
            if (start == minbp) continue;
            System.err.println("MinBP not equal!          Line: " + line);
        }
    }

    public static void main(String[] args) {
        String variant_nodups_catalog = "/data5//bsi/catalogs/bior/v1/dbSNP/142_GRCh37.p13/variants_nodups.v2/00-All.vcf.tsv.bgz";
        String grChrOrder = "/data5//bsi/bioinf_int/s110048.catalog_building/validation_home/GRCh37/ordered_chroms";
        String grChrSizes = "/data5//bsi/bioinf_int/s110048.catalog_building/validation_home/GRCh37/grch37.chrom.sizes";
        String catalogList = "/data5//bsi/catalogs/bior/v1/CATALOG_LIST.txt";
        String nonvariant_catalog = "/data5//bsi/catalogs/bior/v1/NCBIGene/GRCh37_p13/genes.tsv.bgz";
        CatalogValidator val = new CatalogValidator();
        try {
            val.validateCatalog(nonvariant_catalog, grChrOrder, grChrSizes, catalogList, CAT_ATTR_VAL_TYPE.NONVARIANT_ATTRIBUTES);
        }
        catch (Exception e) {
            System.err.println("CatalogValidator: main(): failure in validateCatalog(dbSNP_test,CAT_VAL_TYPE.HUMAN_VARIANT_ATTRIBUTES)");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateCatalog(String catalogFilePath, String chrOrderFileName, String chrSizeFileName, String catalogListFileName, CAT_ATTR_VAL_TYPE valType) throws Exception {
        File catLogger_WholeFileCheckLogFile = null;
        BufferedWriter wholeFileCheckLogWtr = null;
        File catLogger_RowLevelCheckLogFile = null;
        BufferedWriter rowLevelCheckLogWtr = null;
        try {
            if (catalogFilePath == null || catalogFilePath.length() <= 0) {
                throw new Exception("Catalog specified is null. Cannot validate catalog.");
            }
            File catalogFile = new File(catalogFilePath);
            TreeMap<String, Integer> rowLevelCheckMessageMap = new TreeMap<String, Integer>();
            CatalogValidatorUtils rowCatlogUtilsInstance = new CatalogValidatorUtils(rowLevelCheckMessageMap);
            this.validateCommonAttributes(catalogFile, catalogListFileName);
            if (valType == null || valType.equals((Object)CAT_ATTR_VAL_TYPE.COMMON_ATTRIBUTES)) {
                System.err.println("WARNING: Only catalog common attributes will be validated. CAT_VAL_TYPE parameter passed: " + (valType != null ? valType.name() : "null"));
                return;
            }
            boolean isPositionalCatalog = this.mCatalogUtil.isPositionalCatalog(catalogFile);
            WholeCatalogValidationThread wholeFileValThread = null;
            if (isPositionalCatalog) {
                wholeFileValThread = this.initPositionalElements(catalogFile, chrSizeFileName, chrOrderFileName, valType, this.mCatalogUtil);
            }
            List<RowLevelValidationThread> rowLevelThreadList = this.validateRowLevelAttributes(catalogFile, isPositionalCatalog, valType, rowCatlogUtilsInstance);
            if (wholeFileValThread != null) {
                wholeFileValThread.join(0L);
            }
            for (RowLevelValidationThread rowLevelValidationThread : rowLevelThreadList) {
                rowLevelValidationThread.join(0L);
            }
            catLogger_WholeFileCheckLogFile = new File("/data5//bsi/BORA/Testing/jaj/bior//wholeCatalogVal_" + catalogFile.getName() + ".txt");
            wholeFileCheckLogWtr = new BufferedWriter(new FileWriter(catLogger_WholeFileCheckLogFile));
            wholeFileCheckLogWtr.write("NumberOccurrences\tError\n");
            for (Map.Entry entry : this.mMessageTrackingMap.entrySet()) {
                wholeFileCheckLogWtr.write(entry.getValue() + TAB + (String)entry.getKey() + NL);
            }
            catLogger_RowLevelCheckLogFile = new File("/data5//bsi/BORA/Testing/jaj/bior//rowCatalogVal_" + catalogFile.getName() + ".txt");
            rowLevelCheckLogWtr = new BufferedWriter(new FileWriter(catLogger_RowLevelCheckLogFile));
            rowLevelCheckLogWtr.write("NumberOccurrences\tError\n");
            for (Map.Entry entry : rowLevelCheckMessageMap.entrySet()) {
                rowLevelCheckLogWtr.write(entry.getValue() + TAB + (String)entry.getKey() + NL);
            }
            String endtimeStamp = new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss z").format(Calendar.getInstance().getTime());
            wholeFileCheckLogWtr.write("Exiting validateVariantCharacteristics(). Date/Time: " + endtimeStamp);
            wholeFileCheckLogWtr.write("Catalog Columns.tsv File Information:" + NL);
            for (String eachCatCol : this.mCatalogColumns.getOrderedColumnNames()) {
                CatalogColumn catCol = this.mCatalogColumns.getColumn(eachCatCol);
                StringBuffer msgBuf = new StringBuffer();
                msgBuf.append("Catalog Column: " + eachCatCol + NL);
                int numTimesInCatalog = catCol.getNumberObservedInCatalog();
                if (numTimesInCatalog == 0) {
                    msgBuf.append(TAB + "WARNING: This column was not found in the catalog. Consider removing it from the columns.tsv file." + NL);
                } else {
                    msgBuf.append(TAB + "Number of occurrences in catalog: " + catCol.getNumberObservedInCatalog() + NL);
                }
                CatalogColumn colDefn = this.mCatalogColumns.getColumn(eachCatCol);
                if (colDefn.getDataType().equalsIgnoreCase("string") && colDefn.getCount().equals(".")) {
                    msgBuf.append(TAB + "Largest number of elements found for array column: " + catCol.getMaximumNumElementsInColumn() + NL);
                }
                wholeFileCheckLogWtr.write(msgBuf.toString());
            }
        }
        catch (Exception e) {
            System.err.println("CatalogValidator.validateCatalog(): failure in validateCatalog(). Exception: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                if (wholeFileCheckLogWtr != null) {
                    wholeFileCheckLogWtr.flush();
                    wholeFileCheckLogWtr.close();
                }
                if (rowLevelCheckLogWtr != null) {
                    rowLevelCheckLogWtr.flush();
                    rowLevelCheckLogWtr.close();
                }
            }
            catch (Exception e) {
                System.err.println("WARNING: Exception closing logging buffers: " + catLogger_WholeFileCheckLogFile.getAbsolutePath() + " " + catLogger_RowLevelCheckLogFile.getAbsolutePath() + NL);
            }
        }
    }

    private void validateCommonAttributes(File catalogFile, String catalogListFileName) throws Exception {
        this.checkCatalogFile(catalogFile);
        this.checkSupportingFilesExist(catalogFile);
        if (this.mColumnsTsvFile != null) {
            this.mCatalogColumns = new CatalogColumnsMap(this.mColumnsTsvFile);
            if (this.mCatalogColumns.getOrderedColumnNames().size() < 1) {
                this.mCatalogUtil.logMessage("ERROR: number of columns read from columns.tsv less than one for catalog: " + catalogFile.getAbsolutePath() + "\n");
            }
        }
        File datasourcePropFile = new File(this.getCatalogDir() + File.separator + this.getCatalogNamePrefix() + kCatDataSrcPropsSuffix);
        this.validateDatasourceProps(catalogFile, datasourcePropFile, catalogListFileName, this.mvalType);
        this.mBIORIndexMap_colNameToFilePath = this.validateBIORIndexFilenames(catalogFile);
        File blacklistFile = new File(this.getCatalogDir() + File.separator + this.getCatalogNamePrefix() + kCatBlacklistSuffix);
        this.validateBlackList(blacklistFile);
    }

    private WholeCatalogValidationThread initPositionalElements(File catalogFile, String chromosomeSizesFileName, String chromosomeOrderFileFileName, CAT_ATTR_VAL_TYPE validationType, CatalogValidatorUtils wholeFileValUtilAndLog) throws Exception {
        if (chromosomeSizesFileName == null || chromosomeSizesFileName.length() <= 0) {
            throw new Exception("Chromosome-size file specified is not valid. Cannot validate catalog positional elements without this file.");
        }
        if (chromosomeOrderFileFileName == null || chromosomeOrderFileFileName.length() <= 0) {
            throw new Exception("Chromosome-order file specified is not valid. Cannot validate catalog positional elements without this file.");
        }
        File tabixIndexFile = new File(this.getCatalogDir() + File.separator + this.getCatalogNamePrefix() + kCatTabixIndexSuffix);
        if (!FileUtils.fileExists(tabixIndexFile)) {
            wholeFileValUtilAndLog.logMessage("ERROR: File not exist: " + tabixIndexFile.getAbsolutePath());
        } else if (catalogFile.lastModified() > tabixIndexFile.lastModified()) {
            wholeFileValUtilAndLog.logMessage("ERROR: Tabix index file timestamp is older than the catalog file itself: " + tabixIndexFile.getAbsolutePath());
        }
        this.mChrSizeMap = this.initChrSizes(chromosomeSizesFileName);
        if (this.mChrSizeMap == null || this.mChrSizeMap.size() != 25) {
            throw new Exception("Chromosome-size map is null or not expected size of 25 elements. Cannot validate catalog positional elements without this info.");
        }
        List<String> expectedChrOrderList = this.initChrOrder(chromosomeOrderFileFileName);
        if (expectedChrOrderList == null || expectedChrOrderList.size() != 25) {
            throw new Exception("Chromosome-order list is not valid; expected 25 elements. Cannot validate catalog positional elements without this info. expectedChrOrderList=" + expectedChrOrderList.toString());
        }
        String timeStamp = new SimpleDateFormat("MM.dd.yyyy 'at' HH:mm:ss z").format(Calendar.getInstance().getTime());
        System.out.println("Starting Variant Catalog Validation. Date/Time: " + timeStamp);
        WholeCatalogValidationThread catalogWholeFileCheckThread = new WholeCatalogValidationThread();
        catalogWholeFileCheckThread.setCatalogFileName(catalogFile.getAbsolutePath());
        catalogWholeFileCheckThread.setExpectedChrOrderList(expectedChrOrderList);
        catalogWholeFileCheckThread.setBiorIndexMap(this.mBIORIndexMap_colNameToFilePath);
        catalogWholeFileCheckThread.setValidationType(validationType);
        catalogWholeFileCheckThread.setPositionalCatalogIndicator(true);
        catalogWholeFileCheckThread.setCatalogUtil(wholeFileValUtilAndLog);
        System.out.println("Starting whole-file, order-checking catalog validation in thread named [" + catalogWholeFileCheckThread.getName() + "].");
        catalogWholeFileCheckThread.start();
        return catalogWholeFileCheckThread;
    }

    private List<RowLevelValidationThread> validateRowLevelAttributes(File catalogFile, boolean isPositionalCatalog, CAT_ATTR_VAL_TYPE validationType, CatalogValidatorUtils rowLevelCatUtils) {
        ArrayList<RowLevelValidationThread> allRowValThreads = new ArrayList<RowLevelValidationThread>();
        if (this.mRowLevelCheck_runMode.name().equals(RowLevelValidationThread.RUN_MODE.SERIAL.name())) {
            RowLevelValidationThread chrRowCheckThread = new RowLevelValidationThread();
            chrRowCheckThread.setCatalogFileName(catalogFile.getAbsolutePath());
            chrRowCheckThread.setCatalogColumnInfo(this.mCatalogColumns);
            chrRowCheckThread.setChromosomeSizeMap(this.mChrSizeMap);
            chrRowCheckThread.setValidationType(validationType);
            chrRowCheckThread.setPositionalCatalogIndicator(isPositionalCatalog);
            chrRowCheckThread.setRunMode(RowLevelValidationThread.RUN_MODE.SERIAL);
            chrRowCheckThread.setCatalogUtil(rowLevelCatUtils);
            System.out.println("Starting row-level catalog validation in thread named [" + chrRowCheckThread.getName() + "].");
            chrRowCheckThread.start();
            allRowValThreads.add(chrRowCheckThread);
        } else {
            for (Map.Entry<String, Integer> entry : this.mChrSizeMap.entrySet()) {
                RowLevelValidationThread chrRowCheckThread = new RowLevelValidationThread();
                chrRowCheckThread.setCatalogFileName(catalogFile.getAbsolutePath());
                chrRowCheckThread.setCatalogColumnInfo(this.mCatalogColumns);
                chrRowCheckThread.setChromosome(entry.getKey());
                chrRowCheckThread.setChromosomeSize(entry.getValue());
                chrRowCheckThread.setChromosomeSizeMap(this.mChrSizeMap);
                chrRowCheckThread.setValidationType(validationType);
                chrRowCheckThread.setPositionalCatalogIndicator(isPositionalCatalog);
                chrRowCheckThread.setRunMode(RowLevelValidationThread.RUN_MODE.PARALLEL);
                chrRowCheckThread.setCatalogUtil(rowLevelCatUtils);
                System.out.println("Starting row-level catalog validation of chromosome [" + entry.getKey() + "] in thread named [" + chrRowCheckThread.getName() + "].");
                chrRowCheckThread.start();
                allRowValThreads.add(chrRowCheckThread);
            }
        }
        return allRowValThreads;
    }

    private void checkCatalogFile(File catalogFile) throws Exception {
        if (!FileUtils.fileExists(catalogFile)) {
            throw new Exception("Catalog specified does not exist or is not readable: " + catalogFile.getCanonicalPath());
        }
        this.setCatalogNamePrefix(catalogFile);
        if (this.getCatalogNamePrefix() == null || this.getCatalogNamePrefix().length() <= 0) {
            throw new Exception("Couldn't get a valid catalog name based on the expected suffix name for catalog: " + catalogFile.getCanonicalPath());
        }
        if (!catalogFile.getName().endsWith(kCatFileSuffix)) {
            throw new Exception("Expected suffix name [.tsv.bgz] not found for catalog: " + catalogFile.getCanonicalPath());
        }
        this.setCatalogDir(catalogFile);
        if (this.getCatalogDir() == null || this.getCatalogDir().length() == 0) {
            throw new Exception("Catalog directory not acquired successfully: " + this.getCatalogDir());
        }
    }

    private void checkSupportingFilesExist(File catalogFile) throws Exception {
        File blackList_biorWebSymLink;
        File catDir = catalogFile.getParentFile();
        String catalogNamePrefix = this.getCatalogNamePrefix();
        this.mColumnsTsvFile = new File(catDir + File.separator + catalogNamePrefix + kCatColsSuffix);
        if (!FileUtils.fileExists(this.mColumnsTsvFile)) {
            this.mCatalogUtil.logMessage("File not exist: " + this.mColumnsTsvFile.getAbsolutePath());
        }
        if (!FileUtils.fileExists(new File(catDir + File.separator + catalogNamePrefix + kCatDataSrcPropsSuffix))) {
            this.mCatalogUtil.logMessage("File not exist: " + catDir + File.separator + catalogNamePrefix + kCatDataSrcPropsSuffix);
        }
        if (!FileUtils.fileExists(new File(catDir + File.separator + catalogNamePrefix + kCatBlacklistSuffix))) {
            this.mCatalogUtil.logMessage("File not exist: " + catDir + File.separator + catalogNamePrefix + kCatBlacklistSuffix);
        }
        if (!FileUtils.fileExists(blackList_biorWebSymLink = new File(catDir + File.separator + catalogNamePrefix + kCatBlacklistBiorwebSuffix))) {
            this.mCatalogUtil.logMessage("File not exist: " + catDir + File.separator + catalogNamePrefix + kCatBlacklistBiorwebSuffix);
        } else if (!FileUtils.validSymLink(blackList_biorWebSymLink)) {
            this.mCatalogUtil.logMessage("Unable to follow/resolve symlink for biorweb blacklist sym link file: " + blackList_biorWebSymLink.getAbsolutePath());
        }
    }

    private TreeMap<String, String> validateBIORIndexFilenames(File catalogFile) throws Exception {
        File[] fList;
        TreeMap<String, String> biorIndexMap = new TreeMap<String, String>();
        File indexDir = new File(this.getCatalogDir() + File.separator + kCatIndexDir);
        if (!indexDir.isDirectory()) {
            return null;
        }
        for (File f : fList = indexDir.listFiles()) {
            String tmpHack_indexname;
            String fBaseNm = f.getName();
            if (!fBaseNm.startsWith(tmpHack_indexname = this.getCatalogNamePrefix().replace(".vcf", "")) || !fBaseNm.endsWith(kCatIndexSuffix)) continue;
            String colNameIndexed = fBaseNm.substring(new String(tmpHack_indexname + '.').length(), fBaseNm.indexOf(kCatIndexSuffix));
            if (this.mCatalogColumns.getColumn(colNameIndexed) == null) {
                this.mCatalogUtil.logMessage("WARNING: BIOR Index checking: Column name in BIOR index [" + colNameIndexed + "] not found in Columns.tsv list. Unusable Index: " + f.getAbsolutePath() + "\n");
                continue;
            }
            if (catalogFile.lastModified() > f.lastModified()) {
                this.mCatalogUtil.logMessage("WARNING: BIOR Index checking: Catalog file [" + catalogFile.getCanonicalPath() + "] is newer than the BIOR index found. Must regenerate BIOR Index: " + f.getCanonicalPath());
                continue;
            }
            biorIndexMap.put(colNameIndexed, f.getCanonicalPath());
        }
        if (biorIndexMap.size() == 0) {
            this.mCatalogUtil.logMessage("WARNING: BIOR Index checking: No valid H2 database file names found in index subdirectory for catalog name: " + this.getCatalogNamePrefix() + "\n");
        }
        return biorIndexMap;
    }

    private void validateBlackList(File blacklistFile) throws Exception {
        BufferedReader rdr = FileUtils.getBufferedReader(blacklistFile.getAbsolutePath());
        String line = null;
        while ((line = rdr.readLine()) != null) {
            if (line.trim().startsWith("#") || this.mCatalogColumns.getColumn(line.trim()) != null) continue;
            this.mCatalogUtil.logMessage("ERROR: The blacklist file contains a column name not found in the columns.tsv file: " + line.trim());
        }
    }

    private void validateDatasourceProps(File ourCatalogFile, File datasourcePropFile, String catalogListFileName, VAL_TYPE valType) throws Exception {
        DataSourceProperties dataSrcProps = new DataSourceProperties(datasourcePropFile);
        List<String> reqPropNames = dataSrcProps.getRequiredPropertyNames();
        TreeMap<String, String> trackRequiredProps = new TreeMap<String, String>();
        Enumeration<?> e = dataSrcProps.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = dataSrcProps.getProperty(key);
            if (reqPropNames.contains(key)) {
                trackRequiredProps.put(key, value);
                continue;
            }
            if (!key.equalsIgnoreCase(DataSourceProperties.FORMAT_PROP_NM)) continue;
            trackRequiredProps.put(key, value);
        }
        if (trackRequiredProps.size() != 7) {
            reqPropNames.removeAll(trackRequiredProps.keySet());
            this.mCatalogUtil.logMessage("ERROR: all required datasource properties not found. Required properties not found: " + reqPropNames.toString());
        }
        String catalogVersion = null;
        String buildNum = null;
        for (Map.Entry eachEntry : trackRequiredProps.entrySet()) {
            String key = this.mCatalogUtil.trim((String)eachEntry.getKey());
            String val = this.mCatalogUtil.trim((String)eachEntry.getValue());
            if (key == null) {
                this.mCatalogUtil.logMessage("ERROR: Data source property has empty/invalid property name for value [" + val + "]");
                continue;
            }
            if (key.equals(DataSourceProperties.VERSION_NM_PROP_NM) && val == null) {
                this.mCatalogUtil.logMessage("ERROR: Data source property [" + key + "] must have a value always.");
                continue;
            }
            catalogVersion = val;
            if (key.equals(DataSourceProperties.BUILD_PROP_NM) && valType.name().equals((Object)VAL_TYPE.STRICT) && val == null) {
                this.mCatalogUtil.logMessage("WARNING: Data source property [" + key + "] must have a value when strict checking enabled.");
                continue;
            }
            buildNum = val;
            if (key.equals(DataSourceProperties.DESC_PROP_NM) && valType.name().equals((Object)VAL_TYPE.STRICT) && val == null) {
                this.mCatalogUtil.logMessage("WARNING: Data source property [" + key + "] must have a value when strict checking enabled.");
                continue;
            }
            if (key.equalsIgnoreCase(DataSourceProperties.FORMAT_PROP_NM) && !((String)eachEntry.getValue()).equals("1.1.0")) {
                this.mCatalogUtil.logMessage("ERROR: field value for datasource property " + DataSourceProperties.FORMAT_PROP_NM + " is not supported currently: " + val);
            }
            if (!key.equals(DataSourceProperties.SHORT_NM_PROP_NM)) continue;
            this.checkShortUniqueName(ourCatalogFile, val, catalogListFileName);
        }
    }

    private void checkShortUniqueName(File ourCatalogFile, String ourShortUniqueNm, String catalogListFileName) throws Exception {
        try {
            BufferedReader catListRdr = FileUtils.getBufferedReader(catalogListFileName);
            File currentCatListFile = null;
            String ln = null;
            while ((ln = catListRdr.readLine()) != null) {
                if (ln.startsWith("#")) continue;
                String[] elems = ln.split(TAB);
                if (elems.length != 5) {
                    this.mCatalogUtil.logMessage("ERROR: Unexpected file format for catalog list file. Please verify correct file passed: " + catalogListFileName);
                    continue;
                }
                currentCatListFile = new File(elems[1]);
                if (currentCatListFile == null || !currentCatListFile.exists()) {
                    this.mCatalogUtil.logMessage("WARNING: Catalog file specified  [" + elems[1] + "] in catalog list doesn't exist. Catalog list file: " + catalogListFileName);
                    continue;
                }
                if (ourCatalogFile.getCanonicalPath().equals(currentCatListFile.getCanonicalPath()) || !ourShortUniqueNm.equals(elems[3])) continue;
                this.mCatalogUtil.logMessage("WARNING: Catalog files have same short unique names. " + NL + " Our catalog file: " + ourCatalogFile.getCanonicalPath() + NL + " Catalog List entry with same short unique name value: " + currentCatListFile.getCanonicalPath() + NL + " Short Unique Name value: " + elems[3] + NL + " Catalog List file: " + catalogListFileName + NL);
            }
        }
        catch (Exception exc) {
            this.mCatalogUtil.logMessage("WARNING: Got exception checking data source property short unique name. exc: " + exc.getMessage());
            exc.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TreeMap<String, Integer> initChrSizes(String genomeRefChrSizeFileNm) {
        if (genomeRefChrSizeFileNm == null) return null;
        if (genomeRefChrSizeFileNm.length() <= 0) {
            return null;
        }
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(genomeRefChrSizeFileNm));
            String n2332 = null;
            while ((n2332 = r.readLine()) != null) {
                String[] elems = n2332.trim().split(TAB);
                if (elems.length != 2) {
                    throw new Exception("genome chromosome size file not in format execpted. Not two columns in file: " + genomeRefChrSizeFileNm);
                }
                String chr = null;
                Integer iPos = null;
                try {
                    chr = elems[0].trim().replace("chr", "");
                }
                catch (Exception e) {
                    chr = null;
                }
                try {
                    iPos = new Integer(elems[1].trim());
                }
                catch (Exception e) {
                    iPos = null;
                }
                if (chr == null || iPos == null) continue;
                map.put(chr, iPos);
            }
        }
        catch (Throwable t) {
            try {
                TreeMap<String, Integer> treeMap = null;
                return treeMap;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            r.close();
            return map;
        }
        catch (Exception n2332) {
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> initChrOrder(String orderedChrFileName) throws Exception {
        ArrayList<String> orderedChrExpecting = new ArrayList<String>();
        BufferedReader r = null;
        try {
            r = FileUtils.getBufferedReader(orderedChrFileName);
            String l = null;
            while ((l = r.readLine()) != null) {
                String ln = l.trim();
                if (ln.length() <= 0) continue;
                orderedChrExpecting.add(ln);
            }
        }
        catch (Exception e) {
            List<String> list = null;
            return list;
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception exception) {}
        }
        return orderedChrExpecting;
    }

    private void setCatalogNamePrefix(File catalogFile) {
        if (catalogFile == null) {
            return;
        }
        String basename = catalogFile.getName();
        String catalogNamePrefix = basename.substring(0, basename.indexOf(kCatFileSuffix));
        if (catalogNamePrefix != null && catalogNamePrefix.length() > 0) {
            this.mCatalogName = catalogNamePrefix;
        }
    }

    private String getCatalogNamePrefix() {
        return this.mCatalogName;
    }

    private void setCatalogDir(File catalogFile) {
        File catDir = catalogFile.getParentFile();
        if (!catDir.isDirectory()) {
            return;
        }
        this.mCatalogDir = catDir.getAbsolutePath();
    }

    private String getCatalogDir() {
        return this.mCatalogDir;
    }

    static enum VAL_TYPE {
        LENIENT,
        STRICT;

    }

    static enum CAT_ATTR_VAL_TYPE {
        COMMON_ATTRIBUTES,
        HUMAN_VARIANT_ATTRIBUTES,
        NONHUMAN_VARIANT_ATTRIBUTES,
        NONVARIANT_ATTRIBUTES;

    }
}

