/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.refassembly;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.genomicutils.refassembly.AssemblyNotSupportedException;
import edu.mayo.genomicutils.refassembly.RefAssemblyFinder;
import edu.mayo.pipes.bioinformatics.sequence.Bed2SequencePipe;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class RefBasePairLookup {
    private String mReferenceAssemblyCatalogPath;
    private Pipe mPipeline = null;
    private Bed2SequencePipe mBed2SequencePipe = null;

    public RefBasePairLookup(String refAssemblyPath) throws AssemblyNotSupportedException, IOException {
        this.mReferenceAssemblyCatalogPath = refAssemblyPath;
        if (!new File(this.mReferenceAssemblyCatalogPath).exists()) {
            throw new AssemblyNotSupportedException(this.mReferenceAssemblyCatalogPath);
        }
        this.mBed2SequencePipe = new Bed2SequencePipe(this.mReferenceAssemblyCatalogPath);
        this.mPipeline = new Pipeline(new Pipe[]{this.mBed2SequencePipe});
    }

    public RefBasePairLookup(String refAssemblyBaseDir, String refAssemblyName) throws AssemblyNotSupportedException, IOException {
        this(new RefAssemblyFinder().getFullPathToRefAssemblyCatalog(refAssemblyBaseDir, refAssemblyName));
    }

    public String getBasePairAtPosition(String landmark, String minBP, String maxBP) {
        ArrayList<String> in = new ArrayList<String>();
        in.add(landmark);
        in.add(minBP);
        in.add(maxBP);
        String result = "";
        this.mBed2SequencePipe.reset();
        this.mPipeline.reset();
        this.mPipeline.setStarts(Arrays.asList(in));
        ArrayList out = (ArrayList)this.mPipeline.next();
        result = (String)out.get(3);
        return result;
    }
}

