/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.DistributionTools;
import org.biojava.bio.dist.IndexedCount;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.CodonPref;
import org.biojava.bio.symbol.CodonPrefTools;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ManyToOneTranslationTable;
import org.biojava.bio.symbol.SimpleWobbleDistribution;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.WobbleDistribution;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public class SimpleCodonPref
extends AbstractChangeable
implements CodonPref {
    String name;
    String geneticCodeName;
    Distribution codonPref;
    Map codonPrefByResidue = null;
    Map wobbleDistributions;

    public SimpleCodonPref(String geneticCodeName, Distribution codonPref, String name) throws IllegalAlphabetException {
        this.name = name;
        this.geneticCodeName = geneticCodeName;
        this.codonPref = codonPref;
        if (codonPref.getAlphabet() != RNATools.getCodonAlphabet()) {
            throw new IllegalAlphabetException("codon preferences must be over codon alphabet");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getGeneticCodeName() {
        return this.geneticCodeName;
    }

    public ManyToOneTranslationTable getGeneticCode() {
        return RNATools.getGeneticCode(this.geneticCodeName);
    }

    public Distribution getFrequency() {
        return this.codonPref;
    }

    public Distribution getFrequencyForSynonyms(Symbol residue) throws IllegalSymbolException {
        if (this.codonPrefByResidue == null) {
            this.preparePrefsByResidue();
        }
        return (Distribution)this.codonPrefByResidue.get(residue);
    }

    public WobbleDistribution getWobbleDistributionForSynonyms(Symbol residue) throws IllegalSymbolException {
        if (this.wobbleDistributions == null) {
            this.preparePrefsByWobble();
        }
        return (WobbleDistribution)this.wobbleDistributions.get(residue);
    }

    private void preparePrefsByResidue() throws IllegalSymbolException {
        try {
            this.codonPrefByResidue = new HashMap();
            Iterator<Symbol> residueI = ProteinTools.getTAlphabet().iterator();
            while (residueI.hasNext()) {
                Symbol residue = residueI.next();
                if (residue.getName().equals("SEC") || residue.getName().equals("PYL")) continue;
                double residueFreq = 0.0;
                Set synonyms = this.getGeneticCode().untranslate(residue);
                for (Symbol synonym : synonyms) {
                    residueFreq += this.codonPref.getWeight(synonym);
                }
                Distribution residueCodonDist = DistributionFactory.DEFAULT.createDistribution(RNATools.getCodonAlphabet());
                for (Symbol synonym : synonyms) {
                    residueCodonDist.setWeight(synonym, this.codonPref.getWeight(synonym) / residueFreq);
                }
                residueCodonDist.addChangeListener(ChangeListener.ALWAYS_VETO);
                this.codonPrefByResidue.put(residue, residueCodonDist);
            }
        }
        catch (ChangeVetoException cve) {
        }
        catch (IllegalAlphabetException illegalAlphabetException) {
            // empty catch block
        }
    }

    private void preparePrefsByWobble() throws IllegalSymbolException {
        try {
            this.wobbleDistributions = new HashMap();
            FiniteAlphabet nonWobbleAlfa = CodonPrefTools.getDinucleotideAlphabet();
            Iterator<Symbol> residueI = ProteinTools.getTAlphabet().iterator();
            while (residueI.hasNext()) {
                Symbol residue = residueI.next();
                if (residue.getName().equals("SEC") || residue.getName().equals("PYL")) continue;
                IndexedCount nonWobbleCounts = new IndexedCount(nonWobbleAlfa);
                HashMap<AtomicSymbol, Changeable> wobbleDists = new HashMap<AtomicSymbol, Changeable>();
                HashSet<AtomicSymbol> nonWobbleBases = new HashSet<AtomicSymbol>();
                Set synonyms = this.getGeneticCode().untranslate(residue);
                for (BasisSymbol synonym : synonyms) {
                    List codonSymbols = synonym.getSymbols();
                    AtomicSymbol wobble = (AtomicSymbol)codonSymbols.get(2);
                    ArrayList<Symbol> nonWobbleSymbols = new ArrayList<Symbol>(2);
                    nonWobbleSymbols.add((Symbol)codonSymbols.get(0));
                    nonWobbleSymbols.add((Symbol)codonSymbols.get(1));
                    AtomicSymbol nonWobble = (AtomicSymbol)nonWobbleAlfa.getSymbol(nonWobbleSymbols);
                    nonWobbleBases.add(nonWobble);
                    double codonFreq = this.codonPref.getWeight(synonym);
                    nonWobbleCounts.increaseCount(nonWobble, codonFreq);
                    IndexedCount wobbleCounts = (IndexedCount)wobbleDists.get(nonWobble);
                    if (wobbleCounts == null) {
                        wobbleCounts = new IndexedCount(RNATools.getRNA());
                        wobbleDists.put(nonWobble, wobbleCounts);
                    }
                    wobbleCounts.increaseCount(wobble, codonFreq);
                }
                Distribution nonWobbleDist = DistributionTools.countToDistribution(nonWobbleCounts);
                for (AtomicSymbol nonWobbleBase : nonWobbleBases) {
                    IndexedCount count = (IndexedCount)wobbleDists.get(nonWobbleBase);
                    if (count == null) continue;
                    Distribution wobbleDist = DistributionTools.countToDistribution(count);
                    wobbleDists.put(nonWobbleBase, wobbleDist);
                }
                this.wobbleDistributions.put(residue, new SimpleWobbleDistribution(residue, nonWobbleBases, nonWobbleDist, wobbleDists));
            }
        }
        catch (IllegalAlphabetException iae) {
            System.err.println("unexpected IllegalAlphabetException");
        }
        catch (ChangeVetoException cve) {
            System.err.println("unexpected ChangeVetoException");
        }
    }
}

