/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.tabix;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import edu.mayo.pipes.bioinformatics.vocab.ComparableObjectInterface;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;

public class SameVariantLogic
implements ComparableObjectInterface {
    private boolean isCheckRsidAlso = false;
    private JsonPath chrJsonPath = null;
    private JsonPath minBpJsonPath = null;
    private JsonPath rsIdJsonPath = null;
    private JsonPath refJsonPath = null;
    private JsonPath altJsonPath = null;

    public SameVariantLogic() {
        this(false);
    }

    public SameVariantLogic(boolean isCheckRsidAlso) {
        this.isCheckRsidAlso = isCheckRsidAlso;
        this.chrJsonPath = JsonPath.compile((String)CoreAttributes._landmark.toString(), (Filter[])new Filter[0]);
        this.minBpJsonPath = JsonPath.compile((String)CoreAttributes._minBP.toString(), (Filter[])new Filter[0]);
        this.rsIdJsonPath = JsonPath.compile((String)CoreAttributes._id.toString(), (Filter[])new Filter[0]);
        this.refJsonPath = JsonPath.compile((String)CoreAttributes._refAllele.toString(), (Filter[])new Filter[0]);
        this.altJsonPath = JsonPath.compile((String)CoreAttributes._altAlleles.toString(), (Filter[])new Filter[0]);
    }

    @Override
    public boolean same(String jsonIn, String jsonCatalog) {
        boolean isRefsAndAltsGiven;
        String chrIn = (String)this.getJsonVal(jsonIn, this.chrJsonPath);
        String chrCatalog = (String)this.getJsonVal(jsonCatalog, this.chrJsonPath);
        if (!this.isGiven(chrIn) || !chrIn.equalsIgnoreCase(chrCatalog)) {
            return false;
        }
        Integer minBpIn = (Integer)this.getJsonVal(jsonIn, this.minBpJsonPath);
        Integer minBpCatalog = (Integer)this.getJsonVal(jsonCatalog, this.minBpJsonPath);
        if (minBpIn == null || minBpIn.compareTo(minBpCatalog) != 0) {
            return false;
        }
        String refIn = this.isJsonPathOk(jsonIn, this.refJsonPath) ? (String)this.getJsonVal(jsonIn, this.refJsonPath) : null;
        String refCatalog = this.isJsonPathOk(jsonCatalog, this.refJsonPath) ? (String)this.getJsonVal(jsonCatalog, this.refJsonPath) : null;
        ArrayList<String> altsIn = this.isJsonPathOk(jsonIn, this.altJsonPath) ? this.toList((JSONArray)this.getJsonVal(jsonIn, this.altJsonPath)) : null;
        ArrayList<String> altsCatalog = this.isJsonPathOk(jsonCatalog, this.altJsonPath) ? this.toList((JSONArray)this.getJsonVal(jsonCatalog, this.altJsonPath)) : null;
        boolean bl = isRefsAndAltsGiven = this.isGiven(refIn) && this.isGiven(refCatalog) && altsIn != null && altsIn.size() > 0 && !altsIn.get(0).equals(".") && altsCatalog != null && altsCatalog.size() > 0 && !altsCatalog.get(0).equals(".");
        if (isRefsAndAltsGiven) {
            boolean isRefAlleleMatch = this.isGiven(refIn) && refIn.equalsIgnoreCase(refCatalog);
            boolean isAltAlleleMatch = this.isGiven(altsIn) && this.isAnyMatchAlts(altsIn, altsCatalog);
            return isRefAlleleMatch && isAltAlleleMatch;
        }
        if (this.isCheckRsidAlso) {
            String rsIdIn = this.isJsonPathOk(jsonIn, this.rsIdJsonPath) ? (String)this.getJsonVal(jsonIn, this.rsIdJsonPath) : null;
            String rsIdOut = this.isJsonPathOk(jsonCatalog, this.rsIdJsonPath) ? (String)this.getJsonVal(jsonCatalog, this.rsIdJsonPath) : null;
            boolean isRsIdMatch = this.isGiven(rsIdIn) && rsIdIn.equalsIgnoreCase(rsIdOut);
            return isRsIdMatch;
        }
        return false;
    }

    boolean isAnyMatchAlts(List<String> altsIn, List<String> altsCatalog) {
        if (altsIn == null || altsCatalog == null || altsIn.size() == 0 || altsCatalog.size() == 0) {
            return false;
        }
        boolean isAMatch = false;
        for (String altIn : altsIn) {
            for (String altCatalog : altsCatalog) {
                if (!altIn.equalsIgnoreCase(altCatalog)) continue;
                isAMatch = true;
            }
        }
        return isAMatch;
    }

    private boolean isJsonPathOk(String json, JsonPath path) {
        try {
            this.getJsonVal(json, path);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Object getJsonVal(String json, JsonPath path) {
        String pathStr = path.getPath();
        if (pathStr.startsWith("$.")) {
            pathStr = pathStr.substring(2);
        }
        Object val = null;
        try {
            val = path.read(json);
        }
        catch (InvalidPathException e) {
            throw new InvalidPathException("Invalid JSON path: could not find key \"" + pathStr + "\" in target JSON: \n" + json);
        }
        return val;
    }

    private boolean isGiven(String s) {
        return s != null && s.trim().length() > 0 && !".".equals(s.trim());
    }

    private boolean isGiven(ArrayList<String> list) {
        if (list == null) {
            return false;
        }
        for (String s : list) {
            if (this.isGiven(s)) continue;
            return false;
        }
        return true;
    }

    public ArrayList<String> toList(JSONArray jsonArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            list.add((String)jsonArray.get(i));
        }
        return list;
    }
}

