/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli.test;

import edu.mayo.cli.CommandLineApp;
import edu.mayo.cli.test.CommandOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.commons.cli.ParseException;

public class CommandTestDriver {
    private static final String COMMAND_NAME_PROP = "command.name";
    private Class commandClass;
    private String scriptName;

    public CommandTestDriver(Class commandClass) throws IOException, ParseException {
        this.commandClass = commandClass;
        this.scriptName = this.lookupScriptName();
    }

    private String lookupScriptName() throws IOException, ParseException {
        String classpathLocation = String.format("/cli/%s.properties", this.commandClass.getSimpleName());
        InputStream inStream = CommandTestDriver.class.getResourceAsStream(classpathLocation);
        if (inStream == null) {
            throw new FileNotFoundException(String.format("Could not find properties file for command: %s", this.commandClass.getName()));
        }
        Properties props = new Properties();
        props.load(inStream);
        if (!props.containsKey(COMMAND_NAME_PROP)) {
            throw new ParseException(String.format("Properties file for command %s did not contain property %s", this.commandClass.getName(), COMMAND_NAME_PROP));
        }
        return props.getProperty(COMMAND_NAME_PROP);
    }

    public CommandOutput run(String s) throws UnsupportedEncodingException {
        return this.run(s.split(" +"));
    }

    public CommandOutput run(String[] args) throws UnsupportedEncodingException {
        CommandLineApp cmdLineApp = new CommandLineApp();
        cmdLineApp.captureSystemOutAndErrorToStrings();
        int exitCode = cmdLineApp.runApplication(this.commandClass.getName(), this.scriptName, args);
        CommandOutput output = new CommandOutput();
        output.stdout = cmdLineApp.getSystemOutMessages();
        output.stderr = cmdLineApp.getSystemErrorMessages();
        output.exitCode = exitCode;
        return output;
    }
}

