/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli;

import edu.mayo.cli.util.CLIConstants;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;

public class InvalidOptionArgValueException
extends ParseException {
    private static final long serialVersionUID = 1L;
    private Option mOpt;
    private String mValue;
    private boolean mIsPrintOptionName = true;

    public InvalidOptionArgValueException(Option opt, String value) {
        this(opt, value, "", true);
    }

    public InvalidOptionArgValueException(Option opt, String value, String mesg) {
        this(opt, value, mesg, true);
    }

    public InvalidOptionArgValueException(Option opt, String value, String mesg, boolean isPrintOptionName) {
        super(mesg);
        this.mOpt = opt;
        this.mValue = value;
        this.mIsPrintOptionName = isPrintOptionName;
    }

    public Option getOption() {
        return this.mOpt;
    }

    public String getInvalidValue() {
        return this.mValue;
    }

    public String getMessage() {
        StringBuilder msg = new StringBuilder();
        if (this.mIsPrintOptionName) {
            msg.append("Invalid value specified for option: --" + this.mOpt.getLongOpt() + " " + this.mValue + CLIConstants.NEW_LINE);
        }
        if (super.getMessage().length() > 0) {
            msg.append(super.getMessage());
        }
        return msg.toString();
    }
}

