/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.sideeffect;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import java.util.HashMap;
import java.util.Map;

public class GroupCountPipe<S>
extends AbstractPipe<S, S>
implements SideEffectPipe<S, Map<S, Number>> {
    private Map<S, Number> countMap;

    public GroupCountPipe(Map<S, Number> countMap) {
        this.countMap = countMap;
    }

    public GroupCountPipe() {
        this.countMap = new HashMap<S, Number>();
    }

    @Override
    protected S processNextStart() {
        Object s = this.starts.next();
        this.updateMap(s);
        return (S)s;
    }

    @Override
    public Map<S, Number> getSideEffect() {
        return this.countMap;
    }

    private void updateMap(S s) {
        Number temp = this.countMap.get(s);
        if (null == temp) {
            this.countMap.put(s, 1L);
        } else {
            this.countMap.put(s, 1L + temp.longValue());
        }
    }

    @Override
    public void reset() {
        this.countMap = new HashMap<S, Number>();
        super.reset();
    }
}

