/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.fileIterator.LineFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;

public class SnpEffCmdTest
extends SnpEff {
    String vcfFile;
    int testNum;

    @Override
    public void parseArgs(String[] args) {
        if (args.length != 2) {
            this.usage("Missing file.vcf");
        }
        this.testNum = Gpr.parseIntSafe(args[0]);
        this.vcfFile = args[1];
    }

    @Override
    public boolean run() {
        Timer.showStdErr("Test " + this.testNum + " : Start");
        String testType = "";
        switch (this.testNum) {
            case 1: {
                testType = "VcfFileIterator";
                VcfFileIterator vcfFileIterator = new VcfFileIterator(this.vcfFile);
                for (VcfEntry vcfEntry : vcfFileIterator) {
                    System.out.println(vcfEntry);
                }
                break;
            }
            case 2: {
                testType = "LineFileIterator";
                LineFileIterator lfi = new LineFileIterator(this.vcfFile);
                for (String line : lfi) {
                    System.out.println(line);
                }
                break;
            }
            case 3: {
                testType = "VcfFileIterator, no output";
                VcfFileIterator vcfFileIterator = new VcfFileIterator(this.vcfFile);
                long s = 0L;
                for (VcfEntry vcfEntry : vcfFileIterator) {
                    s += (long)vcfEntry.getStart();
                }
                Gpr.debug("Meaningless calculation: " + s);
                break;
            }
            case 4: {
                testType = "Print, no read";
                VcfFileIterator vcfFileIterator = new VcfFileIterator(this.vcfFile);
                VcfEntry vcfEntry = (VcfEntry)vcfFileIterator.next();
                for (int i = 0; i < 1000000; ++i) {
                    System.out.println(vcfEntry);
                }
                vcfFileIterator.close();
                break;
            }
            default: {
                this.usage("Unknown test " + this.testNum);
            }
        }
        Timer.showStdErr("Test " + testType + " : End");
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version SnpEff 3.1h (build 2012-12-04), by Pablo Cingolani");
        System.err.println("Usage: snpEff test testNumber file.vcf");
        System.exit(-1);
    }
}

