/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSymbolList
extends AbstractChangeable
implements SymbolList {
    private volatile int hashCode = 0;

    protected AbstractSymbolList() {
    }

    @Override
    public Iterator<Symbol> iterator() {
        return new SymbolIterator(1, this.length());
    }

    @Override
    public SymbolList subList(int start, int end) {
        if (start < 1 || end > this.length()) {
            throw new IndexOutOfBoundsException("Sublist index out of bounds " + this.length() + ":" + start + "," + end);
        }
        if (end < start) {
            throw new IllegalArgumentException("end must not be lower than start: start=" + start + ", end=" + end);
        }
        return new SubList(start, end);
    }

    @Override
    public List<Symbol> toList() {
        return new ListView<Symbol>(this);
    }

    @Override
    public String seqString() {
        try {
            SymbolTokenization toke = this.getAlphabet().getTokenization("default");
            return toke.tokenizeSymbolList(this);
        }
        catch (BioException ex) {
            throw new BioRuntimeException("Couldn't tokenize sequence", ex);
        }
    }

    @Override
    public String subStr(int start, int end) {
        return this.subList(start, end).seqString();
    }

    @Override
    public void edit(Edit edit) throws IllegalAlphabetException, ChangeVetoException {
        throw new ChangeVetoException("AbstractSymbolList is immutable");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof SymbolList)) {
            return false;
        }
        return this.compare(this, (SymbolList)o);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            Iterator<Symbol> i = this.iterator();
            while (i.hasNext()) {
                result = 37 * result + i.next().hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        return super.toString() + " length: " + this.length();
    }

    private boolean compare(SymbolList sl1, SymbolList sl2) {
        if (!sl1.getAlphabet().equals(sl2.getAlphabet())) {
            return false;
        }
        if (sl1.length() != sl2.length()) {
            return false;
        }
        Iterator<Symbol> si1 = sl1.iterator();
        Iterator<Symbol> si2 = sl2.iterator();
        while (si1.hasNext()) {
            if (si1.next() == si2.next()) continue;
            return false;
        }
        return true;
    }

    public class EditTranslater
    extends EditScreener {
        public EditTranslater(Object source, ChangeSupport cs, int min, int max) {
            super(source, cs, min, max);
        }

        protected ChangeEvent generateEvent(ChangeEvent ce) {
            if ((ce = super.generateEvent(ce)) != null) {
                Edit edit = (Edit)ce.getChange();
                return new ChangeEvent(ce.getSource(), ce.getType(), new Edit(edit.pos - this.min, edit.length, edit.replacement), null, ce.getChainedEvent());
            }
            return null;
        }
    }

    public class EditScreener
    extends ChangeForwarder {
        protected final int min;
        protected final int max;

        public EditScreener(Object source, ChangeSupport cs, int min, int max) {
            super(source, cs);
            this.min = min;
            this.max = max;
        }

        protected ChangeEvent generateEvent(ChangeEvent ce) {
            Object change;
            ChangeType ct = ce.getType();
            if (ct == SymbolList.EDIT && (change = ce.getChange()) != null && change instanceof Edit) {
                Edit edit = (Edit)change;
                int start = edit.pos;
                int end = start + edit.length - 1;
                if (start <= this.max && end >= this.min) {
                    return new ChangeEvent(this.getSource(), ct, edit, null, ce);
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListView<T extends Symbol>
    extends AbstractList<T>
    implements Serializable {
        private static final long serialVersionUID = 1481437420273354153L;
        private SymbolList rl;

        ListView(SymbolList symList) {
            this.rl = symList;
        }

        @Override
        public T get(int pos) {
            return (T)this.rl.symbolAt(pos + 1);
        }

        @Override
        public int size() {
            return this.rl.length();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubList<T extends Symbol>
    extends AbstractChangeable
    implements SymbolList,
    Serializable {
        private static final long serialVersionUID = -4299952037536894744L;
        private int start;
        private int end;
        private transient EditTranslater editTranslater = null;
        private transient ChangeForwarder annotationForwarder = null;
        private volatile int hashCode = 0;

        public SubList(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public Alphabet getAlphabet() {
            return AbstractSymbolList.this.getAlphabet();
        }

        @Override
        public Iterator<Symbol> iterator() {
            return new SymbolIterator(this.start, this.end);
        }

        @Override
        public int length() {
            return this.end - this.start + 1;
        }

        @Override
        public Symbol symbolAt(int pos) {
            if (pos < 1 || pos > this.length()) {
                throw new IndexOutOfBoundsException("Symbol index out of bounds " + this.length() + ":" + pos);
            }
            return AbstractSymbolList.this.symbolAt(pos + this.start - 1);
        }

        @Override
        public SymbolList subList(int sstart, int send) {
            if (sstart < 1 || send > this.length()) {
                throw new IndexOutOfBoundsException("Sublist index out of bounds " + this.length() + ":" + sstart + "," + send);
            }
            if (send < sstart) {
                throw new IndexOutOfBoundsException("Requested end must not be lower than start: start=" + sstart + ", end=" + send);
            }
            return new SubList<T>(sstart + this.start - 1, send + this.start - 1);
        }

        @Override
        public String seqString() {
            try {
                SymbolTokenization toke = this.getAlphabet().getTokenization("token");
                return toke.tokenizeSymbolList(this);
            }
            catch (BioException ex) {
                throw new BioRuntimeException("Couldn't tokenize sequence", ex);
            }
        }

        @Override
        public String subStr(int start, int end) {
            return this.subList(start, end).seqString();
        }

        @Override
        public List<Symbol> toList() {
            return new ListView<Symbol>(this);
        }

        @Override
        public void edit(Edit edit) throws IllegalAlphabetException, ChangeVetoException {
            AbstractSymbolList.this.edit(new Edit(edit.pos + this.start - 1, edit.length, edit.replacement));
        }

        @Override
        protected ChangeSupport getChangeSupport(ChangeType changeType) {
            ChangeSupport cs = super.getChangeSupport(changeType);
            if ((SymbolList.EDIT.isMatchingType(changeType) || changeType.isMatchingType(SymbolList.EDIT)) && this.editTranslater == null) {
                this.editTranslater = new EditTranslater(this, cs, this.start, this.end);
                AbstractSymbolList.this.addChangeListener(this.editTranslater, SymbolList.EDIT);
            }
            if ((changeType == null || changeType == Annotation.PROPERTY) && this.annotationForwarder == null) {
                this.annotationForwarder = new ChangeForwarder.Retyper(this, cs, Annotation.PROPERTY);
                AbstractSymbolList.this.addChangeListener(this.annotationForwarder, Annotation.PROPERTY);
            }
            return cs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof SymbolList)) {
                return false;
            }
            return AbstractSymbolList.this.compare(this, (SymbolList)o);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                Iterator<Symbol> i = this.iterator();
                while (i.hasNext()) {
                    result = 37 * result + i.next().hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }

        public String toString() {
            return super.toString() + " start: " + this.start + " end: " + this.end;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SymbolIterator
    implements Iterator<Symbol>,
    Serializable {
        private static final long serialVersionUID = -8542733313998842964L;
        private int max;
        private int pos;

        public SymbolIterator(int min, int max) {
            this.max = max;
            this.pos = min;
        }

        @Override
        public boolean hasNext() {
            return this.pos <= this.max;
        }

        @Override
        public Symbol next() {
            if (this.pos > this.max) {
                throw new NoSuchElementException();
            }
            return AbstractSymbolList.this.symbolAt(this.pos++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

