/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game12;

import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game12.GAMESeqRelHandler;
import org.biojava.bio.seq.io.game12.StAXFeatureHandler;
import org.biojava.bio.seq.io.game12.StAXHandlerFactory;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GAMEFeatureSpanHandler
extends StAXFeatureHandler {
    private String featureSpanId;
    String featureSpanType;
    Location featureSpanLoc;
    StrandedFeature.Strand featureSpanStrand;
    private StrandedFeature.Template template;
    public static final StAXHandlerFactory GAME_FEATURE_SPAN_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new GAMEFeatureSpanHandler(staxenv);
        }
    };

    GAMEFeatureSpanHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        super.addHandler(new ElementRecognizer.ByLocalName("name"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new NameHandler();
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("type"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new TypeHandler();
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("seq_relationship"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new SeqRelHandler(staxenv);
            }
        });
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        this.featureSpanId = attrs.getValue("id");
        try {
            this.template = new StrandedFeature.Template();
            this.template.annotation = new SimpleAnnotation();
            this.template.source = null;
            try {
                if (this.featureSpanId != null) {
                    this.template.annotation.setProperty("id", this.featureSpanId);
                }
            }
            catch (ChangeVetoException cve) {
                throw new SAXException("unexpected ChangeVetoException when setting id!");
            }
            this.listener.startFeature(this.template);
        }
        catch (ParseException pe) {
            // empty catch block
        }
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler contentHandler) throws SAXException {
        if (!this.featureSpanType.equals("exon") && !this.featureSpanType.equals("translate offset")) {
            System.err.println("<feature_span> of unexpected type " + this.featureSpanType);
        }
        this.template.type = this.featureSpanType;
        this.template.source = "";
        this.template.location = this.featureSpanLoc;
        this.template.strand = this.featureSpanStrand;
        try {
            this.listener.endFeature();
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new SAXException("error in GAMEFeatureSetHandler.");
        }
    }

    private class TypeHandler
    extends StringElementHandlerBase {
        private TypeHandler() {
        }

        protected void setStringValue(String s) {
            GAMEFeatureSpanHandler.this.featureSpanType = s.trim();
        }
    }

    private class NameHandler
    extends StringElementHandlerBase {
        private NameHandler() {
        }

        protected void setStringValue(String s) {
        }
    }

    public class SeqRelHandler
    extends GAMESeqRelHandler {
        private SeqRelHandler(StAXFeatureHandler staxenv) {
            super(staxenv);
        }

        public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler contentHandler) throws SAXException {
            super.endElementHandler(nsURI, localName, qName, contentHandler);
            GAMEFeatureSpanHandler.this.featureSpanLoc = this.seqRelLoc;
            GAMEFeatureSpanHandler.this.featureSpanStrand = this.seqRelStrand;
        }
    }
}

