/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileExistsException;

public class ColumnMetaData
implements Comparable<ColumnMetaData> {
    public String columnName = "";
    public Type type = Type.String;
    public String count = "";
    public String description = "";
    private static final String DEFAULT_HUMAN_READABLE_NAME = "";
    public String humanReadableName = "";

    public ColumnMetaData(String colName) {
        this.columnName = colName;
    }

    public ColumnMetaData() {
    }

    public ColumnMetaData(String colName, String type, String count, String desc) {
        Type cast = Type.valueOf("String");
        try {
            cast = Type.valueOf(type);
        }
        catch (Exception e) {
            cast = Type.valueOf("String");
        }
        this.init(colName, cast, count, desc, DEFAULT_HUMAN_READABLE_NAME);
    }

    public ColumnMetaData(String colName, String type, String count, String desc, String humanReadableName) {
        Type cast = Type.valueOf("String");
        try {
            cast = Type.valueOf(type);
        }
        catch (Exception e) {
            cast = Type.valueOf("String");
        }
        this.init(colName, cast, count, desc, humanReadableName);
    }

    public ColumnMetaData(String colName, Type type, String count, String desc) {
        this.init(colName, type, count, desc, DEFAULT_HUMAN_READABLE_NAME);
    }

    public ColumnMetaData(String colName, Type type, String count, String desc, String humanReadableName) {
        this.init(colName, type, count, desc, humanReadableName);
    }

    private void init(String colName, Type type, String count, String desc, String humanReadableName) {
        this.columnName = colName;
        this.type = type;
        this.count = count;
        this.description = desc;
        this.humanReadableName = humanReadableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public static void saveMetaData(String columnsTsvPath, List<ColumnMetaData> colMetaList) throws IOException {
        StringBuilder desc = new StringBuilder();
        desc.append("##-----------------------------------------------------\n");
        desc.append("## Catalog field definitions\n");
        desc.append("##-----------------------------------------------------\n");
        desc.append("## ColumnName=The key or column name\n");
        desc.append("## Type=The type of the object, as can be determined from parsing the VCF file or taking and educated guess based on the catalog values (Possible values: JSON, JSONArray, String, Integer, Float, Boolean)\n");
        desc.append("## Count=The number of values that repeatedly occur  (Possible values: 0 (Boolean), 1,2,..,n  or '.' for variable or unknown number of values\n");
        desc.append("## Description=The description of the ColumnName\n");
        desc.append("##-----------------------------------------------------\n");
        desc.append("#ColumnName\tType\tCount\tDescription\n");
        File columnsTsvFile = new File(columnsTsvPath);
        if (columnsTsvFile.exists()) {
            throw new FileExistsException(columnsTsvFile);
        }
        FileOutputStream fout = new FileOutputStream(new File(columnsTsvPath));
        fout.write((desc.toString() + "\n").getBytes());
        for (ColumnMetaData colMeta : colMetaList) {
            fout.write((colMeta.toString() + "\n").getBytes());
        }
        fout.close();
    }

    public String toString() {
        return this.columnName + "\t" + this.type.toString() + "\t" + this.count + "\t" + this.description;
    }

    public static List<ColumnMetaData> merge(List<ColumnMetaData> colMetaListMain, List<ColumnMetaData> colMetaListAdditional) {
        HashSet<String> colNamesAlreadyAdded = new HashSet<String>();
        ArrayList<ColumnMetaData> mergedList = new ArrayList<ColumnMetaData>();
        for (ColumnMetaData colMeta : colMetaListMain) {
            mergedList.add(colMeta);
            colNamesAlreadyAdded.add(colMeta.columnName);
        }
        for (ColumnMetaData colMeta : colMetaListAdditional) {
            if (colNamesAlreadyAdded.contains(colMeta.columnName)) continue;
            mergedList.add(colMeta);
            colNamesAlreadyAdded.add(colMeta.columnName);
        }
        return mergedList;
    }

    public static HashMap<String, ColumnMetaData> parseColumnProperties(String columnPropertiesPath) throws IOException {
        String line;
        HashMap<String, ColumnMetaData> colMetaMap = new HashMap<String, ColumnMetaData>();
        BufferedReader bReader = new BufferedReader(new FileReader(columnPropertiesPath));
        while ((line = bReader.readLine()) != null) {
            if (line.startsWith("#") || line.trim().length() == 0) continue;
            String[] split = line.split("\t");
            String key = split[0].trim();
            String type = split.length > 1 ? split[1].trim() : Type.String.toString();
            String count = split.length > 2 ? split[2].trim() : ".";
            String desc = split.length > 3 ? split[3].trim() : DEFAULT_HUMAN_READABLE_NAME;
            String human = split.length > 4 ? split[4].trim() : DEFAULT_HUMAN_READABLE_NAME;
            ColumnMetaData colMeta = new ColumnMetaData(key, type, count, desc, human);
            colMetaMap.put(key, colMeta);
        }
        return colMetaMap;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getCount() {
        return this.count;
    }

    public void setCount(String count) {
        this.count = count;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHumanReadableName() {
        return this.humanReadableName;
    }

    public void setHumanReadableName(String humanReadableName) {
        this.humanReadableName = humanReadableName;
    }

    @Override
    public int compareTo(ColumnMetaData other) {
        return this.columnName.compareToIgnoreCase(other.columnName);
    }

    public static enum Type {
        JSON,
        String,
        Float,
        Integer,
        Boolean;

    }

    public static enum PropertiesFileHeaders {
        ColumnName,
        Type,
        Count,
        Description;

    }
}

