/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.tabix;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.JSON.tabix.TabixWriter;
import edu.mayo.pipes.history.History;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import net.sf.samtools.util.BlockCompressedOutputStream;

public class BgzipWriter
extends AbstractPipe<History, History> {
    private String mBgzipOutFilePath;
    private BlockCompressedOutputStream mBgzipOutStream;
    private boolean mIsCreateTabix = true;

    public BgzipWriter(String bgzipOutFilePath, boolean isCreateTabix) {
        this.mBgzipOutFilePath = bgzipOutFilePath;
        this.mBgzipOutStream = new BlockCompressedOutputStream(bgzipOutFilePath, 9);
        this.mIsCreateTabix = isCreateTabix;
    }

    protected History processNextStart() throws NoSuchElementException {
        try {
            if (!this.starts.hasNext()) {
                this.mBgzipOutStream.close();
                if (this.mIsCreateTabix) {
                    this.createTabixFile();
                }
                throw new NoSuchElementException("No more data");
            }
            History nextLine = (History)this.starts.next();
            this.mBgzipOutStream.write((this.merge(nextLine) + "\n").getBytes());
            return nextLine;
        }
        catch (NoSuchElementException noSuchExc) {
            throw new NoSuchElementException("No more data");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NoSuchElementException("Error writing to bgzip file");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoSuchElementException("Error creating tabix file");
        }
    }

    private void createTabixFile() throws Exception {
        File bgzipOutFile = new File(this.mBgzipOutFilePath);
        TabixWriter tabixWriter = new TabixWriter(bgzipOutFile, TabixWriter.VCF_CONF);
        tabixWriter.createIndex(bgzipOutFile);
    }

    private String merge(History history) {
        StringBuilder strBuilder = new StringBuilder();
        for (String col : history) {
            strBuilder.append(col + "\t");
        }
        String str = strBuilder.toString();
        if (str.endsWith("\t")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

