/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.createcatalog;

import com.google.code.externalsorting.ExternalSort;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.pipeline.createcatalog.TjsonToCatalogPipe;
import edu.mayo.pipes.JSON.tabix.BgzipWriter;
import edu.mayo.pipes.MergePipe;
import edu.mayo.pipes.String2HistoryPipe;
import edu.mayo.pipes.UNIX.CatAnythingPipe;
import edu.mayo.pipes.WritePipe;
import edu.mayo.pipes.util.GenomicObjectUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TjsonToCatalog {
    private static final Logger sLogger = Logger.getLogger(TjsonToCatalog.class);
    protected String[] mUserChromList = new String[0];
    protected String[] mHumanChromList = new String[0];

    public void createCatalog(String inputFile, String bgzipCatalogOutFile, boolean isSort, String chromSortOrderFilePath, int jsonCol, boolean isJsonOnly, String tempDirectory, BuildAssembly buildAssembly, boolean isModifyChrom) throws IOException {
        boolean isCreateTabixIndex = !isJsonOnly;
        sLogger.info((Object)("Create catalog\n    inputFile: " + inputFile + "\n    bgzipCatalogOutFile: " + bgzipCatalogOutFile + "\n    chromSortOrderFilePath: " + chromSortOrderFilePath + "\n    isSort: " + isSort + "\n    jsonCol: " + jsonCol + "\n    isJsonOnly: " + isJsonOnly + "\n    tempDirectory: " + tempDirectory + "\n    buildAssembly: " + (Object)((Object)buildAssembly) + "\n    isModifyChrom: " + isModifyChrom));
        if (isSort) {
            sLogger.info((Object)"Sort file: write to a temp file first, split that into multiple files which are then sorted and merged back into one, then bgzip the result and add tabix index if it is not just a JSON-only catalog");
            File tempDir = tempDirectory == null ? null : new File(tempDirectory);
            File tempFile = File.createTempFile("myTempFileToSort", ".tmp", tempDir);
            tempFile.deleteOnExit();
            this.writeCatalogLines(inputFile, tempFile.getCanonicalPath(), false, false, jsonCol, isJsonOnly, isModifyChrom);
            this.sortByChrom(tempFile, chromSortOrderFilePath, buildAssembly);
            this.writeBgzipFile(tempFile.getCanonicalPath(), bgzipCatalogOutFile, isCreateTabixIndex);
        } else {
            sLogger.info((Object)"Write directly to the bgzip catalog file and apply tabix index after (if not a JSON_only catalog)");
            this.writeCatalogLines(inputFile, bgzipCatalogOutFile, true, isCreateTabixIndex, jsonCol, isJsonOnly, isModifyChrom);
        }
        sLogger.info((Object)"Done building catalog");
    }

    protected void writeCatalogLines(String inputFile, String outputFile, boolean isBgzipOut, boolean isCreateTabixIndex, int jsonCol, boolean isJsonOnly, boolean isModifyChrom) {
        sLogger.info((Object)("Writing catalog format to a temp file: " + outputFile));
        String inputFileType = inputFile.endsWith(".gz") || inputFile.endsWith(".bgz") ? "gzip" : "text";
        BgzipWriter outputWriter = isBgzipOut ? new BgzipWriter(outputFile, isCreateTabixIndex) : new Pipeline(new Pipe[]{new MergePipe("\t"), new WritePipe(outputFile, false, true)});
        Pipeline pipeline = new Pipeline(new Pipe[]{new CatAnythingPipe(inputFileType), new String2HistoryPipe("\t"), new TjsonToCatalogPipe(jsonCol, isJsonOnly, isModifyChrom), outputWriter});
        pipeline.setStarts(Arrays.asList(inputFile));
        int numLinesWritten = 0;
        while (pipeline.hasNext()) {
            pipeline.next();
            if (++numLinesWritten % 10000 != 0) continue;
            sLogger.info((Object)("Num lines written to catalog format: " + numLinesWritten));
        }
    }

    protected void writeBgzipFile(String inputFile, String bgzipOutputFile, boolean isCreateTabixIndex) {
        sLogger.info((Object)"Write input file to a bgzip catalog");
        String inputFileType = inputFile.endsWith(".gz") || inputFile.endsWith(".bgz") ? "gzip" : "text";
        Pipeline pipeline = new Pipeline(new Pipe[]{new CatAnythingPipe(inputFileType), new String2HistoryPipe("\t"), new BgzipWriter(bgzipOutputFile, isCreateTabixIndex)});
        pipeline.setStarts(Arrays.asList(inputFile));
        while (pipeline.hasNext()) {
            pipeline.next();
        }
    }

    protected void sortByChrom(File tempInputFile, String chromSortOrderTextFile, BuildAssembly buildAssembly) throws IOException {
        sLogger.info((Object)"Load user and human chromosome files");
        this.loadUserChromList(chromSortOrderTextFile);
        this.loadHumanChromList(buildAssembly);
        Comparator<String> lineComparator = this.getLineComparator();
        File tempDir = tempInputFile.getParentFile();
        sLogger.info((Object)"Break the input file up into multiples and sort, then merge them");
        sLogger.info((Object)("Input file: " + tempInputFile.getCanonicalPath() + "   " + tempInputFile.length() + " bytes"));
        List sortedPartialFiles = ExternalSort.sortInBatch((File)tempInputFile, lineComparator, (int)1024, (Charset)Charset.defaultCharset(), (File)tempDir, (boolean)false);
        sLogger.info((Object)("Sorted temp files: " + sortedPartialFiles.size()));
        for (File f : sortedPartialFiles) {
            sLogger.info((Object)("  " + f.getCanonicalPath() + "   " + f.length() + " bytes"));
        }
        this.deleteAllFilesOnExit(sortedPartialFiles);
        sLogger.info((Object)"Merge all sorted files back into one");
        ExternalSort.mergeSortedFiles((List)sortedPartialFiles, (File)tempInputFile, lineComparator);
        sLogger.info((Object)("Merged file: " + tempInputFile.getCanonicalPath() + "   " + tempInputFile.length() + " bytes"));
    }

    private void deleteAllFilesOnExit(List<File> filesToDelete) {
        for (File f : filesToDelete) {
            f.deleteOnExit();
        }
    }

    protected int compareLines(String line1, String line2) {
        try {
            Long maxBP2;
            Long minBP2;
            int score2;
            String[] colsLine1 = line1.split("\t");
            String[] colsLine2 = line2.split("\t");
            if (line1.startsWith("#") || line2.startsWith("#")) {
                Integer iLine1 = new Integer(this.getHeaderScore(line1));
                Integer iLine2 = new Integer(this.getHeaderScore(line2));
                return iLine1.compareTo(iLine2);
            }
            if (colsLine1.length < 4 || colsLine2.length < 4) {
                return line1.compareToIgnoreCase(line2);
            }
            String chr1Lower = colsLine1[0].toLowerCase();
            String chr2Lower = colsLine2[0].toLowerCase();
            int score1 = this.getChromScore(chr1Lower);
            if (score1 != (score2 = this.getChromScore(chr2Lower))) {
                return score1 - score2;
            }
            int stringCompareScore = chr1Lower.compareToIgnoreCase(chr2Lower);
            if (stringCompareScore != 0) {
                return stringCompareScore;
            }
            Long minBP1 = Long.parseLong(colsLine1[1]);
            int minBpScore = minBP1.compareTo(minBP2 = Long.valueOf(Long.parseLong(colsLine2[1])));
            if (minBpScore != 0) {
                return minBpScore;
            }
            Long maxBP1 = Long.parseLong(colsLine1[2]);
            int maxBpScore = maxBP1.compareTo(maxBP2 = Long.valueOf(Long.parseLong(colsLine2[2])));
            if (maxBpScore != 0) {
                return maxBpScore;
            }
            return line1.compareToIgnoreCase(line2);
        }
        catch (Exception e) {
            System.err.println("Error comparing two lines:");
            System.err.println("  1) " + line1);
            System.err.println("  2) " + line2);
            return 0;
        }
    }

    protected int getHeaderScore(String line) {
        if (line.startsWith("##")) {
            return 0;
        }
        if (line.startsWith("#")) {
            return 1;
        }
        return 2;
    }

    protected int getChromScore(String chromIn) {
        String chrom = GenomicObjectUtils.computechr((String)chromIn);
        String chromLower = chrom.toLowerCase();
        int score = 0;
        score = this.isInList(chrom, this.mUserChromList) ? this.idxInList(chrom, this.mUserChromList) : (this.isInList(chrom, this.mHumanChromList) ? 1000 + this.idxInList(chrom, this.mHumanChromList) : (this.isInteger(chrom) ? 2000 + Integer.parseInt(chrom) : (StringUtils.isAlphanumeric((String)chrom) && !chromLower.equals("unknown") ? 3000 : (chromLower.contains("random") ? (this.isStartsWithInteger(chrom) ? 4000 + this.getIntegerPrefix(chrom) : 5000) : (!chromLower.equals("unknown") && (chromLower.contains("unknown") || chromLower.startsWith("un_")) ? 6000 : (this.isStartsWithInteger(chrom) ? 7000 + this.getIntegerPrefix(chrom) : (!chromLower.equals("unknown") ? 8000 : 9000)))))));
        return score;
    }

    protected boolean isStartsWithInteger(String s) {
        Integer i = this.getIntegerPrefix(s);
        return i != null;
    }

    protected Integer getIntegerPrefix(String s) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < s.length() && Character.isDigit(s.charAt(i)); ++i) {
            str.append(s.charAt(i));
        }
        if (str.length() == 0) {
            return null;
        }
        return Integer.parseInt(str.toString());
    }

    protected boolean isInteger(String chrom) {
        try {
            Integer.parseInt(chrom);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected int idxInList(String chrom, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            String chromInList = GenomicObjectUtils.computechr((String)list[i]);
            if (!chrom.equalsIgnoreCase(chromInList)) continue;
            return i;
        }
        return -1;
    }

    protected boolean isInList(String chrom, String[] list) {
        return this.idxInList(chrom, list) != -1;
    }

    protected String[] loadUserChromList(String chromosomeListFile) throws IOException {
        File chromListFile;
        if (chromosomeListFile != null && (chromListFile = new File(chromosomeListFile)).exists()) {
            this.mUserChromList = FileUtils.readLines((File)chromListFile).toArray(new String[0]);
        }
        return this.mUserChromList;
    }

    protected String[] loadHumanChromList(BuildAssembly buildAssembly) throws IOException {
        String fileRelativePath = "humanChromosomesSortedByName.GRCh37.txt";
        if (buildAssembly.equals((Object)BuildAssembly.GRCh38)) {
            fileRelativePath = "humanChromosomesSortedByName.GRCh38.txt";
        }
        File file = new File(this.getClass().getClassLoader().getResource(fileRelativePath).getPath());
        this.mHumanChromList = FileUtils.readLines((File)file).toArray(new String[0]);
        return this.mHumanChromList;
    }

    protected Comparator<String> getLineComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String line1, String line2) {
                return TjsonToCatalog.this.compareLines(line1, line2);
            }
        };
    }

    public static enum BuildAssembly {
        GRCh37,
        GRCh38;

    }
}

