/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.bior.pipeline.ModBool;
import edu.mayo.bior.util.BioR;
import edu.mayo.genomicutils.refassembly.AssemblyNotSupportedException;
import edu.mayo.genomicutils.refassembly.RefAssemblyFinder;
import edu.mayo.genomicutils.refassembly.RefBasePairLookup;
import edu.mayo.pipes.JSON.lookup.LookupPipe;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryMetaData;
import edu.mayo.senders.Sender;
import edu.mayo.senders.SystemOutSender;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class Variant2JSONPipe
extends AbstractPipe<History, History> {
    private LookupPipe rsIDLookup;
    private RefBasePairLookup genome;
    protected String genomeBuild;
    private Sender sender;
    private int dataLineNumber = 0;
    private boolean dumpWarnings = false;
    private int warningCount = 0;
    private int errorCount = 0;
    private int identifierCol = -1;
    private int allele1Col = -1;
    private int allele2Col = -1;
    private int chromosomeCol = -1;
    private int positionCol = -1;
    private int allCol = -1;
    private int posCols = -1;
    private int headerSize = 0;
    private List<History> mResults = null;
    private boolean mInitialized = false;
    private static String catalogPath = Variant2JSONPipe.calcCatalogPath();
    private static String genomeBasePath = catalogPath + "/ref_assembly";
    private static final JsonPath chromPath = JsonPath.compile((String)"CHROM", (Filter[])new Filter[0]);
    private static final JsonPath posPath = JsonPath.compile((String)"POS", (Filter[])new Filter[0]);
    private static final int kIdentifierCol = 0;
    private static final int kChromosomeCol = 1;
    private static final int kPositionCol = 2;
    private static final int kAllele1Col = 3;
    private static final int kAllele2Col = 4;
    private static final String kRsIDStart = "rs";
    private static final int kRsIDStartLen = "rs".length();
    private static final String kColDelimiter = "\t";
    private static final String kGenomeBuildDefault = "GRCh37";
    private static final String kDocumentBase = "/data5/bsi/catalogs/bior/v1";
    private static final String kWarning = "WARNING";
    private static final String kError = "ERROR";
    private static final int kWarningLen = "WARNING".length();
    private static final int kErrorLen = "ERROR".length();
    private static final String kNoRSIDFoundWarning = "No match found for ";
    private static final String kMalformedRSIDError = " is not a valid rsID";
    public static final String kPositionMatchFailedWarning = "The rsID found has a different position than was specified";
    public static final String kFlipAllelesWarning = "Neither of the alleles supplied matched the reference, so swapped strands";
    private static final String[] kBases = new String[]{"A", "C", "G", "T"};
    private static final boolean kReturnBlanks = false;
    protected static final boolean kRemoveBlanks = true;
    private static final String[] kColumnNames = new String[]{"ID", "CHROM", "POS", "ALLELE1", "ALLELE2"};
    private static final String[] kChromosomeLetters = new String[]{"X", "Y", "XY", "M", "MT"};
    protected static final int[] kChromosomeNumbers = new int[]{23, 24, 25, 26, 26};
    private static final int kMinChromosome = 1;
    private static final int kFirstChangeChromosome = 23;
    private static final int kNumChangeChromosome = kChromosomeNumbers.length;
    private static final int kMaxChromosome = 26;
    public static final String kNoHeader = "Must have a tab delimited header as the first non '#' line of input";
    public static final String kBadHeader = "Can not have a header that has only the chromosome or only the position";
    private static final String kVCFEmpty = ".";
    private static final String kChrErrorJSON1 = "{\"ERROR\":\"Chromosome '";
    private static final String kChrErrorJSON2 = "' is not valid\"}";
    private static final String kPosErrorJSON1 = "{\"ERROR\":\"Invalid position '";
    private static final String kPosErrorJSON2 = "'\"}";
    private static final String kChrPosErrorJSON1 = "{\"ERROR\":\"Chromosome '";
    private static final String kChrPosErrorJSON2 = "', position '";
    private static final String kChrPosErrorJSON3 = "' is not valid\"}";
    private static final String kAlleleErrorJSON1 = "{\"ERROR\":\"Invalid allele '";
    private static final String kAlleleErrorJSON2 = "'\"}";
    private static final String kInvalidChrPos = ".";

    public Variant2JSONPipe(LookupPipe rsIDLookup, Sender sender) {
        this(rsIDLookup, sender, kGenomeBuildDefault);
    }

    public Variant2JSONPipe(LookupPipe rsIDLookup, Sender sender, String genomeBuild) {
        this.rsIDLookup = rsIDLookup;
        this.genomeBuild = Variant2JSONPipe.isEmpty(genomeBuild) ? kGenomeBuildDefault : genomeBuild;
        if (sender != null) {
            this.sender = sender;
            this.dumpWarnings = true;
        } else {
            this.sender = new SystemOutSender("stderr");
        }
    }

    public static String getCatalogPath() {
        return catalogPath;
    }

    private static String calcCatalogPath() {
        String path = System.getenv("BIOR_CATALOG");
        if (path == null) {
            BioR.report("BIOR_CATALOG was null");
        } else {
            BioR.report("BIOR_CATALOG was " + path);
        }
        if (path != null) {
            return path;
        }
        return kDocumentBase;
    }

    protected History getHistory() {
        if (this.mInitialized) {
            return (History)this.starts.next();
        }
        History history = (History)this.starts.next();
        ArrayList<String> headerRows = new ArrayList<String>();
        String line = history.getMergedData(kColDelimiter);
        while (line.startsWith("#")) {
            headerRows.add(line);
            if (this.starts.hasNext()) {
                history = (History)this.starts.next();
                line = history.getMergedData(kColDelimiter);
                continue;
            }
            this.initializeMetaData(history, headerRows);
            break;
        }
        this.initializeMetaData(history, headerRows);
        this.mInitialized = true;
        return history;
    }

    private void initializeMetaData(History history, List<String> headerRows) {
        String colHeaderLine;
        HistoryMetaData hMeta = new HistoryMetaData(headerRows);
        int size = headerRows.size();
        if (size > 0 && (colHeaderLine = headerRows.get(size - 1)).startsWith("#")) {
            List columns = hMeta.getColumns();
            colHeaderLine = colHeaderLine.substring(1);
            for (String colName : colHeaderLine.split(kColDelimiter)) {
                ColumnMetaData cmd = new ColumnMetaData(colName);
                columns.add(cmd);
            }
        }
        history.setMetaData(hMeta);
    }

    protected History processNextStart() throws NoSuchElementException {
        int numCols;
        int numAdd;
        History history;
        if (this.mResults != null && !this.mResults.isEmpty()) {
            return this.mResults.remove(0);
        }
        try {
            while (Variant2JSONPipe.isEmpty(history = (History)this.starts.next())) {
            }
        }
        catch (NoSuchElementException done) {
            if (this.dumpWarnings) {
                StringBuilder message = new StringBuilder();
                message.append("Had ");
                message.append(this.warningCount);
                if (this.errorCount > 0) {
                    message.append(" warnings and ");
                    message.append(this.errorCount);
                    message.append(" errors");
                } else {
                    message.append(" warnings");
                }
                this.sender.write(message.toString());
            }
            throw done;
        }
        ++this.dataLineNumber;
        if (this.headerSize == 0) {
            this.getHeaderInformation(history);
        }
        if ((numAdd = this.headerSize - (numCols = history.size())) > 0) {
            for (int i = 0; i < numAdd; ++i) {
                history.add((Object)"");
            }
        }
        if (numCols < this.allCol) {
            String rsID;
            if (numCols > this.posCols) {
                return this.processPosition(history);
            }
            if (numCols > this.identifierCol && Variant2JSONPipe.isRsID(rsID = (String)history.get(this.identifierCol))) {
                return this.processRsID(history, false);
            }
            StringBuilder errorMesg = new StringBuilder();
            errorMesg.append("Invalid variant line at data line # ");
            errorMesg.append(this.dataLineNumber);
            errorMesg.append(".\nThe variant format requires ");
            errorMesg.append(this.allCol + 1);
            errorMesg.append(" fixed fields per data line, but found only ");
            errorMesg.append(numCols);
            errorMesg.append(" field(s).\n");
            errorMesg.append("Make sure the variant file has the necessary fields delimited by TAB characters.\n");
            errorMesg.append("Invalid variant line content: \"");
            errorMesg.append(history.getMergedData(kColDelimiter));
            errorMesg.append("\"");
            this.reportError(errorMesg.toString());
        }
        return this.processPosition(history);
    }

    private void getHeaderInformation(History history) {
        HistoryMetaData metaData = history.getMetaData();
        if (metaData == null) {
            this.reportTerminalError(kNoHeader);
        }
        List columns = metaData.getColumns();
        this.headerSize = columns.size() - 1;
        for (int i = 0; i < this.headerSize; ++i) {
            ColumnMetaData theColumn = (ColumnMetaData)columns.get(i);
            String name = theColumn.columnName.toUpperCase();
            if (name.equals(kColumnNames[1])) {
                this.chromosomeCol = i;
                this.allCol = Math.max(this.allCol, this.chromosomeCol);
                continue;
            }
            if (name.equals(kColumnNames[2])) {
                this.positionCol = i;
                this.posCols = Math.max(this.posCols, this.positionCol);
                this.allCol = Math.max(this.allCol, this.posCols);
                continue;
            }
            if (name.equals(kColumnNames[0])) {
                this.identifierCol = i;
                this.posCols = Math.max(this.posCols, this.identifierCol);
                this.allCol = Math.max(this.allCol, this.posCols);
                continue;
            }
            if (name.equals(kColumnNames[3])) {
                this.allele1Col = i;
                this.allCol = Math.max(this.allCol, this.allele1Col);
                continue;
            }
            if (!name.equals(kColumnNames[4])) continue;
            this.allele2Col = i;
            this.allCol = Math.max(this.allCol, this.allele2Col);
        }
        if (this.allCol < 0) {
            this.reportTerminalError(kNoHeader);
        }
        if (this.chromosomeCol < 0 ^ this.positionCol < 0) {
            this.reportTerminalError(kBadHeader);
        }
    }

    private static final boolean isRsID(String testStr) {
        if (Variant2JSONPipe.isEmpty(testStr)) {
            return false;
        }
        if (!testStr.startsWith(kRsIDStart)) {
            return false;
        }
        try {
            Long.parseLong(testStr.substring(kRsIDStartLen));
            return true;
        }
        catch (NumberFormatException oops) {
            return false;
        }
    }

    private History processRsID(History history, boolean removeBlanks) {
        if (this.identifierCol < 0 || this.identifierCol >= history.size()) {
            throw new InvalidPipeInputException("ERROR: The 'id' header column is missing", (Pipe)this);
        }
        this.mResults = this.rsIDLookup.processHistory(history, this.identifierCol);
        History result = this.mResults.remove(0);
        boolean wasBlank = Variant2JSONPipe.removeBlank(result);
        if (wasBlank) {
            if (removeBlanks) {
                return null;
            }
            String rsID = (String)history.get(this.identifierCol);
            if (Variant2JSONPipe.isRsID(rsID)) {
                result.add((Object)this.addWarning(null, kNoRSIDFoundWarning + rsID));
            } else {
                result.add((Object)this.addError(null, rsID + kMalformedRSIDError));
            }
        }
        return result;
    }

    private History processPosition(History history) {
        History result;
        boolean hasIdentifier;
        boolean hasPosition = this.positionCol >= 0 && this.positionCol < history.size();
        boolean bl = hasIdentifier = this.identifierCol >= 0 && this.identifierCol < history.size();
        if ((!hasPosition || hasIdentifier && Variant2JSONPipe.isRsID((String)history.get(this.identifierCol))) && (result = this.processRsID(history, hasPosition)) != null) {
            if (hasPosition) {
                return this.validateResult(result);
            }
            return result;
        }
        this.mResults = this.getPossibleHistories(history);
        return this.mResults.remove(0);
    }

    private History validateResult(History result) {
        int last = result.size() - 1;
        String json = (String)result.get(last);
        String chromosome = this.parseChromosome((String)chromPath.read(json));
        String position = (String)posPath.read(json);
        String chrom = this.getFromColumn(result, this.chromosomeCol);
        String pos = this.getFromColumn(result, this.positionCol);
        if (!Variant2JSONPipe.isVCFEmpty(chrom) && !chrom.equalsIgnoreCase(chromosome) || !Variant2JSONPipe.isVCFEmpty(pos) && !pos.equals(position)) {
            result.set(last, (Object)this.addWarning(json, kPositionMatchFailedWarning));
        }
        return result;
    }

    private String getFromColumn(History result, int col) {
        if (col < 0) {
            return "";
        }
        return (String)result.get(col);
    }

    private String parseChromosome(String chromosome) {
        block9: {
            if (Variant2JSONPipe.isVCFEmpty(chromosome)) {
                return chromosome;
            }
            try {
                int chrom = Integer.parseInt(chromosome);
                switch (chrom) {
                    case 23: {
                        return "X";
                    }
                    case 24: {
                        return "Y";
                    }
                    case 25: {
                        return "XY";
                    }
                    case 26: {
                        return "M";
                    }
                }
            }
            catch (NumberFormatException oops) {
                if (!chromosome.equalsIgnoreCase("MT")) break block9;
                return "M";
            }
        }
        return chromosome;
    }

    private List<History> getPossibleHistories(History history) {
        ArrayList<History> results = new ArrayList<History>();
        String chrom = this.getFromColumn(history, this.chromosomeCol);
        String pos = this.getFromColumn(history, this.positionCol);
        String allele1 = this.getFromColumn(history, this.allele1Col);
        String allele2 = this.getFromColumn(history, this.allele2Col);
        if (this.invalidAllele(allele1) || this.invalidAllele(allele2)) {
            StringBuilder error = new StringBuilder(100);
            error.append(kAlleleErrorJSON1);
            if (this.invalidAllele(allele1)) {
                error.append(allele1);
            } else {
                error.append(allele2);
            }
            error.append("'\"}");
            results.add(Variant2JSONPipe.copyAppend(history, error.toString()));
            this.sender.write(Variant2JSONPipe.deJSON(error));
            return results;
        }
        if (pos.isEmpty() || !Variant2JSONPipe.isPositiveInteger(pos)) {
            StringBuilder error = new StringBuilder(100);
            error.append(kPosErrorJSON1);
            error.append(pos);
            error.append("'\"}");
            results.add(Variant2JSONPipe.copyAppend(history, error.toString()));
            this.sender.write(Variant2JSONPipe.deJSON(error));
            return results;
        }
        ModBool isValid = new ModBool(false);
        chrom = this.validChromosome(chrom, isValid);
        if (!isValid.isTrue()) {
            StringBuilder error = new StringBuilder(100);
            error.append("{\"ERROR\":\"Chromosome '");
            error.append(chrom);
            error.append("' is not valid\"}");
            results.add(Variant2JSONPipe.copyAppend(history, error.toString()));
            this.sender.write(Variant2JSONPipe.deJSON(error));
            return results;
        }
        try {
            String rsID;
            String ref;
            if (this.genome == null) {
                this.genome = this.getRefAssemblyFinder();
            }
            if ((ref = this.genome.getBasePairAtPosition(chrom, pos, pos)) == null || ref.equals(".")) {
                StringBuilder error = new StringBuilder(100);
                error.append("{\"ERROR\":\"Chromosome '");
                error.append(chrom);
                error.append(kChrPosErrorJSON2);
                error.append(pos);
                error.append("' is not valid\"}");
                results.add(Variant2JSONPipe.copyAppend(history, error.toString()));
                this.sender.write(Variant2JSONPipe.deJSON(error));
                return results;
            }
            int curBP = Integer.parseInt(pos);
            String warning = null;
            String string = rsID = this.identifierCol >= 0 ? (String)history.get(this.identifierCol) : "";
            if (Variant2JSONPipe.isRsID(rsID)) {
                warning = kNoRSIDFoundWarning + rsID;
            }
            if (!allele1.isEmpty() || !allele2.isEmpty()) {
                this.addWithAlleles(results, history, chrom, ref, allele1, allele2, curBP, warning);
            } else {
                for (String alt : kBases) {
                    if (alt.equals(ref)) continue;
                    results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, alt, curBP, curBP, warning)));
                }
            }
        }
        catch (NumberFormatException oops) {
            oops.printStackTrace();
            StringBuilder errorMesg = new StringBuilder();
            errorMesg.append("Invalid variant line at data line # ");
            errorMesg.append(this.dataLineNumber);
            errorMesg.append(".\nThe variant format requires an integer for position, but got '");
            errorMesg.append(pos);
            errorMesg.append("'.\n");
            errorMesg.append("Make sure the variant file has the necessary fields delimited by TAB characters.\n");
            errorMesg.append("Invalid variant line content: \"");
            errorMesg.append(history.getMergedData(kColDelimiter));
            errorMesg.append("\"");
            this.reportError(errorMesg.toString());
        }
        catch (IOException oops) {
            oops.printStackTrace();
            this.reportError("Could not open Genome Catalog");
        }
        catch (AssemblyNotSupportedException oops) {
            oops.printStackTrace();
            this.reportError("Could not open Genome Catalog");
        }
        return results;
    }

    private RefBasePairLookup getRefAssemblyFinder() throws IOException, AssemblyNotSupportedException {
        this.genome = Variant2JSONPipe.getRefAssemblyFinder(this.genomeBuild);
        return this.genome;
    }

    public static final RefBasePairLookup getRefAssemblyFinder(String build) throws IOException, AssemblyNotSupportedException {
        String baseDirRefAssemblyCatalogs = new RefAssemblyFinder().getBaseDirForRefAssemblyCatalogs();
        if (Variant2JSONPipe.isEmpty(baseDirRefAssemblyCatalogs)) {
            baseDirRefAssemblyCatalogs = genomeBasePath;
        }
        return new RefBasePairLookup(baseDirRefAssemblyCatalogs, build);
    }

    private boolean invalidAllele(String theAllele) {
        if (Variant2JSONPipe.isEmpty(theAllele)) {
            return false;
        }
        int size = theAllele.length();
        if (size == 1) {
            return !this.testAllele(theAllele);
        }
        for (int i = 0; i < size; ++i) {
            if (this.testAllele(theAllele.substring(i, i + 1))) continue;
            return true;
        }
        return false;
    }

    private boolean testAllele(String theAllele) {
        for (String testBase : kBases) {
            if (!testBase.equalsIgnoreCase(theAllele)) continue;
            return true;
        }
        return false;
    }

    protected static final boolean isPositiveInteger(String test) {
        try {
            return Integer.parseInt(test) > 0;
        }
        catch (NumberFormatException oops) {
            return false;
        }
    }

    protected static final boolean isNonNegativeInteger(String test) {
        try {
            return Integer.parseInt(test) >= 0;
        }
        catch (NumberFormatException oops) {
            return false;
        }
    }

    protected static final boolean isInteger(String test) {
        try {
            Integer.parseInt(test);
            return true;
        }
        catch (NumberFormatException oops) {
            return false;
        }
    }

    private static final String deJSON(StringBuilder error) {
        int pos;
        int length;
        if (error == null || (length = error.length()) == 0) {
            return "";
        }
        if (length < 2) {
            return error.toString();
        }
        if ('{' == error.charAt(0)) {
            error.delete(0, 1);
            if ('}' == error.charAt(--length - 1)) {
                error.delete(length - 1, length);
                --length;
            }
        }
        while ((pos = error.indexOf("\"")) >= 0) {
            error.delete(pos, pos + 1);
        }
        return error.toString();
    }

    private String validChromosome(String chrom, ModBool isValid) {
        try {
            int chr = Integer.valueOf(chrom);
            if (chr >= 1 && chr <= 26) {
                isValid.setValue(true);
                if (chr >= 23) {
                    for (int i = 0; i < kNumChangeChromosome; ++i) {
                        if (chr != kChromosomeNumbers[i]) continue;
                        return kChromosomeLetters[i];
                    }
                }
                return chrom;
            }
        }
        catch (NumberFormatException oops) {
            String testChr = chrom.toUpperCase();
            for (String test : kChromosomeLetters) {
                if (!test.equals(testChr)) continue;
                isValid.setValue(true);
                return chrom;
            }
        }
        isValid.setValue(false);
        return chrom;
    }

    private void addWithAlleles(List<History> results, History history, String chrom, String ref, String allele1, String allele2, int curBP, String warning) throws IOException {
        this.addWithAlleles(results, history, chrom, ref, allele1, allele2, curBP, warning, true);
    }

    private void addWithAlleles(List<History> results, History history, String chrom, String ref, String allele1, String allele2, int curBP, String warning, boolean recurse) throws IOException {
        String allele;
        int endBP = curBP;
        if (ref.equalsIgnoreCase(allele1)) {
            allele = allele2;
        } else if (allele1.length() > 1 && ref.equalsIgnoreCase(allele1.substring(0, 1))) {
            endBP = curBP + allele1.length() - 1;
            ref = allele1.toUpperCase();
            allele = allele2;
        } else if (ref.equalsIgnoreCase(allele2)) {
            allele = allele1;
        } else {
            String invert1 = Variant2JSONPipe.invert(allele1);
            if (invert1.equals(allele2)) {
                results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, allele1, curBP, endBP, warning)));
                results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, allele2, curBP, endBP, warning)));
            } else if (allele1.equals(allele2) || Variant2JSONPipe.isEmpty(allele2)) {
                results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, allele1, curBP, endBP, warning)));
            } else if (ref.equals("N")) {
                results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, allele1, curBP, endBP, warning)));
                results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, allele2, curBP, endBP, warning)));
            } else if (recurse) {
                if (allele1.length() > 1 || allele2.length() > 1) {
                    this.addInvertedIndel(results, history, chrom, curBP, allele1, allele2, warning);
                } else {
                    this.addWithAlleles(results, history, chrom, ref, invert1, Variant2JSONPipe.invert(allele2), curBP, warning, false);
                }
                History result = results.get(results.size() - 1);
                int last = result.size() - 1;
                String json = (String)result.get(last);
                result.set(last, (Object)this.addWarning(json, kFlipAllelesWarning));
            } else {
                results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, Variant2JSONPipe.invert(allele1), curBP, endBP, warning)));
                results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, Variant2JSONPipe.invert(allele2), curBP, endBP, warning)));
            }
            return;
        }
        if (!allele.isEmpty()) {
            results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, allele, curBP, endBP, warning)));
        } else {
            results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, ref, curBP, endBP, warning)));
        }
    }

    private void addInvertedIndel(List<History> results, History history, String chrom, int curBP, String allele1, String allele2, String warning) throws IOException {
        boolean insert;
        String pos = "" + --curBP;
        String ref = this.genome.getBasePairAtPosition(chrom, pos, pos);
        boolean bl = insert = allele2.length() > 1;
        if (insert) {
            String allele = ref + Variant2JSONPipe.invert(allele2.substring(1));
            results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, allele, curBP, curBP, warning)));
        } else {
            String allele = ref + Variant2JSONPipe.invert(allele1.substring(1));
            results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, allele, ref, curBP, curBP, warning)));
        }
    }

    private static final String invert(String allele) {
        int size = allele.length();
        if (size == 1) {
            return Variant2JSONPipe.invertBase(allele);
        }
        StringBuilder inverted = new StringBuilder(size);
        for (int i = size; i > 0; --i) {
            inverted.append(Variant2JSONPipe.invertBase(allele.substring(i - 1, i)));
        }
        return inverted.toString();
    }

    private static final String invertBase(String allele) {
        if (allele.equals("A")) {
            return "T";
        }
        if (allele.equals("T")) {
            return "A";
        }
        if (allele.equals("C")) {
            return "G";
        }
        return "C";
    }

    private static final String makeGoldenJSON(String chrom, String ref, String alt, int start, int end, String warning) {
        StringBuilder result = new StringBuilder(30);
        result.append('{');
        Variant2JSONPipe.addJSONString(result, "_landmark", chrom, false, false);
        Variant2JSONPipe.addJSONString(result, "_refAllele", ref, true, false);
        Variant2JSONPipe.addJSONString(result, "_altAlleles", alt, true, true);
        Variant2JSONPipe.addJSONInteger(result, "_minBP", start, true);
        Variant2JSONPipe.addJSONInteger(result, "_maxBP", end, true);
        if (warning != null) {
            Variant2JSONPipe.addJSONString(result, kWarning, warning, true, false);
        }
        result.append('}');
        return result.toString();
    }

    private String addWarning(String json, String warning) throws InvalidPipeInputException {
        ++this.warningCount;
        if (Variant2JSONPipe.isJSONEmpty(json)) {
            StringBuilder result = new StringBuilder(warning.length() + kWarningLen + 6);
            result.append("{\"");
            result.append(kWarning);
            result.append("\":\"");
            result.append(warning);
            result.append("\"}");
            return result.toString();
        }
        JsonParser parser = new JsonParser();
        JsonElement root = parser.parse(json);
        root.getAsJsonObject().addProperty(kWarning, warning);
        return root.toString();
    }

    private String addError(String json, String error) throws InvalidPipeInputException {
        System.err.print(kError);
        System.err.print(':');
        System.err.println(error);
        ++this.errorCount;
        if (Variant2JSONPipe.isJSONEmpty(json)) {
            StringBuilder result = new StringBuilder(error.length() + kErrorLen + 6);
            result.append("{\"");
            result.append(kError);
            result.append("\":\"");
            result.append(error);
            result.append("\"}");
            return result.toString();
        }
        JsonParser parser = new JsonParser();
        JsonElement root = parser.parse(json);
        root.getAsJsonObject().addProperty(kError, error);
        return root.toString();
    }

    private void reportError(String error) throws InvalidPipeInputException {
        this.sender.write(error);
        throw new InvalidPipeInputException(error, (Pipe)this);
    }

    private void reportTerminalError(String error) throws InvalidPipeInputException {
        throw new RuntimeException(error);
    }

    private static final void addJSONString(StringBuilder result, String key, String value, boolean havePrevious, boolean multi) {
        if (havePrevious) {
            result.append(',');
        }
        result.append('\"');
        result.append(key);
        result.append("\":");
        if (multi) {
            result.append('[');
        }
        result.append('\"');
        result.append(value);
        result.append('\"');
        if (multi) {
            result.append(']');
        }
    }

    private static final void addJSONInteger(StringBuilder result, String key, int value, boolean havePrevious) {
        if (havePrevious) {
            result.append(',');
        }
        result.append('\"');
        result.append(key);
        result.append("\":");
        result.append(value);
    }

    private static final boolean removeBlank(History history) {
        int size = history.size() - 1;
        String last = (String)history.get(size);
        if ("{}".equals(last)) {
            history.remove(size);
            return true;
        }
        return false;
    }

    private static final History copyAppend(History history, String result) {
        History clone = (History)history.clone();
        clone.add((Object)result);
        return clone;
    }

    private static final boolean isEmpty(String testStr) {
        return testStr == null || testStr.isEmpty();
    }

    private static final boolean isEmpty(History history) {
        if (history == null) {
            return true;
        }
        int size = history.size();
        if (size == 0) {
            return true;
        }
        if (size > 1) {
            return false;
        }
        return Variant2JSONPipe.isEmpty((String)history.get(0));
    }

    private static final boolean isVCFEmpty(String testStr) {
        return testStr == null || testStr.isEmpty() || testStr.equals(".");
    }

    private static final boolean isJSONEmpty(String testStr) {
        if (testStr == null) {
            return true;
        }
        return testStr.indexOf(58) < 0;
    }
}

