/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.bior.pipeline.VEP.VEPPipeline;
import edu.mayo.bior.util.ClasspathUtil;
import edu.mayo.bior.util.DependancyUtil;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class VEPCommand
implements CommandPlugin {
    private static final String OPTION_FORK = "f";
    private static final String OPTION_PIPELINE = "a";
    private static final String OPTION_PICKWORST = "all";
    private static final String OPTION_DASH = "-";
    private static final String OPTION_DOUBLEDASH = "--";
    private static final String OPTION_TERMS = "t";
    private static final String OPTION_PROTEIN = "protein";
    private static final String OPTION_NOINTERGENIC = "no_intergenic";
    private static final String OPTION_ONLYCODING = "conding_only";
    private static final String OPTION_CHECKEXISTING = "check_existing";
    private static final String OPTION_CHECKALLELES = "check_alleles";
    private static final String OPTION_ALLOWNONVARIANT = "allow_non_variant";
    private static final String OPTION_FREQPOP = "freq_pop";
    private static final String OPTION_FREQ = "freq_freq";
    private static final String OPTION_FREQGT = "freq_gt_lt";
    private static final String OPTION_FREQFILTER = "freq_filter";
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private String operation;
    private static final Logger sLogger = Logger.getLogger(VEPCommand.class);

    public void init(Properties props) throws Exception {
        this.operation = props.getProperty("command.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine line, Options options) throws Exception {
        if (!DependancyUtil.isVEPInstalled()) {
            System.exit(1);
        }
        boolean pickworst = Boolean.TRUE;
        if (line.hasOption(OPTION_PICKWORST)) {
            pickworst = Boolean.FALSE;
        }
        VEPPipeline vepPipeline = null;
        try {
            File dataSourceProps = ClasspathUtil.loadResource("/tools/vep.datasource.properties");
            File columnProps = ClasspathUtil.loadResource("/tools/vep.columns.tsv");
            Metadata metadata = new Metadata(dataSourceProps.getCanonicalPath(), columnProps.getCanonicalPath(), this.operation);
            vepPipeline = new VEPPipeline(this.getCommandLineOptions(line), pickworst);
            HistoryInPipe preLogic = new HistoryInPipe(metadata);
            VEPPipeline logic = vepPipeline;
            HistoryOutPipe postLogic = new HistoryOutPipe();
            this.mPipeline.execute(preLogic, logic, postLogic);
        }
        finally {
            if (vepPipeline != null) {
                try {
                    vepPipeline.terminate();
                }
                catch (InterruptedException e) {
                    sLogger.error((Object)e.getMessage());
                }
            }
        }
    }

    private String[] getCommandLineOptions(CommandLine line) {
        ArrayList<String> cmdoptions = new ArrayList<String>();
        if (line.hasOption(OPTION_FORK)) {
            cmdoptions.add("--f " + line.getOptionValue(OPTION_FORK));
        }
        if (line.hasOption(OPTION_ALLOWNONVARIANT)) {
            cmdoptions.add("--allow_non_variant");
        }
        if (line.hasOption(OPTION_CHECKALLELES)) {
            cmdoptions.add("--check_alleles");
        }
        if (line.hasOption(OPTION_NOINTERGENIC)) {
            cmdoptions.add("--no_intergenic");
        }
        if (line.hasOption(OPTION_ONLYCODING)) {
            cmdoptions.add("--conding_only");
        }
        if (line.hasOption(OPTION_PROTEIN)) {
            cmdoptions.add("--protein");
        }
        if (line.hasOption(OPTION_TERMS)) {
            cmdoptions.add("-t " + line.getOptionValue(OPTION_TERMS));
        }
        if (line.hasOption(OPTION_CHECKEXISTING)) {
            cmdoptions.add("--check_existing");
        }
        if (line.hasOption(OPTION_FREQPOP)) {
            cmdoptions.add("--freq_pop" + line.getOptionValue("OPTION_FREQPOP"));
        }
        return cmdoptions.toArray(new String[cmdoptions.size()]);
    }
}

