/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalogvalidator;

import edu.mayo.bior.catalogvalidator.CatalogTabixEntry;
import edu.mayo.bior.catalogvalidator.CatalogValidator;
import edu.mayo.bior.catalogvalidator.CatalogValidatorUtils;
import edu.mayo.bior.catalogvalidator.FileUtils;
import edu.mayo.bior.catalogvalidator.GoldenJsonVariant;
import edu.mayo.pipes.JSON.tabix.TabixReader;
import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class WholeCatalogValidationThread
extends Thread
implements Runnable {
    private String mCatFileNm = null;
    private List<String> mExpectChrOrder = null;
    private TreeMap<String, String> mBIORIndexMap_ColNameToFilePath = null;
    private CatalogValidator.CAT_ATTR_VAL_TYPE mValidationType = null;
    private boolean mIsPositionalCatalog = false;
    private CatalogValidatorUtils mCatalogUtil = null;
    public String NL = "\n";
    public final String DBL_QUOTE = "\"";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Set<Map.Entry<String, String>> biorIndexEntrySet = this.getBiorIndexMap().entrySet();
        TreeMap<String, CatalogTabixEntry> lastBiorIndexRecordSeen = new TreeMap<String, CatalogTabixEntry>();
        for (String key : this.getBiorIndexMap().keySet()) {
            lastBiorIndexRecordSeen.put(key, null);
        }
        ArrayList<String> catalogChrList_Seen = new ArrayList<String>();
        BufferedReader catalogRdr = null;
        CatalogTabixEntry previousRowTabixEntry = null;
        try {
            catalogRdr = FileUtils.getBufferedReader(this.mCatFileNm);
            TabixReader tabixReader = new TabixReader(this.mCatFileNm);
            String l = null;
            int lnCnt = 1;
            while ((l = catalogRdr.readLine()) != null) {
                CatalogTabixEntry currentRowTabixEntry;
                if (lnCnt % 1000000 == 0) {
                    this.mCatalogUtil.logMessage("WholeCatalogValidationThread.run(): Examining line [" + lnCnt++ + "]." + this.NL);
                }
                if ((currentRowTabixEntry = this.mCatalogUtil.readCatalogRow(l)) == null) {
                    this.getCatalogUtil().logMessage("WholeCatalogValidationThread.run(): Error: Could not read in catalog row as valid Tabix Entry: line: " + l + this.NL);
                    continue;
                }
                if (previousRowTabixEntry == null) {
                    catalogChrList_Seen.add(currentRowTabixEntry.getChromosome());
                    previousRowTabixEntry = currentRowTabixEntry;
                    continue;
                }
                for (String biorIndexKey : lastBiorIndexRecordSeen.keySet()) {
                    if (!currentRowTabixEntry.getJsonString().contains("\"" + biorIndexKey + "\"" + ":")) continue;
                    lastBiorIndexRecordSeen.put(biorIndexKey, currentRowTabixEntry);
                }
                if (this.mValidationType.equals((Object)CatalogValidator.CAT_ATTR_VAL_TYPE.NONVARIANT_ATTRIBUTES) && this.isPositionalCatalog() || this.mValidationType.equals((Object)CatalogValidator.CAT_ATTR_VAL_TYPE.HUMAN_VARIANT_ATTRIBUTES) || this.mValidationType.equals((Object)CatalogValidator.CAT_ATTR_VAL_TYPE.NONHUMAN_VARIANT_ATTRIBUTES)) {
                    if (previousRowTabixEntry.getChromosome().equals(currentRowTabixEntry.getChromosome())) {
                        GoldenJsonVariant previousVariant;
                        GoldenJsonVariant currentVariant;
                        if (previousRowTabixEntry.getMinPosition() > currentRowTabixEntry.getMinPosition()) {
                            this.mCatalogUtil.logMessage("Previous position [" + previousRowTabixEntry.getMinPosition() + "] within chromosome is greater than current row position [" + currentRowTabixEntry.getMinPosition() + "]. tabix catalog line: " + l + this.NL);
                        }
                        if ((currentVariant = this.mCatalogUtil.getGoldenJsonVariant(this.mCatalogUtil.getJsonObject(currentRowTabixEntry.getJsonString()))).equals(previousVariant = this.mCatalogUtil.getGoldenJsonVariant(this.mCatalogUtil.getJsonObject(previousRowTabixEntry.getJsonString())))) {
                            this.mCatalogUtil.logMessage("ERROR: previous [ _landmark:" + previousVariant.getChr() + " _minBP:" + previousVariant.getMinBP() + "] and current [ _landmark:" + currentVariant.getChr() + " _minBP:" + currentVariant.getMinBP() + "] catalog rows are equal variants, and should not be.");
                        }
                    } else {
                        boolean matchFirstEntry_NextChr;
                        if (catalogChrList_Seen.contains(currentRowTabixEntry.getChromosome())) {
                            this.mCatalogUtil.logMessage("Already saw this chr [" + currentRowTabixEntry.getChromosome() + "] in previous block of catalog. Line: " + l + this.NL);
                        } else {
                            catalogChrList_Seen.add(currentRowTabixEntry.getChromosome());
                        }
                        int currentLnChrIdx = this.mExpectChrOrder.indexOf(currentRowTabixEntry.getChromosome());
                        int previousLnChrIdx = this.mExpectChrOrder.indexOf(previousRowTabixEntry.getChromosome());
                        if (previousLnChrIdx > currentLnChrIdx) {
                            this.mCatalogUtil.logMessage("ERROR: Current catalog entry for chromosome [" + currentRowTabixEntry.getChromosome() + "] not in expected chromosome order. Previous chromosome catalog entries were for chromosome [" + this.mExpectChrOrder.get(previousLnChrIdx) + "], but the current catalog entry is for chromosome [" + this.mExpectChrOrder.get(currentLnChrIdx) + "]. Full Catalog Entry is: " + l + this.NL);
                        } else if (previousLnChrIdx >= currentLnChrIdx && currentLnChrIdx == previousLnChrIdx) {
                            throw new RuntimeException("ERROR: Unexpected code-path reached: Previous chr index in list [" + previousLnChrIdx + "] equal to current chr index in list [" + currentLnChrIdx + "]. Should NOT find this condition. Line: " + l);
                        }
                        boolean matchLastEntry_PrevChr = this.mCatalogUtil.isTabixRetrievalSuccessful(tabixReader, previousRowTabixEntry, TABIX_QUERY_ORDER.LAST_ELEM_IN_RESULT);
                        if (!matchLastEntry_PrevChr) {
                            this.mCatalogUtil.logMessage("ERROR: Failed to retrieve Tabix entry for last line of previous chromosome. Line: " + previousRowTabixEntry.getCatalogTabixLine() + this.NL);
                        }
                        if (!(matchFirstEntry_NextChr = this.mCatalogUtil.isTabixRetrievalSuccessful(tabixReader, currentRowTabixEntry, TABIX_QUERY_ORDER.FIRST_ELEM_IN_RESULT))) {
                            this.mCatalogUtil.logMessage("ERROR: Failed to retrieve Tabix entry for first line of new/next chromosome. Line: " + currentRowTabixEntry.getCatalogTabixLine() + this.NL);
                        }
                        for (Map.Entry<String, String> entry : biorIndexEntrySet) {
                            boolean matchedOneOrMoreBIORIndexResults_firstIDOnThisChr;
                            String currentBiorIndexKey = entry.getKey();
                            String keystr = "\"" + currentBiorIndexKey + "\"" + ":";
                            CatalogTabixEntry catEntryToUse = null;
                            if (previousRowTabixEntry.getJsonString().contains(keystr)) {
                                catEntryToUse = previousRowTabixEntry;
                            } else {
                                CatalogTabixEntry recordWithKeyLastSeen = (CatalogTabixEntry)lastBiorIndexRecordSeen.get(currentBiorIndexKey);
                                if (recordWithKeyLastSeen != null) {
                                    catEntryToUse = recordWithKeyLastSeen;
                                }
                            }
                            boolean matchedOneOrMoreBIORIndexResults_lastIDOnPrevChr = this.mCatalogUtil.isBiorIndexRetrievalSuccessful(new File(this.getCatalogFileName()), new File(entry.getValue()), currentBiorIndexKey, catEntryToUse);
                            if (!matchedOneOrMoreBIORIndexResults_lastIDOnPrevChr) {
                                this.mCatalogUtil.logMessage("ERROR: Failed to retrieve BIOR Index entry for last line of previous chromosome for key " + currentBiorIndexKey + ". Line: " + previousRowTabixEntry.getCatalogTabixLine() + this.NL);
                            }
                            catEntryToUse = null;
                            if (currentRowTabixEntry.getJsonString().contains(keystr)) {
                                catEntryToUse = currentRowTabixEntry;
                            } else {
                                CatalogTabixEntry recordWithKeyLastSeen = (CatalogTabixEntry)lastBiorIndexRecordSeen.get(currentBiorIndexKey);
                                if (recordWithKeyLastSeen != null) {
                                    catEntryToUse = recordWithKeyLastSeen;
                                }
                            }
                            if (matchedOneOrMoreBIORIndexResults_firstIDOnThisChr = this.mCatalogUtil.isBiorIndexRetrievalSuccessful(new File(this.getCatalogFileName()), new File(entry.getValue()), currentBiorIndexKey, catEntryToUse)) continue;
                            this.mCatalogUtil.logMessage("ERROR: Failed to retrieve BIOR Index entry for first line of new/next chromosome for key " + currentBiorIndexKey + ". Line: " + currentRowTabixEntry.getCatalogTabixLine() + this.NL);
                        }
                    }
                }
                previousRowTabixEntry = currentRowTabixEntry;
            }
            boolean matchLastEntry_PrevChr = this.mCatalogUtil.isTabixRetrievalSuccessful(tabixReader, previousRowTabixEntry, TABIX_QUERY_ORDER.LAST_ELEM_IN_RESULT);
            if (!matchLastEntry_PrevChr) {
                this.mCatalogUtil.logMessage("ERROR: Failed to retrieve Tabix entry for last line of file. Line: " + previousRowTabixEntry.getCatalogTabixLine() + this.NL);
            }
            for (Map.Entry<String, String> entry : biorIndexEntrySet) {
                boolean matchedOneOrMoreBIORIndexResults_lastIDOnPrevChr;
                String currentBiorIndexKey = entry.getKey();
                String keystr = "\"" + currentBiorIndexKey + "\"" + ":";
                CatalogTabixEntry catEntryToUse = null;
                if (previousRowTabixEntry.getJsonString().contains(keystr)) {
                    catEntryToUse = previousRowTabixEntry;
                } else {
                    CatalogTabixEntry recordWithKeyLastSeen = (CatalogTabixEntry)lastBiorIndexRecordSeen.get(currentBiorIndexKey);
                    if (recordWithKeyLastSeen != null) {
                        catEntryToUse = recordWithKeyLastSeen;
                    }
                }
                if (matchedOneOrMoreBIORIndexResults_lastIDOnPrevChr = this.mCatalogUtil.isBiorIndexRetrievalSuccessful(new File(this.getCatalogFileName()), new File(entry.getValue()), entry.getKey(), catEntryToUse)) continue;
                this.mCatalogUtil.logMessage("ERROR: Failed to retrieve BIOR Index entry for last line of file for key [" + entry.getKey() + "]. Line: " + previousRowTabixEntry.getCatalogTabixLine() + this.NL);
            }
            this.mCatalogUtil.logMessage("Order in which chromosomes seen within the catalog: " + catalogChrList_Seen);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Exception WholeCatalogValidationThread.run(): exception: " + e.getMessage());
        }
        finally {
            if (catalogRdr != null) {
                try {
                    catalogRdr.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String getCatalogFileName() {
        return this.mCatFileNm;
    }

    protected void setCatalogFileName(String catalogFileName) {
        this.mCatFileNm = catalogFileName;
    }

    protected void setExpectedChrOrderList(List<String> expectedChrOrder) {
        this.mExpectChrOrder = expectedChrOrder;
    }

    protected TreeMap<String, String> getBiorIndexMap() {
        return this.mBIORIndexMap_ColNameToFilePath;
    }

    protected void setBiorIndexMap(TreeMap<String, String> biorIndexMap) {
        this.mBIORIndexMap_ColNameToFilePath = biorIndexMap;
    }

    protected CatalogValidatorUtils getCatalogUtil() {
        return this.mCatalogUtil;
    }

    protected void setCatalogUtil(CatalogValidatorUtils ourCatalogUtil) {
        this.mCatalogUtil = ourCatalogUtil;
    }

    protected void setValidationType(CatalogValidator.CAT_ATTR_VAL_TYPE valType) {
        this.mValidationType = valType;
    }

    protected boolean isPositionalCatalog() {
        return this.mIsPositionalCatalog;
    }

    protected void setPositionalCatalogIndicator(boolean isPositionalCatalog) {
        this.mIsPositionalCatalog = isPositionalCatalog;
    }

    public static enum TABIX_QUERY_ORDER {
        FIRST_ELEM_IN_RESULT,
        LAST_ELEM_IN_RESULT;

    }
}

