/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalogvalidator;

import edu.mayo.bior.catalogvalidator.CatalogColumn;
import edu.mayo.bior.catalogvalidator.FileUtils;
import edu.mayo.cli.InvalidDataException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CatalogColumnsMap {
    private List<String> orderedColumnNameList = new ArrayList<String>();
    private TreeMap<String, CatalogColumn> columnMap = new TreeMap();
    Pattern aNumber = Pattern.compile("\\d+");

    public CatalogColumnsMap(String catalogColumnsTSVFile) throws Exception {
        this(new File(catalogColumnsTSVFile));
    }

    public CatalogColumnsMap(File catalogColumnsTSVFile) throws Exception {
        if (!FileUtils.fileExists(catalogColumnsTSVFile)) {
            throw new FileNotFoundException("Specified file does not exist: " + catalogColumnsTSVFile);
        }
        this.loadAndValidateContent(catalogColumnsTSVFile);
    }

    public CatalogColumn getColumn(String columnName) {
        return this.columnMap.get(columnName);
    }

    public List<String> getOrderedColumnNames() {
        return this.orderedColumnNameList;
    }

    private void loadAndValidateContent(File catalogColumnsTsvFile) throws InvalidDataException, Exception {
        BufferedReader r = null;
        try {
            r = FileUtils.getBufferedReader(catalogColumnsTsvFile.getAbsolutePath());
            String l = null;
            while ((l = r.readLine()) != null) {
                String line = l.trim();
                if (line.length() <= 0 || line.startsWith("#")) continue;
                String[] elems = line.split("\t");
                if (elems == null || elems.length != 5) {
                    r.close();
                    throw new InvalidDataException("CatalogColumnsMap: line not valid; not 5 columns for line: [" + line + "]. Not valid file format for: " + catalogColumnsTsvFile.getAbsolutePath());
                }
                String colNm = null;
                String dataType = null;
                String count = null;
                String description = null;
                String humanReadableName = null;
                if (this.isEmpty(elems[0])) {
                    r.close();
                    throw new InvalidDataException("CatalogColumnsMap: line not valid. Column name is empty. Please correct. Line is: [" + line + "]. Not valid file format for: " + catalogColumnsTsvFile.getAbsolutePath());
                }
                colNm = elems[0].trim();
                if (colNm.startsWith(".")) {
                    r.close();
                    throw new InvalidDataException("CatalogColumnsMap: line not valid. Column name starts with a '.'. Please correct. Line is: [" + line + "]. Not valid file format for: " + catalogColumnsTsvFile.getAbsolutePath());
                }
                this.orderedColumnNameList.add(colNm);
                if (this.isEmpty(elems[1])) {
                    r.close();
                    throw new InvalidDataException("CatalogColumnsMap: line not valid. Data Type value is empty for line: " + line);
                }
                dataType = elems[1].trim();
                if (this.isEmpty(elems[2])) {
                    r.close();
                    throw new InvalidDataException("CatalogColumnsMap: line not valid. Count value is empty for line: " + line);
                }
                count = elems[2].trim();
                Matcher numberMatcher = this.aNumber.matcher(count);
                if (!count.equals(".") && count.equals("A") && !numberMatcher.matches()) {
                    r.close();
                    throw new InvalidDataException("CatalogColumnsMap: line not valid; count not an '.', 'A', or a number. Line is: [" + line + "]. Not valid file format for: " + catalogColumnsTsvFile.getAbsolutePath());
                }
                if (this.isEmpty(elems[3])) {
                    r.close();
                    throw new InvalidDataException("CatalogColumnsMap: line not valid. Description value is empty for line: " + line);
                }
                description = elems[3].trim();
                if (this.isEmpty(elems[4])) {
                    r.close();
                    throw new InvalidDataException("CatalogColumnsMap: line not valid. Human readable name is empty for line: " + line);
                }
                humanReadableName = elems[4].trim();
                this.columnMap.put(colNm, new CatalogColumn(colNm, dataType, count, description, humanReadableName));
            }
        }
        catch (InvalidDataException inv) {
            r.close();
            throw inv;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private CatalogColumnsMap() {
    }
}

