/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physprop;

import flanagan.physprop.Water;

public class Pva {
    public static double viscosity(double concn, double molwt, double temp) {
        double intVisc30 = 4.53E-4 * Math.pow(molwt, 0.64);
        double intVisc20 = intVisc30 * 1.07;
        double intViscT = intVisc20 * Math.pow(1.07, -(temp - 20.0) / 10.0);
        double concndlpg = concn / 10.0;
        double spViscT = concndlpg * (intViscT + 0.201 * concndlpg * Math.pow(intViscT, 2.28));
        double waterViscT = Water.viscosity(temp);
        double viscosity = (spViscT + 1.0) * waterViscT;
        return viscosity;
    }

    public static double density(double concn, double molwt) {
        double density = 1000.0 * (0.99565 + (0.00248 - 1.09 / molwt) * (concn /= 10.0) + (6.4E-5 - 0.39 / molwt) * concn * concn);
        return density;
    }

    public static double specificVolume() {
        return 7.65E-4;
    }

    public static double diffCoeff(double concn, double molwt, double temp) {
        double tempa = temp - -273.15;
        double viscosity = Pva.viscosity(concn, molwt, temp);
        double specvol = Pva.specificVolume();
        double vol = molwt * specvol / 6.0221419947E26;
        double radius = Math.pow(3.0 * vol / (Math.PI * 4), 0.3333333333333333);
        double f = Math.PI * 6 * viscosity * radius;
        double diffcoef = 1.380650324E-23 * tempa / f;
        return diffcoef;
    }

    public static double refractIndex(double concn, double wavl, double temp) {
        double a1 = -0.998419;
        double b1 = -1.87778E-17;
        double rfwater = Water.refractIndex(wavl, temp);
        double rfincr = 1.0 + a1 * (1.0 + b1 / Math.pow(wavl, 2.0));
        double refind = rfwater + rfincr * concn / 10.0;
        return refind;
    }
}

