/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;

public class Compensator
extends BlackBox {
    private double kConst = 1.0;
    private double aConst = 1.0;
    private double bConst = 1.0;

    public Compensator() {
        super("Compensator");
        this.sZeros = Complex.oneDarray(1);
        this.sPoles = Complex.oneDarray(1);
        super.setSnumer(new ComplexPoly(1.0, 1.0));
        super.setSdenom(new ComplexPoly(1.0, 1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public Compensator(double kk, double aa, double bb) {
        super("Compensator");
        this.aConst = aa;
        this.bConst = bb;
        this.kConst = kk;
        this.sZeros = Complex.oneDarray(1);
        this.sPoles = Complex.oneDarray(1);
        super.setSnumer(new ComplexPoly(this.aConst * this.kConst, this.kConst));
        super.setSdenom(new ComplexPoly(this.bConst, 1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public void setCoeff(double kk, double aa, double bb) {
        this.aConst = aa;
        this.bConst = bb;
        this.kConst = kk;
        Complex[] num = Complex.oneDarray(2);
        num[0].reset(this.aConst * this.kConst, 0.0);
        num[1].reset(this.kConst, 0.0);
        this.sNumer.resetPoly(num);
        Complex[] den = Complex.oneDarray(2);
        den[0].reset(this.bConst, 0.0);
        den[1].reset(1.0, 0.0);
        this.sDenom.resetPoly(den);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setK(double kk) {
        this.kConst = kk;
        Complex co = new Complex(this.aConst * this.kConst, 0.0);
        this.sNumer.resetCoeff(0, co);
        co = new Complex(this.kConst, 0.0);
        this.sNumer.resetCoeff(1, co);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setA(double aa) {
        this.aConst = aa;
        Complex co = new Complex(this.aConst * this.kConst, 0.0);
        this.sNumer.resetCoeff(0, co);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setB(double bb) {
        this.bConst = bb;
        Complex co = new Complex(this.bConst, 0.0);
        this.sDenom.resetCoeff(0, co);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public double getA() {
        return this.aConst;
    }

    public double getB() {
        return this.bConst;
    }

    public double getK() {
        return this.kConst;
    }

    @Override
    public void calcPolesZerosS() {
        this.sZeros[0].setReal(-this.aConst);
        this.sPoles[0].setReal(-this.bConst);
        this.sNumerScaleFactor = BlackBox.scaleFactor(this.sNumer, this.sZeros);
        this.sDenomScaleFactor = BlackBox.scaleFactor(this.sDenom, this.sPoles);
    }

    @Override
    public Compensator copy() {
        if (this == null) {
            return null;
        }
        Compensator bb = new Compensator();
        this.copyBBvariables(bb);
        bb.kConst = this.kConst;
        bb.aConst = this.aConst;
        bb.bConst = this.bConst;
        return bb;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

